/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.util.io.MonitorableInputStream;
import com.compomics.util.protein.Protein;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public abstract class ZippedDBLoader
implements DBLoader {
    protected static final boolean debug = false;
    protected BufferedReader iBr = null;
    protected String iFilename = null;
    protected MonitorableInputStream iInputStream = null;
    protected boolean iCancelCount = false;

    public void load(String aFilename) throws IOException {
        File lFile = new File(aFilename);
        if (!lFile.exists()) {
            throw new IOException("File '" + aFilename + "' does not exist!");
        }
        boolean gzip = false;
        try {
            ZipFile zf = new ZipFile(aFilename);
            if (zf.size() > 1) {
                throw new IOException("Unable to load a zip file (" + aFilename + ") with more than one entry!");
            }
            zf.close();
        }
        catch (ZipException ze) {
            gzip = true;
        }
        this.iInputStream = new MonitorableInputStream((InputStream)new FileInputStream(aFilename), true);
        if (!gzip) {
            ZipInputStream zis = new ZipInputStream(this.iInputStream);
            zis.getNextEntry();
            this.iBr = new BufferedReader(new InputStreamReader(zis));
        } else {
            this.iBr = new BufferedReader(new InputStreamReader(new GZIPInputStream(this.iInputStream)));
        }
        this.iFilename = aFilename;
    }

    public void finalize() {
        this.close();
    }

    public boolean canReadFile(File aFile) {
        return false;
    }

    public String nextFilteredRawEntry(Filter aFilter) throws IOException {
        String result = null;
        boolean lContinue = true;
        while (lContinue) {
            String tempString = this.nextRawEntry();
            if (tempString == null) {
                lContinue = false;
                continue;
            }
            if (!aFilter.passesFilter(tempString)) continue;
            result = tempString;
            lContinue = false;
        }
        return result;
    }

    public Protein nextProtein() throws IOException {
        Protein p = null;
        String fasta = this.nextFASTAEntry();
        if (fasta != null) {
            p = new Protein(fasta);
        }
        return p;
    }

    public Protein nextFilteredProtein(Filter aFilter) throws IOException {
        Protein p = null;
        String fasta = this.nextFilteredFASTAEntry(aFilter);
        if (fasta != null) {
            p = new Protein(fasta);
        }
        return p;
    }

    public void reset() throws IOException {
        this.iBr.close();
        this.iInputStream.close();
        try {
            ZipFile zf = new ZipFile(this.iFilename);
            if (zf.size() > 1) {
                throw new IOException("Unable to load a zip file (" + this.iFilename + ") with more than one entry!");
            }
            zf.close();
            this.iInputStream = new MonitorableInputStream((InputStream)new FileInputStream(this.iFilename), true);
            ZipInputStream zis = new ZipInputStream(this.iInputStream);
            zis.getNextEntry();
            this.iBr = new BufferedReader(new InputStreamReader(zis));
        }
        catch (ZipException ze) {
            this.iInputStream = new MonitorableInputStream((InputStream)new FileInputStream(this.iFilename), true);
            this.iBr = new BufferedReader(new InputStreamReader(new GZIPInputStream(this.iInputStream)));
        }
    }

    public int getMaximum() {
        return this.iInputStream.getMaximum();
    }

    public int monitorProgress() {
        return this.iInputStream.monitorProgress();
    }

    public void cancelCount() {
        this.iCancelCount = true;
    }

    public void close() {
        try {
            if (this.iBr != null) {
                this.iBr.close();
                this.iBr = null;
            }
            if (this.iInputStream != null) {
                this.iInputStream.close();
                this.iInputStream = null;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected BufferedReader getReader(File aFile) throws IOException {
        BufferedReader result = null;
        try {
            try {
                ZipFile zf = new ZipFile(aFile);
                Enumeration<? extends ZipEntry> lEnum = zf.entries();
                ZipEntry ze = null;
                int counter = 0;
                while (lEnum.hasMoreElements()) {
                    ze = lEnum.nextElement();
                    if (++counter <= 1) continue;
                    throw new IOException("Can only read files with a single entry!");
                }
                if (ze != null) {
                    result = new BufferedReader(new InputStreamReader(zf.getInputStream(ze)));
                }
            }
            catch (ZipException ze) {
                result = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(aFile))));
            }
        }
        catch (Throwable t) {
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("Unable to open zip file! Message: " + t.getMessage() + ".");
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new GZIPInputStream(new MonitorableInputStream(new FileInputStream(args[0])))));
            for (int i = 0; i < 1000; ++i) {
                System.out.println(br.readLine());
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

