/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

import com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import java.io.IOException;
import java.util.HashMap;

public class SwissProtTaxonomyFilter
implements Filter {
    private SwissProtDBLoader iSpdb = new SwissProtDBLoader();
    private final String iMatch;
    private boolean iInvert = false;

    public SwissProtTaxonomyFilter(String aMatch) {
        this.iMatch = aMatch.toUpperCase();
    }

    public SwissProtTaxonomyFilter(String aMatch, boolean aInvert) {
        this.iMatch = aMatch.toUpperCase();
        this.iInvert = aInvert;
    }

    public boolean passesFilter(String aEntry) {
        boolean passed = false;
        try {
            HashMap lRaw = this.iSpdb.processRawData(aEntry);
            passed = this.passesFilter(lRaw);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return passed;
    }

    public boolean passesFilter(HashMap aEntry) {
        boolean passed = false;
        Object os = aEntry.get("OS");
        Object oc = aEntry.get("OC");
        if (os != null) {
            if (((String)os).toUpperCase().indexOf(this.iMatch) >= 0) {
                passed = true;
            } else if (oc != null && ((String)oc).toUpperCase().indexOf(this.iMatch) >= 0) {
                passed = true;
            }
        }
        if (this.iInvert) {
            passed = !passed;
        }
        return passed;
    }
}

