/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

import com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class SwissProtNCBITaxonomyFilter
implements Filter {
    private SwissProtDBLoader iSpdb = new SwissProtDBLoader();
    private Collection iMatch;
    private boolean iInvert = false;

    public SwissProtNCBITaxonomyFilter(String aMatchLine) {
        this.processMatchLine(aMatchLine);
    }

    public SwissProtNCBITaxonomyFilter(String aMatch, boolean aInvert) {
        this.processMatchLine(aMatch);
        this.iInvert = aInvert;
    }

    public boolean passesFilter(String aEntry) {
        boolean passed = false;
        try {
            HashMap lRaw = this.iSpdb.processRawData(aEntry);
            passed = this.passesFilter(lRaw);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return passed;
    }

    public boolean passesFilter(HashMap aEntry) {
        boolean passed = false;
        Object ox = aEntry.get("OX");
        if (ox != null) {
            Iterator lIterator = this.iMatch.iterator();
            while (lIterator.hasNext()) {
                String match = "NCBI_TAXID=" + lIterator.next() + ";";
                if (((String)ox).toUpperCase().indexOf(match) < 0) continue;
                passed = true;
                break;
            }
        }
        if (this.iInvert) {
            passed = !passed;
        }
        return passed;
    }

    private void processMatchLine(String aMatchLine) {
        StringTokenizer st = new StringTokenizer(aMatchLine.toUpperCase().trim(), ", ;");
        int count = st.countTokens();
        this.iMatch = new ArrayList(count);
        while (st.hasMoreTokens()) {
            this.iMatch.add(st.nextToken().trim());
        }
    }
}

