/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

import com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SwissProtAccessionFilter
implements Filter {
    private SwissProtDBLoader iSpdb = new SwissProtDBLoader();
    private Set iAccList = new HashSet();
    private boolean iInvert = false;

    public SwissProtAccessionFilter(String accessions) {
        this(accessions, false);
    }

    public SwissProtAccessionFilter(String accessions, boolean aInvert) {
        String[] tmp = accessions.split(",");
        for (int i = 0; i < tmp.length; ++i) {
            String s = tmp[i].trim().intern();
            this.iAccList.add(s);
        }
        this.iInvert = aInvert;
    }

    public SwissProtAccessionFilter(List aAccList) {
        this(aAccList, false);
    }

    public SwissProtAccessionFilter(List aAccList, boolean aInvert) {
        for (Object o : aAccList) {
            String acc = null;
            if (o instanceof String) {
                acc = (String)o;
            }
            if (acc == null) continue;
            this.iAccList.add(acc.toUpperCase());
        }
        this.iInvert = aInvert;
    }

    public boolean passesFilter(String aEntry) {
        boolean passed = false;
        try {
            HashMap lRaw = this.iSpdb.processRawData(aEntry);
            passed = this.passesFilter(lRaw);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return passed;
    }

    public boolean passesFilter(HashMap aEntry) {
        boolean passed = false;
        Object ac = aEntry.get("AC");
        if (ac != null) {
            String[] accs = ((String)ac).split(";");
            for (int i = 0; i < accs.length; ++i) {
                String acc = accs[i].trim().intern();
                if (!this.iAccList.contains(acc)) continue;
                passed = true;
            }
        }
        if (this.iInvert) {
            passed = !passed;
        }
        return passed;
    }
}

