/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

public class SequenceRegion {
    private String iAccession = null;
    private String iSequence = null;
    private String iNtermAdd = null;
    private String iCtermAdd = null;
    private int iNtermResidues = 0;
    private int iCtermResidues = 0;
    private boolean iFound = false;
    private boolean iQueried = false;

    public SequenceRegion(String aAccession, String aSequence, int aResidues) {
        this(aAccession, aSequence, aResidues, aResidues);
    }

    public SequenceRegion(String aAccession, String aSequence, int aNtermResidues, int aCtermResidues) {
        this.iAccession = aAccession;
        this.iSequence = aSequence;
        this.iNtermResidues = aNtermResidues;
        this.iCtermResidues = aCtermResidues;
        this.iFound = false;
        this.iQueried = false;
    }

    public String getAccession() {
        return this.iAccession;
    }

    public String getQuerySequence() {
        return this.iSequence;
    }

    public String getRetrievedSequence() {
        String result = null;
        if (this.iQueried && this.iFound) {
            result = this.iNtermAdd + this.iSequence + this.iCtermAdd;
        }
        return result;
    }

    public String getNterminalAddition() {
        return this.iNtermAdd;
    }

    public String getCterminalAddition() {
        return this.iCtermAdd;
    }

    public int getNterminalResidueCount() {
        return this.iNtermResidues;
    }

    public int getCterminalResidueCount() {
        return this.iCtermResidues;
    }

    public boolean isQueried() {
        return this.iQueried;
    }

    public boolean isFound() {
        return this.iFound;
    }

    public void setQueried(boolean aQueried) {
        this.iQueried = aQueried;
    }

    public void setFound(boolean aFound) {
        this.iFound = aFound;
    }

    public void setNterminalAddition(String aNterm) {
        this.iNtermAdd = aNterm;
    }

    public void setCterminalAddition(String aCterm) {
        this.iCtermAdd = aCterm;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SequenceRegion with:\n");
        sb.append("\t- Accession: '" + this.iAccession + "'\n");
        sb.append("\t- Query sequence: '" + this.iSequence + "'\n");
        sb.append("\t- N-term and C-term residues: " + this.iNtermResidues + "; " + this.iCtermResidues + "\n");
        sb.append("\t- Queried: " + this.iQueried + "\n");
        sb.append("\t- Found: " + this.iFound + "\n");
        sb.append("\t- Nterm addition: '" + this.iNtermAdd + "'\n");
        sb.append("\t- Cterm addition: '" + this.iCtermAdd + "'\n");
        return sb.toString();
    }
}

