/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

import com.compomics.dbtoolkit.io.interfaces.ProteinFilter;
import com.compomics.util.protein.Protein;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProteinSequenceRegExpFilter
implements ProteinFilter {
    private Pattern iRegExp = null;
    private boolean iInvert = false;

    public ProteinSequenceRegExpFilter(Pattern aRegExp) {
        this(aRegExp, false);
    }

    public ProteinSequenceRegExpFilter(Pattern aRegExp, boolean aInvert) {
        this.iRegExp = aRegExp;
        this.setInversion(aInvert);
    }

    public boolean passesFilter(Protein aProtein) {
        boolean result = false;
        String sequence = aProtein.getSequence().getSequence();
        Matcher sequenceMatcher = this.iRegExp.matcher(sequence);
        if (sequenceMatcher.find()) {
            result = true;
        }
        if (this.iInvert) {
            result = !result;
        }
        return result;
    }

    public void setInversion(boolean aInvert) {
        this.iInvert = aInvert;
    }
}

