/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

import com.compomics.dbtoolkit.io.interfaces.ProteinFilter;
import com.compomics.util.protein.Protein;
import java.util.regex.Pattern;

public class ProteinSequenceFilter
implements ProteinFilter {
    private String iSequenceMatch = null;
    private Pattern iPattern = null;
    private boolean iInclusive = true;
    private boolean iInitMetCounts = true;

    public ProteinSequenceFilter(String aCodedSequence) {
        while (aCodedSequence.startsWith("!")) {
            aCodedSequence = aCodedSequence.substring(1);
            this.iInclusive = false;
        }
        if (aCodedSequence.indexOf("U") >= 0) {
            this.iInitMetCounts = false;
            aCodedSequence = aCodedSequence.replace('U', 'M');
        }
        this.iSequenceMatch = aCodedSequence;
        if (this.iSequenceMatch.indexOf(".") >= 0) {
            this.iPattern = Pattern.compile(this.iSequenceMatch);
        }
    }

    public void setInversion(boolean aInvert) {
        this.iInclusive = aInvert;
    }

    public boolean passesFilter(Protein aProtein) {
        boolean result = false;
        String toVerify = aProtein.getSequence().getSequence();
        if (!this.iInitMetCounts && toVerify.startsWith("M")) {
            toVerify = toVerify.substring(1);
        }
        if (this.iPattern != null) {
            if (this.iPattern.matcher(toVerify).find()) {
                result = true;
            }
        } else if (toVerify.indexOf(this.iSequenceMatch) >= 0) {
            result = true;
        }
        if (!this.iInclusive) {
            result = !result;
        }
        return result;
    }

    public String toString() {
        StringBuffer lsb = new StringBuffer("ProteinSequenceFilter for the ");
        if (this.iInclusive) {
            lsb.append("presence");
        } else {
            lsb.append("absence");
        }
        lsb.append(" of " + this.iSequenceMatch);
        if (!this.iInitMetCounts) {
            lsb.append(" (in which initiator methionines are considered cleaved off)");
        }
        lsb.append(".");
        return lsb.toString();
    }
}

