/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

import com.compomics.dbtoolkit.io.interfaces.ProteinFilter;
import com.compomics.util.protein.Protein;

public class ProteinResiduCountFilter
implements ProteinFilter {
    private int iCount = 0;
    private int iMode = 0;
    private String iResidu = null;
    private boolean iInvert = false;
    private boolean iInitMetCounts = true;
    public static final int GREATER_THAN = 1;
    public static final int LESS_THAN = 2;
    public static final int EQUALS_TO = 3;

    public ProteinResiduCountFilter(String aResidu, int aCount, int aMode) {
        this(aResidu, aCount, aMode, false);
    }

    public ProteinResiduCountFilter(String aResidu, int aCount, int aMode, boolean aInvert) {
        if (aResidu.indexOf("U") >= 0) {
            this.iInitMetCounts = false;
            aResidu = aResidu.replace('U', 'M');
        } else {
            this.iInitMetCounts = true;
        }
        this.iResidu = aResidu;
        this.iCount = aCount;
        this.iMode = aMode;
        this.iInvert = aInvert;
    }

    public boolean passesFilter(Protein aProtein) {
        boolean result = false;
        int counter = 0;
        int index = -1;
        int tempIndex = -1;
        String sequence = aProtein.getSequence().getSequence();
        if (!this.iInitMetCounts && sequence.startsWith("M")) {
            sequence = sequence.substring(1);
        }
        while ((index = sequence.indexOf(this.iResidu, tempIndex)) >= 0) {
            ++counter;
            tempIndex = index + 1;
        }
        switch (this.iMode) {
            case 3: {
                if (counter != this.iCount) break;
                result = true;
                break;
            }
            case 1: {
                if (counter <= this.iCount) break;
                result = true;
                break;
            }
            case 2: {
                if (counter >= this.iCount) break;
                result = true;
            }
        }
        if (this.iInvert) {
            result = !result;
        }
        return result;
    }

    public void setInversion(boolean aInvert) {
        this.iInvert = aInvert;
    }

    public String toString() {
        StringBuffer lsb = new StringBuffer("ProteinResiduCountFilter for  ");
        if (!this.iInvert) {
            if (this.iMode == 3) {
                lsb.append("an exact number of ");
            } else if (this.iMode == 1) {
                lsb.append("strictly more than ");
            } else if (this.iMode == 2) {
                lsb.append("strictly less than ");
            }
        } else if (this.iMode == 3) {
            lsb.append("a number different from ");
        } else if (this.iMode == 1) {
            lsb.append("equal to or less than ");
        } else if (this.iMode == 2) {
            lsb.append("equals to or greater than ");
        }
        lsb.append(this.iCount + " residu" + (this.iCount == 0 || this.iCount > 1 ? "es" : ""));
        if (!this.iInitMetCounts) {
            lsb.append(" (in which initiator methionines are considered to be cleaved off)");
        }
        lsb.append(".");
        return lsb.toString();
    }
}

