/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

import com.compomics.dbtoolkit.io.interfaces.ProteinFilter;
import com.compomics.util.protein.Protein;

public class ProteinMassFilter
implements ProteinFilter {
    private double iLower = Double.MIN_VALUE;
    private double iUpper = Double.MAX_VALUE;
    private boolean iInvert = false;

    public ProteinMassFilter(double aLower, double aUpper) {
        this(aLower, aUpper, false);
    }

    public ProteinMassFilter(double aLower, double aUpper, boolean aInvert) {
        this.iLower = aLower;
        this.iUpper = aUpper;
        this.setInversion(aInvert);
    }

    public boolean passesFilter(Protein aProtein) {
        boolean result = false;
        double tempMass = aProtein.getMass();
        if (tempMass <= this.iUpper && tempMass >= this.iLower) {
            result = true;
        }
        if (this.iInvert) {
            result = !result;
        }
        return result;
    }

    public void setInversion(boolean aInvert) {
        this.iInvert = aInvert;
    }
}

