/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

import com.compomics.dbtoolkit.io.interfaces.ProteinFilter;
import com.compomics.util.protein.Protein;
import java.util.Vector;

public class ProteinFilterCollection
extends Vector
implements ProteinFilter {
    public static final int AND = 0;
    public static final int OR = 1;
    private int iMode = -1;
    private boolean iInvert = false;

    public ProteinFilterCollection(int aMode) {
        this.iMode = aMode;
    }

    public ProteinFilterCollection(int aMode, int aInitialCapacity, int aCapacityIncrement) {
        super(aInitialCapacity, aCapacityIncrement);
        this.iMode = aMode;
    }

    public ProteinFilterCollection(int aMode, boolean aInvert) {
        this.iMode = aMode;
        this.iInvert = aInvert;
    }

    public ProteinFilterCollection(int aMode, boolean aInvert, int aInitialCapacity, int aCapacityIncrement) {
        super(aInitialCapacity, aCapacityIncrement);
        this.iMode = aMode;
        this.iInvert = aInvert;
    }

    public boolean passesFilter(Protein aProtein) {
        boolean result = false;
        switch (this.iMode) {
            case 0: {
                result = this.evaluateANDFilters(aProtein);
                break;
            }
            case 1: {
                result = this.evaluateORFilters(aProtein);
                break;
            }
            default: {
                result = false;
            }
        }
        if (this.iInvert) {
            result = !result;
        }
        return result;
    }

    public void setInversion(boolean aInvert) {
        this.iInvert = aInvert;
    }

    private boolean evaluateANDFilters(Protein aProtein) {
        boolean result = true;
        int liSize = this.size();
        for (int i = 0; i < liSize; ++i) {
            ProteinFilter f;
            Object temp = this.get(i);
            if (!(temp instanceof ProteinFilter) || (f = (ProteinFilter)temp).passesFilter(aProtein)) continue;
            result = false;
        }
        return result;
    }

    private boolean evaluateORFilters(Protein aProtein) {
        boolean result = false;
        int liSize = this.size();
        for (int i = 0; i < liSize; ++i) {
            ProteinFilter f;
            Object temp = this.get(i);
            if (!(temp instanceof ProteinFilter) || !(f = (ProteinFilter)temp).passesFilter(aProtein)) continue;
            result = true;
        }
        return result;
    }
}

