/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

import com.compomics.dbtoolkit.io.interfaces.Filter;
import java.util.HashMap;
import java.util.Vector;

public class FilterCollection
extends Vector
implements Filter {
    public static final int AND = 0;
    public static final int OR = 1;
    private int iMode = -1;
    private boolean iInvert = false;

    public FilterCollection(int aMode) {
        this.iMode = aMode;
    }

    public FilterCollection(int aMode, int aInitialCapacity, int aCapacityIncrement) {
        super(aInitialCapacity, aCapacityIncrement);
        this.iMode = aMode;
    }

    public FilterCollection(int aMode, boolean aInvert) {
        this.iMode = aMode;
        this.iInvert = aInvert;
    }

    public FilterCollection(int aMode, boolean aInvert, int aInitialCapacity, int aCapacityIncrement) {
        super(aInitialCapacity, aCapacityIncrement);
        this.iMode = aMode;
        this.iInvert = aInvert;
    }

    public boolean passesFilter(String aEntry) {
        boolean result = false;
        switch (this.iMode) {
            case 0: {
                result = this.evaluateANDFilters(aEntry);
                break;
            }
            case 1: {
                result = this.evaluateORFilters(aEntry);
                break;
            }
            default: {
                result = false;
            }
        }
        if (this.iInvert) {
            result = !result;
        }
        return result;
    }

    public boolean passesFilter(HashMap aEntry) {
        boolean result = false;
        switch (this.iMode) {
            case 0: {
                result = this.evaluateANDFilters(aEntry);
                break;
            }
            case 1: {
                result = this.evaluateORFilters(aEntry);
                break;
            }
            default: {
                result = false;
            }
        }
        if (this.iInvert) {
            result = !result;
        }
        return result;
    }

    private boolean evaluateANDFilters(String aEntry) {
        boolean result = true;
        int liSize = this.size();
        for (int i = 0; i < liSize; ++i) {
            Filter f;
            Object temp = this.get(i);
            if (!(temp instanceof Filter) || (f = (Filter)temp).passesFilter(aEntry)) continue;
            result = false;
        }
        return result;
    }

    private boolean evaluateANDFilters(HashMap aEntry) {
        boolean result = true;
        int liSize = this.size();
        for (int i = 0; i < liSize; ++i) {
            Filter f;
            Object temp = this.get(i);
            if (!(temp instanceof Filter) || (f = (Filter)temp).passesFilter(aEntry)) continue;
            result = false;
        }
        return result;
    }

    private boolean evaluateORFilters(String aEntry) {
        boolean result = false;
        int liSize = this.size();
        for (int i = 0; i < liSize; ++i) {
            Filter f;
            Object temp = this.get(i);
            if (!(temp instanceof Filter) || !(f = (Filter)temp).passesFilter(aEntry)) continue;
            result = true;
        }
        return result;
    }

    private boolean evaluateORFilters(HashMap aEntry) {
        boolean result = false;
        int liSize = this.size();
        for (int i = 0; i < liSize; ++i) {
            Filter f;
            Object temp = this.get(i);
            if (!(temp instanceof Filter) || !(f = (Filter)temp).passesFilter(aEntry)) continue;
            result = true;
        }
        return result;
    }
}

