/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

import com.compomics.dbtoolkit.io.implementations.FASTADBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import java.util.HashMap;
import java.util.StringTokenizer;

public class FASTAHeaderFilter
implements Filter {
    private FASTADBLoader iDB = new FASTADBLoader();
    protected final String iMatch;
    protected boolean iInvert = false;
    public static final String HEADER = "HEADER";
    public static final String SEQUENCE = "SEQUENCE";

    public FASTAHeaderFilter(String aMatch) {
        this.iMatch = aMatch.toUpperCase();
    }

    public FASTAHeaderFilter(String aMatch, boolean aInvert) {
        this.iMatch = aMatch.toUpperCase();
        this.iInvert = aInvert;
    }

    public boolean passesFilter(String aEntry) {
        boolean passed = false;
        HashMap<String, String> hm = new HashMap<String, String>(2);
        StringTokenizer lSt = new StringTokenizer(aEntry, "\n");
        hm.put(HEADER, lSt.nextToken());
        hm.put(SEQUENCE, lSt.nextToken());
        passed = this.passesFilter(hm);
        return passed;
    }

    public boolean passesFilter(HashMap aEntry) {
        boolean passed = false;
        Object os = aEntry.get(HEADER);
        if (os != null && ((String)os).toUpperCase().indexOf(this.iMatch) >= 0) {
            passed = true;
        }
        if (this.iInvert) {
            passed = !passed;
        }
        return passed;
    }
}

