/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.util.io.MonitorableFileInputStream;
import com.compomics.util.io.MonitorableInputStream;
import com.compomics.util.protein.Protein;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public abstract class DefaultDBLoader
implements DBLoader {
    protected static final boolean debug = false;
    protected BufferedReader iBr = null;
    protected String iFilename = null;
    protected MonitorableInputStream iInputStream = null;
    protected boolean iCancelCount = false;

    public void load(String aFilename) throws IOException {
        File lFile = new File(aFilename);
        if (!lFile.exists()) {
            throw new IOException("File '" + aFilename + "' does not exist!");
        }
        this.iInputStream = new MonitorableFileInputStream(lFile);
        this.iBr = new BufferedReader(new InputStreamReader(this.iInputStream));
        this.iFilename = aFilename;
    }

    public void finalize() {
        this.close();
    }

    public boolean canReadFile(File aFile) {
        return false;
    }

    public String nextFilteredRawEntry(Filter aFilter) throws IOException {
        String result = null;
        boolean lContinue = true;
        while (lContinue) {
            String tempString = this.nextRawEntry();
            if (tempString == null) {
                lContinue = false;
                continue;
            }
            if (!aFilter.passesFilter(tempString)) continue;
            result = tempString;
            lContinue = false;
        }
        return result;
    }

    public Protein nextProtein() throws IOException {
        Protein p = null;
        String fasta = this.nextFASTAEntry();
        if (fasta != null) {
            p = new Protein(fasta);
        }
        return p;
    }

    public Protein nextFilteredProtein(Filter aFilter) throws IOException {
        Protein p = null;
        String fasta = this.nextFilteredFASTAEntry(aFilter);
        if (fasta != null) {
            p = new Protein(fasta);
        }
        return p;
    }

    public void reset() throws IOException {
        this.iBr.close();
        this.iInputStream.close();
        this.iInputStream = new MonitorableFileInputStream(this.iFilename);
        this.iBr = new BufferedReader(new InputStreamReader(this.iInputStream));
    }

    public int getMaximum() {
        return this.iInputStream.getMaximum();
    }

    public int monitorProgress() {
        return this.iInputStream.monitorProgress();
    }

    public void cancelCount() {
        this.iCancelCount = true;
    }

    public void close() {
        try {
            if (this.iBr != null) {
                this.iBr.close();
                this.iBr = null;
            }
            if (this.iInputStream != null) {
                this.iInputStream.close();
                this.iInputStream = null;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

