/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

import com.compomics.dbtoolkit.io.UnknownDBFormatException;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class AutoDBLoader {
    private String[] iDBLoaderClasses = null;

    public AutoDBLoader(String[] aDBLoaderClasses) {
        this.iDBLoaderClasses = aDBLoaderClasses;
    }

    public DBLoader getLoaderForFile(String aFilename) throws IOException, UnknownDBFormatException {
        return this.getLoaderForFile(aFilename, true);
    }

    public DBLoader getLoaderForFile(String aFilename, boolean aInitLoader) throws IOException, UnknownDBFormatException {
        DBLoader loader = null;
        File temp = new File(aFilename);
        if (!temp.exists()) {
            throw new IOException("File '" + aFilename + "' not found!");
        }
        for (int i = 0; i < this.iDBLoaderClasses.length; ++i) {
            String lClass = this.iDBLoaderClasses[i];
            try {
                DBLoader candidate;
                Class<?> c = Class.forName(lClass);
                Constructor<?> constr = c.getConstructor(new Class[0]);
                Object o = constr.newInstance(new Object[0]);
                if (!(o instanceof DBLoader) || !(candidate = (DBLoader)o).canReadFile(temp)) continue;
                loader = candidate;
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (loader == null) {
            throw new UnknownDBFormatException("Unable to determine DB format of the specified file!", aFilename);
        }
        if (aInitLoader) {
            loader.load(aFilename);
        }
        return loader;
    }
}

