/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io;

import com.compomics.dbtoolkit.io.implementations.ProteinFilterCollection;
import com.compomics.dbtoolkit.io.implementations.ProteinResiduCountFilter;
import com.compomics.dbtoolkit.io.implementations.ProteinSequenceFilter;
import com.compomics.dbtoolkit.io.interfaces.ProteinFilter;
import java.text.ParseException;
import java.util.Vector;

public class QueryParser {
    public static final String iANDToken = "AND";
    public static final String iORToken = "OR";

    public ProteinFilter parseQuery(String aQuery) throws ParseException {
        ProteinFilter pf = null;
        pf = this.parseInternal(aQuery, 1);
        return pf;
    }

    private ProteinFilter parseInternal(String aQuery, int aLocation) throws ParseException {
        ProteinFilter pf = null;
        String upper = aQuery.toUpperCase();
        if (upper.indexOf("(") >= 0) {
            pf = this.processInternalSubset(upper, aLocation);
        } else if (upper.indexOf(iANDToken) >= 0 || upper.indexOf(iORToken) >= 0) {
            String toAdd;
            int errorLoc = 0;
            errorLoc = upper.indexOf(41);
            if (errorLoc >= 0) {
                throw new ParseException("Unbalanced parenthesis in query, found closing bracket without opening bracket at position " + (aLocation + errorLoc) + "!", aLocation + errorLoc);
            }
            String token = null;
            boolean isAnd = false;
            if (upper.indexOf(iANDToken) >= 0) {
                isAnd = true;
                token = iANDToken;
                pf = new ProteinFilterCollection(0);
            } else {
                isAnd = false;
                token = iORToken;
                pf = new ProteinFilterCollection(1);
            }
            if (upper.trim().startsWith(token)) {
                throw new ParseException("Query cannot start with '" + token + "' at position " + aLocation + "! Unbalanced boolean terms!", aLocation);
            }
            int location = 0;
            int prevLoc = 0;
            Vector<String> allElements = new Vector<String>(3, 2);
            Vector<Integer> allLocations = new Vector<Integer>(3, 2);
            while ((location = upper.indexOf(token, prevLoc)) > prevLoc) {
                toAdd = upper.substring(prevLoc, location).trim();
                if (toAdd.length() == 0) {
                    throw new ParseException("Unbalanced terms at either side of '" + token + "' at position " + (aLocation + prevLoc) + ".", aLocation + prevLoc);
                }
                allElements.add(toAdd);
                allLocations.add(new Integer(aLocation + prevLoc));
                prevLoc = location + token.length();
            }
            toAdd = upper.substring(prevLoc, upper.length()).trim();
            allElements.add(toAdd);
            allLocations.add(new Integer(aLocation + prevLoc));
            if (toAdd.length() == 0) {
                throw new ParseException("Unbalanced terms at either side of '" + token + "' at position " + (aLocation + prevLoc) + ".", aLocation + prevLoc);
            }
            String[] elements = new String[allElements.size()];
            allElements.toArray(elements);
            for (int i = 0; i < elements.length; ++i) {
                String lElement = elements[i];
                int lLoc = (Integer)allLocations.get(i);
                ((ProteinFilterCollection)pf).add(this.parseInternal(lElement, lLoc));
            }
        } else {
            int errorLoc = 0;
            errorLoc = upper.indexOf(41);
            if (errorLoc >= 0) {
                throw new ParseException("Unbalanced parenthesis in query, found closing bracket without opening bracket at position " + (aLocation + errorLoc) + "!", aLocation + errorLoc);
            }
            if (upper.length() == 0) {
                throw new ParseException("Empty query found!", 0);
            }
            pf = this.parseSimpleFilter(upper, aLocation);
        }
        return pf;
    }

    private ProteinFilter processInternalSubset(String aUpper, int aLocation) throws ParseException {
        ProteinFilter pf = null;
        String internal = aUpper;
        Vector<ProteinFilter> filters = new Vector<ProteinFilter>();
        int filterIndex = 0;
        int start = 0;
        int end = 0;
        int counter = 0;
        while ((start = internal.indexOf(40)) >= 0) {
            counter = 1;
            for (int i = start + 1; i < internal.length(); ++i) {
                char c = internal.charAt(i);
                if (c == '(') {
                    ++counter;
                } else if (c == ')') {
                    --counter;
                }
                if (counter != 0) continue;
                end = i;
                break;
            }
            if (end == 0) {
                throw new ParseException("Unbalanced parentheses for subsection starting at position " + (start + aLocation) + "!", start + aLocation);
            }
            String temp = internal.substring(start + 1, end);
            boolean inversion = false;
            int tempLoc = start;
            if (start > 0 && internal.charAt(start - 1) == '!') {
                inversion = true;
                --tempLoc;
            }
            internal = internal.substring(0, tempLoc) + "$" + filterIndex + internal.substring(end + 1, internal.length());
            ProteinFilter pfInterim = this.parseInternal(temp, aLocation + start + 1);
            if (pfInterim == null) {
                throw new ParseException("Unable to parse your query subsection from position " + (aLocation + start) + " to position " + (end + aLocation) + ": (" + temp + ")!", aLocation + start);
            }
            pfInterim.setInversion(inversion);
            filters.add(pfInterim);
            ++filterIndex;
        }
        boolean isAND = false;
        String token = null;
        int errorLoc = 0;
        errorLoc = internal.indexOf(41);
        if (errorLoc >= 0) {
            throw new ParseException("Unbalanced parenthesis in query, found closing bracket without opening bracket at location " + (aLocation + errorLoc) + "!", aLocation + errorLoc);
        }
        if (internal.indexOf(iANDToken) >= 0) {
            isAND = true;
            token = iANDToken;
            pf = new ProteinFilterCollection(0);
        } else if (internal.indexOf(iORToken) >= 0) {
            isAND = false;
            token = iORToken;
            pf = new ProteinFilterCollection(1);
        } else if (filters.size() == 1) {
            pf = (ProteinFilter)filters.get(0);
        } else {
            throw new ParseException("You specified multiple subsections in the query, without specifying a boolean operator to join them!", 0);
        }
        if (token != null) {
            String toAdd;
            if (internal.trim().startsWith(token)) {
                throw new ParseException("Query cannot start with '" + token + "'! Unbalanced boolean terms!", aLocation);
            }
            int location = 0;
            int prevLoc = 0;
            Vector<String> allElements = new Vector<String>(3, 2);
            Vector<Integer> allLocations = new Vector<Integer>(3, 2);
            while ((location = internal.indexOf(token, prevLoc)) > prevLoc) {
                toAdd = internal.substring(prevLoc, location).trim();
                if (toAdd.length() == 0) {
                    throw new ParseException("Unbalanced terms at either side of '" + token + "' at position " + (aLocation + prevLoc) + ".", aLocation + prevLoc);
                }
                allElements.add(toAdd);
                allLocations.add(new Integer(aLocation + prevLoc));
                prevLoc = location + token.length();
            }
            toAdd = internal.substring(prevLoc, internal.length()).trim();
            allElements.add(toAdd);
            allLocations.add(new Integer(aLocation + prevLoc));
            if (toAdd.length() == 0) {
                throw new ParseException("Unbalanced terms at either side of '" + token + "' at position " + (aLocation + prevLoc) + ".", aLocation + prevLoc);
            }
            String[] elements = new String[allElements.size()];
            allElements.toArray(elements);
            for (int i = 0; i < elements.length; ++i) {
                String lElement = elements[i];
                int lLoc = (Integer)allLocations.get(i);
                if (lElement.startsWith("$")) {
                    int elementIndex = Integer.parseInt(lElement.substring(1));
                    ((Vector)((Object)pf)).add((ProteinFilter)filters.get(elementIndex));
                    continue;
                }
                ((Vector)((Object)pf)).add(this.parseInternal(lElement, lLoc));
            }
        }
        return pf;
    }

    private ProteinFilter parseSimpleFilter(String aParam, int aLocation) throws ParseException {
        ProteinFilter pf = null;
        boolean containsNbr = false;
        int nbrIndex = -1;
        for (int i = 0; i < aParam.length(); ++i) {
            if (!Character.isDigit(aParam.charAt(i))) continue;
            containsNbr = true;
            nbrIndex = i;
            break;
        }
        if (containsNbr) {
            boolean invert = false;
            int mode = 3;
            if (nbrIndex > 0) {
                char currentChar = aParam.charAt(nbrIndex - 1);
                if (currentChar == '=') {
                    mode = 3;
                    if (nbrIndex - 1 > 0) {
                        currentChar = aParam.charAt(nbrIndex - 2);
                    }
                } else if (currentChar == '>') {
                    mode = 1;
                    if (nbrIndex - 1 > 0) {
                        currentChar = aParam.charAt(nbrIndex - 2);
                    }
                } else if (currentChar == '<') {
                    mode = 2;
                    if (nbrIndex - 1 > 0) {
                        currentChar = aParam.charAt(nbrIndex - 2);
                    }
                }
                if (currentChar == '!') {
                    invert = true;
                }
            }
            int resLocation = 0;
            for (int i = nbrIndex; i < aParam.length(); ++i) {
                if (!Character.isLetter(aParam.charAt(i))) continue;
                resLocation = i;
                break;
            }
            if (resLocation == 0) {
                throw new ParseException("No residu (or stretch) specified for counting at position " + (aLocation + nbrIndex) + "!", aLocation + nbrIndex);
            }
            String residu = aParam.substring(resLocation, aParam.length());
            int counter = 0;
            try {
                counter = Integer.parseInt(aParam.substring(nbrIndex, resLocation));
            }
            catch (Exception e) {
                throw new ParseException("The whole number you should have specified at position " + (nbrIndex + aLocation) + " could not be parsed!", nbrIndex + aLocation);
            }
            pf = new ProteinResiduCountFilter(residu, counter, mode, invert);
        } else {
            pf = new ProteinSequenceFilter(aParam);
        }
        return pf;
    }
}

