/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io;

import com.compomics.dbtoolkit.io.implementations.FilterCollection;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.dbtoolkit.toolkit.EnzymeDigest;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class FilterLoader {
    public static Filter loadFilter(String aFilterName, String aParam, DBLoader aLoader) throws IOException {
        Filter f = null;
        if (aFilterName != null) {
            Properties props = new Properties();
            InputStream in = EnzymeDigest.class.getClassLoader().getResourceAsStream("filters.properties");
            if (in == null) {
                throw new IOException("File 'filters.properties' not found in current classpath!");
            }
            props.load(in);
            String filterParams = props.getProperty(aFilterName);
            if (filterParams == null) {
                Enumeration<Object> e = props.keys();
                StringBuffer sb = new StringBuffer();
                while (e.hasMoreElements()) {
                    sb.append("  - " + (String)e.nextElement() + "\n");
                }
                throw new IOException("The filter you specified (" + aFilterName + ") is not found in the 'filters.properties' file!\n\nAvailable filters:\n" + sb.toString());
            }
            StringTokenizer st = new StringTokenizer(filterParams, ",");
            String filterClass = st.nextToken().trim();
            String filterDB = st.nextToken().trim();
            if (!filterDB.equals(aLoader.getDBName())) {
                throw new IOException("The filter you specified (" + aFilterName + ") is not available for a '" + aLoader.getDBName() + "' database but for a '" + filterDB + "' database!");
            }
            try {
                Constructor<?> constr = null;
                int type = 0;
                Class<?> lClass = Class.forName(filterClass);
                if (lClass == null) {
                    throw new IOException("The class '" + filterClass + "' for your filter '" + aFilterName + "' could not be found! Check your clasppath setting!");
                }
                if (aParam == null) {
                    try {
                        constr = lClass.getConstructor(new Class[0]);
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    type = 1;
                } else if (aParam.startsWith("!")) {
                    try {
                        constr = lClass.getConstructor(String.class, Boolean.TYPE);
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    type = 2;
                } else {
                    try {
                        constr = lClass.getConstructor(String.class);
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    type = 3;
                }
                if (constr == null) {
                    throw new IOException("The '" + aFilterName + "' filter does not support the " + (aParam != null ? "presence" : "absence") + " of a" + (aParam != null && aParam.startsWith("!") ? "n inverted " : " ") + "parameter!");
                }
                f = type == 1 ? (Filter)constr.newInstance(new Object[0]) : (type == 2 ? (Filter)constr.newInstance(aParam.substring(1), new Boolean(true)) : (Filter)constr.newInstance(aParam));
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Unable to load class '" + filterClass + "' for your filter '" + aFilterName + "': " + e.getMessage());
            }
            catch (InstantiationException ie) {
                throw new IOException("Unable to instantiate class '" + filterClass + "' for your filter '" + aFilterName + "': " + ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                throw new IOException("Unable to access constructor for class '" + filterClass + "' for your filter '" + aFilterName + "': " + iae.getMessage());
            }
            catch (InvocationTargetException ite) {
                throw new IOException("Unable to invoke constructor for class '" + filterClass + "' for your filter '" + aFilterName + "': " + ite.getMessage());
            }
        }
        return f;
    }

    public static Filter processFilterSetANDLogic(String aFilterSet, DBLoader aLoader) throws IOException {
        FilterCollection result = new FilterCollection(0);
        String[] parts = aFilterSet.split(";");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim();
            String filterName = null;
            String filterParam = null;
            if (part.indexOf("=") > 0) {
                String[] filter_and_param = part.split("=");
                filterName = filter_and_param[0].trim();
                filterParam = filter_and_param[1].trim();
            } else {
                filterName = part;
            }
            result.add(FilterLoader.loadFilter(filterName, filterParam, aLoader));
        }
        return result;
    }
}

