/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io;

import com.compomics.dbtoolkit.toolkit.EnzymeDigest;
import com.compomics.util.io.MascotEnzymeReader;
import com.compomics.util.protein.Enzyme;
import java.io.IOException;
import java.io.InputStream;

public class EnzymeLoader {
    public static Enzyme loadEnzyme(String aName, String aMisCleavages) throws IOException {
        Enzyme enzyme = null;
        if (aName != null) {
            InputStream in = EnzymeDigest.class.getClassLoader().getResourceAsStream("enzymes.txt");
            if (in != null) {
                MascotEnzymeReader mer = new MascotEnzymeReader(in);
                enzyme = mer.getEnzyme(aName);
                if (enzyme == null) {
                    throw new IOException("The enzyme you specified (" + aName + ") was not found in the Mascot Enzymefile '" + EnzymeDigest.class.getClassLoader().getResource("enzymes.txt") + "'!");
                }
                if (aMisCleavages != null) {
                    try {
                        int i = Integer.parseInt(aMisCleavages);
                        if (i < 0) {
                            throw new IOException("");
                        }
                        enzyme.setMiscleavages(i);
                    }
                    catch (Exception e) {
                        throw new IOException("The number of allowed missed cleavages must be a positive whole number!");
                    }
                }
            } else {
                throw new IOException("File 'enzymes.txt' not found in current classpath!");
            }
        }
        return enzyme;
    }
}

