/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io;

import com.compomics.dbtoolkit.io.UnknownDBFormatException;
import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.toolkit.CountEntries;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;

public class DBLoaderLoader {
    public static DBLoader loadDB(File aInputFile) throws IOException {
        DBLoader loader = null;
        Properties p = null;
        InputStream is = CountEntries.class.getClassLoader().getResourceAsStream("DBLoaders.properties");
        p = new Properties();
        if (is != null) {
            p.load(is);
            is.close();
        }
        if (p == null || p.size() == 0) {
            System.out.println("\t - Unable to find 'DBLoaders.properties' file, defaulting to built-in types (SwissProt & FASTA only!)...");
            p = new Properties();
            p.put("1", "com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader");
            p.put("2", "com.compomics.dbtoolkit.io.implementations.FASTADBLoader");
        }
        String[] classNames = new String[p.size()];
        Iterator<Object> it = p.values().iterator();
        int counter = 0;
        while (it.hasNext()) {
            classNames[counter] = (String)it.next();
            ++counter;
        }
        AutoDBLoader adb = new AutoDBLoader(classNames);
        try {
            loader = adb.getLoaderForFile(aInputFile.getAbsolutePath());
        }
        catch (UnknownDBFormatException udfe) {
            throw new IOException("Unknown database format: " + udfe.getMessage());
        }
        if (loader == null) {
            throw new IOException("Unable to determine database type for your inputfile (" + aInputFile + "), exiting...");
        }
        return loader;
    }
}

