/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui.workerthreads;

import com.compomics.dbtoolkit.gui.interfaces.CursorModifiable;
import com.compomics.dbtoolkit.gui.interfaces.StatusView;
import com.compomics.dbtoolkit.io.DBLoaderLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.util.protein.Protein;
import java.awt.Cursor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.math.BigDecimal;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;

public class ShuffleDBThread
implements Runnable {
    public static final int SHUFFLE = 0;
    public static final int REVERSE = 1;
    private int iTaskType = -1;
    private DBLoader iInputDB = null;
    private PrintWriter iOutWriter = null;
    private String iOutputName = null;
    private JFrame iParent = null;
    private ProgressMonitor iMonitor = null;
    private boolean ibCloseWriter = false;

    public ShuffleDBThread(File aInputFile) throws IOException {
        this(aInputFile, null, -1);
    }

    public ShuffleDBThread(File aInputFile, int aTaskType) throws IOException {
        this(aInputFile, null, aTaskType);
    }

    public ShuffleDBThread(File aInputFile, File aOutputFile, int aTaskType) throws IOException {
        this.iInputDB = DBLoaderLoader.loadDB(aInputFile);
        if (aOutputFile == null) {
            this.iOutWriter = new PrintWriter(new OutputStreamWriter(System.out));
        } else {
            this.iOutWriter = new PrintWriter(new BufferedWriter(new FileWriter(aOutputFile)));
            this.ibCloseWriter = true;
            this.iOutputName = aOutputFile.getAbsolutePath();
        }
        this.iTaskType = aTaskType;
    }

    public ShuffleDBThread(DBLoader aLoader, File aOutputFile, int aTaskType, JFrame aParent) throws IOException {
        this.iInputDB = aLoader;
        if (aOutputFile == null) {
            this.iOutWriter = new PrintWriter(new OutputStreamWriter(System.out));
        } else {
            this.iOutWriter = new PrintWriter(new BufferedWriter(new FileWriter(aOutputFile)));
            this.ibCloseWriter = true;
            this.iOutputName = aOutputFile.getAbsolutePath();
        }
        this.iTaskType = aTaskType;
        this.iParent = aParent;
    }

    public void shuffle() throws IOException {
        if (this.iParent != null) {
            if (this.iParent instanceof CursorModifiable) {
                ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(3));
            } else {
                this.iParent.setCursor(new Cursor(3));
            }
            if (this.iParent instanceof StatusView) {
                ((StatusView)((Object)this.iParent)).setStatus("Started shuffling database " + (this.iOutputName != null ? "to FASTA outputfile '" + this.iOutputName + "'" : "") + "...");
            }
            this.iMonitor = new ProgressMonitor(this.iParent, "Shuffling database " + (this.iOutputName != null ? "to FASTA outputfile '" + this.iOutputName + "'" : "") + "...", "Initializing...", 0, this.iInputDB.getMaximum() + 1);
            this.iMonitor.setMillisToDecideToPopup(100);
            this.iMonitor.setMillisToPopup(100);
            this.iMonitor.setNote("Generating shuffled database file...");
            this.iMonitor.setProgress(1);
        }
        Protein current = null;
        boolean cancelled = false;
        while ((current = this.iInputDB.nextProtein()) != null && !cancelled) {
            char[] sequence = current.getSequence().getSequence().toCharArray();
            current.getHeader().setAccession(current.getHeader().getAccession() + "_SHUFFLED");
            Protein p = new Protein(current.getHeader().toString() + " - SHUFFLED", new String(this.shuffleSequence(sequence)));
            p.writeToFASTAFile(this.iOutWriter);
            if (this.iParent == null) continue;
            if (this.iInputDB.monitorProgress() < this.iMonitor.getMaximum()) {
                this.iMonitor.setProgress(this.iInputDB.monitorProgress());
            } else {
                int delta = this.iInputDB.monitorProgress() - this.iMonitor.getMaximum();
                double modulo = delta / 1024;
                String affix = "KB";
                if (modulo % 5.0 == 0.0) {
                    double temp = modulo / 1024.0;
                    if (temp > 1.0) {
                        modulo = temp;
                        affix = "MB";
                    }
                    this.iMonitor.setNote("Reading from buffer (" + new BigDecimal(modulo).setScale(1, 4).doubleValue() + affix + ")...");
                }
            }
            if (!this.iMonitor.isCanceled()) continue;
            cancelled = true;
        }
        this.iOutWriter.flush();
        if (this.ibCloseWriter) {
            this.iOutWriter.close();
        }
        this.iInputDB.reset();
        StringBuffer tempSB = new StringBuffer("Created shuffled FASTA DB" + (this.iOutputName != null ? " in file '" + this.iOutputName + "'" : "") + ".");
        if (this.iParent != null) {
            this.iMonitor.setProgress(this.iMonitor.getMaximum());
            this.iMonitor.close();
            if (this.iParent instanceof CursorModifiable) {
                ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(0));
            }
            this.iParent.setCursor(new Cursor(0));
            String status = null;
            if (cancelled) {
                status = "Cancelled shuffled DB output";
                if (this.iOutputName != null) {
                    new File(this.iOutputName).delete();
                    status = status + " to file '" + this.iOutputName + "'. Deleted unfinished output file";
                }
                status = status + ".";
            } else {
                status = tempSB.toString();
            }
            if (this.iParent instanceof StatusView) {
                ((StatusView)((Object)this.iParent)).setStatus(status);
            }
        } else {
            System.out.println("\n\t" + tempSB.toString() + "\n");
        }
    }

    public void reverse() throws IOException {
        if (this.iParent != null) {
            if (this.iParent instanceof CursorModifiable) {
                ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(3));
            } else {
                this.iParent.setCursor(new Cursor(3));
            }
            if (this.iParent instanceof StatusView) {
                ((StatusView)((Object)this.iParent)).setStatus("Started reversing database " + (this.iOutputName != null ? "to FASTA outputfile '" + this.iOutputName + "'" : "") + "...");
            }
            this.iMonitor = new ProgressMonitor(this.iParent, "Reversing database " + (this.iOutputName != null ? "to FASTA outputfile '" + this.iOutputName + "'" : "") + "...", "Initializing...", 0, this.iInputDB.getMaximum() + 1);
            this.iMonitor.setMillisToDecideToPopup(100);
            this.iMonitor.setMillisToPopup(100);
            this.iMonitor.setNote("Generating reversed database file...");
            this.iMonitor.setProgress(1);
        }
        Protein current = null;
        boolean cancelled = false;
        while ((current = this.iInputDB.nextProtein()) != null && !cancelled) {
            String sequence = current.getSequence().getSequence();
            current.getHeader().setAccession(current.getHeader().getAccession() + "_REVERSED");
            Protein p = new Protein(current.getHeader().toString() + " - REVERSED", this.reverseSequence(sequence));
            p.writeToFASTAFile(this.iOutWriter);
            if (this.iParent == null) continue;
            if (this.iInputDB.monitorProgress() < this.iMonitor.getMaximum()) {
                this.iMonitor.setProgress(this.iInputDB.monitorProgress());
            } else {
                int delta = this.iInputDB.monitorProgress() - this.iMonitor.getMaximum();
                double modulo = delta / 1024;
                String affix = "KB";
                if (modulo % 5.0 == 0.0) {
                    double temp = modulo / 1024.0;
                    if (temp > 1.0) {
                        modulo = temp;
                        affix = "MB";
                    }
                    this.iMonitor.setNote("Reading from buffer (" + new BigDecimal(modulo).setScale(1, 4).doubleValue() + affix + ")...");
                }
            }
            if (!this.iMonitor.isCanceled()) continue;
            cancelled = true;
        }
        this.iOutWriter.flush();
        if (this.ibCloseWriter) {
            this.iOutWriter.close();
        }
        this.iInputDB.reset();
        StringBuffer tempSB = new StringBuffer("Created reversed FASTA DB" + (this.iOutputName != null ? " in file '" + this.iOutputName + "'" : "") + ".");
        if (this.iParent != null) {
            this.iMonitor.setProgress(this.iMonitor.getMaximum());
            this.iMonitor.close();
            if (this.iParent instanceof CursorModifiable) {
                ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(0));
            }
            this.iParent.setCursor(new Cursor(0));
            String status = null;
            if (cancelled) {
                status = "Cancelled reversed DB output";
                if (this.iOutputName != null) {
                    new File(this.iOutputName).delete();
                    status = status + " to file '" + this.iOutputName + "'. Deleted unfinished output file";
                }
                status = status + ".";
            } else {
                status = tempSB.toString();
            }
            if (this.iParent instanceof StatusView) {
                ((StatusView)((Object)this.iParent)).setStatus(status);
            }
        } else {
            System.out.println("\n\t" + tempSB.toString() + "\n");
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public void run() {
        try {
            if (this.iTaskType == 0) {
                this.shuffle();
            } else if (this.iTaskType == 1) {
                this.reverse();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private char[] shuffleSequence(char[] sequence) {
        for (int i = 0; i < sequence.length; ++i) {
            int j = (int)(Math.random() * (double)sequence.length);
            if (i == j) continue;
            char temp = sequence[i];
            sequence[i] = sequence[j];
            sequence[j] = temp;
        }
        return sequence;
    }

    private String reverseSequence(String aSequence) {
        StringBuffer reversed = new StringBuffer(aSequence.length());
        for (int i = 1; i <= aSequence.length(); ++i) {
            reversed.append(aSequence.charAt(aSequence.length() - i));
        }
        return reversed.toString();
    }
}

