/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui.workerthreads;

import com.compomics.dbtoolkit.gui.interfaces.CursorModifiable;
import com.compomics.dbtoolkit.gui.interfaces.StatusView;
import com.compomics.dbtoolkit.io.QueryParser;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.dbtoolkit.io.interfaces.ProteinFilter;
import com.compomics.util.protein.AASequenceImpl;
import com.compomics.util.protein.Enzyme;
import com.compomics.util.protein.Header;
import com.compomics.util.protein.Protein;
import java.awt.Cursor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;

public class ProcessThread
implements Runnable {
    private DBLoader iLoader = null;
    private File iOutput = null;
    private JFrame iParent = null;
    private ProgressMonitor iMonitor = null;
    private Filter iFilter = null;
    private int iTaskType = 0;
    private boolean iMassLimits = false;
    private double iMinMass = 0.0;
    private double iMaxMass = 0.0;
    private Enzyme iEnzyme = null;
    public static final int RAGGING = 0;
    public static final int SUBSET = 1;
    private boolean iTruncate = false;
    private int iTruncateSize = 0;
    private int iTerminus = 0;
    public static final int NTERMINUS = 0;
    public static final int CTERMINUS = 1;
    private String iSubsetQuery = null;
    private ProteinFilter iProteinFilter = null;
    private int iOmmittedLower = 0;
    private int iOmmittedUpper = 0;
    private int iNumberOfEntriesRead = 0;
    private int iNumberOfCleavedEntries = 0;
    private int iWrittenToResultFile = 0;

    protected ProcessThread(DBLoader aLoader, File aOutput, JFrame aParent, Filter aFilter, Enzyme aEnzyme, boolean aMassLimits, double aMinMass, double aMaxMass) {
        this.iLoader = aLoader;
        this.iOutput = aOutput;
        this.iParent = aParent;
        this.iFilter = aFilter;
        this.iEnzyme = aEnzyme;
        this.iMassLimits = aMassLimits;
        this.iMinMass = aMinMass;
        this.iMaxMass = aMaxMass;
    }

    public static ProcessThread getRaggingTask(DBLoader aLoader, File aOutput, JFrame aParent, Filter aFilter, Enzyme aEnzyme, boolean aMassLimits, double aMinMass, double aMaxMass, int aTerminus, boolean aTruncate, int aTruncateSize) {
        ProcessThread pt = new ProcessThread(aLoader, aOutput, aParent, aFilter, aEnzyme, aMassLimits, aMinMass, aMaxMass);
        pt.iTaskType = 0;
        pt.iTerminus = aTerminus;
        pt.iTruncate = aTruncate;
        pt.iTruncateSize = aTruncateSize;
        return pt;
    }

    public static ProcessThread getSubsetTask(DBLoader aLoader, File aOutput, JFrame aParent, Filter aFilter, Enzyme aEnzyme, boolean aMassLimits, double aMinMass, double aMaxMass, String aQueryString) {
        ProcessThread pt = new ProcessThread(aLoader, aOutput, aParent, aFilter, aEnzyme, aMassLimits, aMinMass, aMaxMass);
        pt.iTaskType = 1;
        pt.iSubsetQuery = aQueryString;
        return pt;
    }

    public static ProcessThread getSubsetTask(DBLoader aLoader, File aOutput, JFrame aParent, Filter aFilter, Enzyme aEnzyme, boolean aMassLimits, double aMinMass, double aMaxMass, ProteinFilter aSequenceFilter) {
        ProcessThread pt = new ProcessThread(aLoader, aOutput, aParent, aFilter, aEnzyme, aMassLimits, aMinMass, aMaxMass);
        pt.iTaskType = 1;
        pt.iProteinFilter = aSequenceFilter;
        return pt;
    }

    public void run() {
        if (this.iTaskType == 0) {
            this.startRagging();
        } else if (this.iTaskType == 1) {
            this.generateSubset();
        }
    }

    private void startRagging() {
        this.iNumberOfEntriesRead = 0;
        this.iOmmittedLower = 0;
        this.iOmmittedUpper = 0;
        try {
            if (this.iParent != null) {
                if (this.iParent instanceof CursorModifiable) {
                    ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(3));
                } else {
                    this.iParent.setCursor(new Cursor(3));
                }
                if (this.iParent instanceof StatusView) {
                    ((StatusView)((Object)this.iParent)).setStatus("Started ragging database to FASTA outputfile '" + this.iOutput.getAbsoluteFile() + "'...");
                }
                this.iMonitor = new ProgressMonitor(this.iParent, "Ragging database to FASTA outputfile '" + this.iOutput.getAbsoluteFile() + "'...", "Initializing...", 0, this.iLoader.getMaximum() + 1);
                this.iMonitor.setMillisToDecideToPopup(100);
                this.iMonitor.setMillisToPopup(100);
                this.iMonitor.setNote("Generating " + (this.iTerminus == 0 ? "N-terminal" : "C-terminal") + " ragged database file...");
                this.iMonitor.setProgress(1);
            }
            PrintWriter pw = new PrintWriter(new FileWriter(this.iOutput));
            Protein protein = null;
            protein = this.iFilter == null ? this.iLoader.nextProtein() : this.iLoader.nextFilteredProtein(this.iFilter);
            boolean cancelled = false;
            while (protein != null && !cancelled) {
                ++this.iNumberOfEntriesRead;
                Protein[] result = this.getRaggedEntries(protein);
                for (int i = 0; i < result.length; ++i) {
                    result[i].writeToFASTAFile(pw);
                    ++this.iWrittenToResultFile;
                }
                if (this.iParent != null) {
                    if (this.iLoader.monitorProgress() < this.iMonitor.getMaximum()) {
                        this.iMonitor.setProgress(this.iLoader.monitorProgress());
                    } else {
                        int delta = this.iLoader.monitorProgress() - this.iMonitor.getMaximum();
                        double modulo = delta / 1024;
                        String affix = "KB";
                        if (modulo % 5.0 == 0.0) {
                            double temp = modulo / 1024.0;
                            if (temp > 1.0) {
                                modulo = temp;
                                affix = "MB";
                            }
                            this.iMonitor.setNote("Reading from buffer (" + new BigDecimal(modulo).setScale(1, 4).doubleValue() + affix + ")...");
                        }
                    }
                    if (this.iMonitor.isCanceled()) {
                        cancelled = true;
                    }
                }
                if (this.iFilter == null) {
                    protein = this.iLoader.nextProtein();
                    continue;
                }
                protein = this.iLoader.nextFilteredProtein(this.iFilter);
            }
            pw.flush();
            pw.close();
            this.iLoader.reset();
            StringBuffer tempSB = new StringBuffer("Created ragged FASTA DB file '" + this.iOutput.getAbsoluteFile() + "'.");
            tempSB.append(" Written " + this.iWrittenToResultFile + " entries to result file (" + this.iNumberOfEntriesRead + " entries read)");
            if (this.iMassLimits) {
                tempSB.append(" and skipped " + (this.iOmmittedLower + this.iOmmittedUpper) + " entries because they were out of mass range (" + this.iMinMass + "Da - " + this.iMaxMass + "Da.)");
            }
            if (this.iParent != null) {
                this.iMonitor.setProgress(this.iMonitor.getMaximum());
                this.iMonitor.close();
                if (this.iParent instanceof CursorModifiable) {
                    ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(0));
                }
                this.iParent.setCursor(new Cursor(0));
                String status = null;
                if (cancelled) {
                    this.iOutput.delete();
                    status = "Cancelled ragged DB output to file '" + this.iOutput.getAbsoluteFile() + "'. Deleted unfinished output file.";
                } else {
                    status = tempSB.toString();
                }
                if (this.iParent instanceof StatusView) {
                    ((StatusView)((Object)this.iParent)).setStatus(status);
                }
            } else {
                System.out.println("\n\t" + tempSB.toString() + "\n");
            }
        }
        catch (IOException ioe) {
            if (this.iParent != null) {
                ((StatusView)((Object)this.iParent)).setError("An error occurred during processing. The resulting database may be corrupted. Errormessage: '" + ioe.getMessage() + "'.");
                JOptionPane.showMessageDialog(this.iParent, new String[]{"Error occurred writing results file!", ioe.getMessage()}, "Error writing output file!", 0);
            }
            ioe.printStackTrace();
        }
    }

    private Protein[] getRaggedEntries(Protein aProtein) throws IOException {
        Vector<Protein> result = new Vector<Protein>();
        if (this.iTruncate) {
            if (this.iTerminus == 0) {
                aProtein = aProtein.getNTermTruncatedProtein(this.iTruncateSize);
            } else if (this.iTerminus == 1) {
                aProtein = aProtein.getCTermTruncatedProtein(this.iTruncateSize);
            }
        }
        Protein[] proteins = null;
        if (this.iEnzyme != null) {
            proteins = this.iEnzyme.cleave(aProtein);
            this.iNumberOfCleavedEntries += proteins.length;
        } else {
            proteins = new Protein[]{aProtein};
        }
        block0: for (int i = 0; i < proteins.length; ++i) {
            int start;
            Protein lProtein = proteins[i];
            if (this.iMassLimits) {
                double mass = lProtein.getMass();
                if (mass < this.iMinMass || this.iMaxMass < mass) {
                    if (mass < this.iMinMass) {
                        ++this.iOmmittedLower;
                        continue;
                    }
                    ++this.iOmmittedUpper;
                } else {
                    result.add(lProtein);
                }
            } else {
                result.add(lProtein);
            }
            Header header = lProtein.getHeader();
            AASequenceImpl sequence = lProtein.getSequence();
            int endLocation = header.getEndLocation();
            if (endLocation < 0) {
                endLocation = sequence.getLength();
            }
            if ((start = header.getStartLocation()) < 0) {
                start = 1;
            }
            boolean lContinue = true;
            int counter = 0;
            while (lContinue) {
                ++counter;
                if (sequence.getLength() == 1) continue block0;
                AASequenceImpl tempSequence = null;
                tempSequence = this.iTerminus == 0 ? new AASequenceImpl(sequence.getSequence().substring(1)) : new AASequenceImpl(sequence.getSequence().substring(0, sequence.getLength() - 1));
                Header tempHeader = (Header)header.clone();
                if (this.iTerminus == 0) {
                    tempHeader.setLocation(start + counter, endLocation);
                } else {
                    tempHeader.setLocation(start, endLocation - counter);
                }
                Protein tempProtein = new Protein(tempHeader, tempSequence);
                if (this.iMassLimits) {
                    double mass = tempProtein.getMass();
                    if (mass < this.iMinMass || this.iMaxMass < mass) {
                        if (mass < this.iMinMass) {
                            lContinue = false;
                        }
                    } else {
                        result.add(tempProtein);
                    }
                } else {
                    result.add(tempProtein);
                }
                sequence = tempSequence;
            }
        }
        int liSize = result.size();
        HashMap<String, String> headers = new HashMap<String, String>(liSize);
        Vector<Protein> nonRed = new Vector<Protein>(liSize);
        for (int i = 0; i < result.size(); ++i) {
            Protein lProtein = (Protein)result.get(i);
            String h = lProtein.getHeader().toString();
            if (headers.get(h) != null) continue;
            headers.put(h, "1");
            nonRed.add(lProtein);
        }
        Protein[] toReturn = new Protein[nonRed.size()];
        nonRed.toArray(toReturn);
        for (int i = 0; i < toReturn.length; ++i) {
            Protein protein = toReturn[i];
            this.annotateHeader(protein.getHeader(), aProtein.getSequence().getSequence(), protein.getSequence().getSequence(), this.iEnzyme);
        }
        return toReturn;
    }

    private void generateSubset() {
        this.iNumberOfEntriesRead = 0;
        this.iNumberOfCleavedEntries = 0;
        this.iOmmittedLower = 0;
        this.iOmmittedUpper = 0;
        boolean cancelled = false;
        boolean error = false;
        String monitorText = "Writing sequence-based subset to outputfile '";
        String initialNote = "Parsing subset query...";
        String runningNote = "Generating sequence-based subset database file...";
        if (this.iProteinFilter == null && this.iSubsetQuery == null && this.iEnzyme != null) {
            monitorText = "Writing " + this.iEnzyme.getTitle() + " digest of database to outputfile '";
            initialNote = "Acquiring enzyme...";
            runningNote = "Digesting database...";
        }
        try {
            if (this.iParent != null) {
                if (this.iParent instanceof CursorModifiable) {
                    ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(3));
                } else {
                    this.iParent.setCursor(new Cursor(3));
                }
                if (this.iParent instanceof StatusView) {
                    ((StatusView)((Object)this.iParent)).setStatus(monitorText + this.iOutput.getAbsoluteFile() + "'...");
                }
                this.iMonitor = new ProgressMonitor(this.iParent, monitorText + this.iOutput.getAbsoluteFile() + "'...", "Initializing...", 0, this.iLoader.getMaximum() + 1);
                this.iMonitor.setMillisToDecideToPopup(0);
                this.iMonitor.setMillisToPopup(0);
                this.iMonitor.setNote(initialNote);
                this.iMonitor.setProgress(1);
            }
            if (this.iSubsetQuery != null) {
                QueryParser qp = new QueryParser();
                this.iProteinFilter = qp.parseQuery(this.iSubsetQuery);
                if (this.iProteinFilter == null) {
                    throw new ParseException("(No message returned from parser - general failure)", 0);
                }
            }
            try {
                if (this.iParent != null) {
                    this.iMonitor.setNote(runningNote);
                }
                PrintWriter pw = new PrintWriter(new FileWriter(this.iOutput));
                Protein protein = null;
                protein = this.iFilter == null ? this.iLoader.nextProtein() : this.iLoader.nextFilteredProtein(this.iFilter);
                cancelled = false;
                while (protein != null && !cancelled) {
                    ++this.iNumberOfEntriesRead;
                    Protein[] proteins = null;
                    if (this.iEnzyme != null) {
                        proteins = this.iEnzyme.cleave(protein);
                        this.iNumberOfCleavedEntries += proteins.length;
                    } else {
                        proteins = new Protein[]{protein};
                    }
                    for (int i = 0; i < proteins.length; ++i) {
                        if (this.iMassLimits) {
                            double mass = proteins[i].getMass();
                            if (mass < this.iMinMass) {
                                ++this.iOmmittedLower;
                                continue;
                            }
                            if (mass > this.iMaxMass) {
                                ++this.iOmmittedUpper;
                                continue;
                            }
                        }
                        if (this.iProteinFilter != null && !this.iProteinFilter.passesFilter(proteins[i])) continue;
                        proteins[i].writeToFASTAFile(pw);
                        ++this.iWrittenToResultFile;
                    }
                    if (this.iParent != null) {
                        if (this.iLoader.monitorProgress() < this.iMonitor.getMaximum()) {
                            this.iMonitor.setProgress(this.iLoader.monitorProgress());
                        } else {
                            int delta = this.iLoader.monitorProgress() - this.iMonitor.getMaximum();
                            double modulo = delta / 1024;
                            String affix = "KB";
                            if (modulo % 5.0 == 0.0) {
                                double temp = modulo / 1024.0;
                                if (temp > 1.0) {
                                    modulo = temp;
                                    affix = "MB";
                                }
                                this.iMonitor.setNote("Reading from buffer (" + new BigDecimal(modulo).setScale(1, 4).doubleValue() + affix + ")...");
                            }
                        }
                        if (this.iMonitor.isCanceled()) {
                            cancelled = true;
                        }
                    }
                    if (this.iFilter == null) {
                        protein = this.iLoader.nextProtein();
                        continue;
                    }
                    protein = this.iLoader.nextFilteredProtein(this.iFilter);
                }
                pw.flush();
                pw.close();
                this.iLoader.reset();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                error = true;
            }
        }
        catch (ParseException pe) {
            if (this.iParent != null) {
                JOptionPane.showMessageDialog(this.iParent, new String[]{"ParseException raised when attempting to parse your query String!", pe.getMessage()}, "Could not parse query!", 0);
            } else {
                System.err.println("ParseException raised for query '" + this.iSubsetQuery + "': " + pe.getMessage());
                pe.printStackTrace();
            }
            error = true;
        }
        StringBuffer tempSB = new StringBuffer("Created sequence-based subset FASTA DB file '" + this.iOutput.getAbsoluteFile() + "'.");
        tempSB.append(" Written " + this.iWrittenToResultFile + " entries to result file" + (this.iProteinFilter == null ? "" : ", rejected " + (Math.max(this.iNumberOfCleavedEntries, this.iNumberOfEntriesRead) - this.iWrittenToResultFile - (this.iOmmittedLower + this.iOmmittedUpper)) + " elements based on the filter (" + this.iNumberOfEntriesRead + " entries read)"));
        if (this.iMassLimits) {
            tempSB.append(" and skipped " + (this.iOmmittedLower + this.iOmmittedUpper) + " elements because they were out of mass range (" + this.iMinMass + "Da - " + this.iMaxMass + "Da.)");
        }
        if (this.iParent != null) {
            this.iMonitor.setProgress(this.iMonitor.getMaximum());
            this.iMonitor.close();
            if (this.iParent instanceof CursorModifiable) {
                ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(0));
            } else {
                this.iParent.setCursor(new Cursor(0));
            }
            String status = null;
            if (cancelled) {
                this.iOutput.delete();
                status = "Cancelled sequence-based subset output to file '" + this.iOutput.getAbsoluteFile() + "'. Deleted unfinished output file.";
            } else if (error) {
                this.iOutput.delete();
                status = "Error encountered while writing output to file '" + this.iOutput.getAbsoluteFile() + "'. Deleted unfinished output file.";
            } else {
                status = tempSB.toString();
            }
            if (this.iParent instanceof StatusView) {
                ((StatusView)((Object)this.iParent)).setStatus(status);
                if (error) {
                    ((StatusView)((Object)this.iParent)).setError("Error writing output file for subset.");
                }
            }
        } else {
            System.out.println("\n\t" + tempSB.toString() + "\n");
        }
    }

    private void annotateHeader(Header aHeader, String aParentSeq, String aSubSeq, Enzyme aEnzyme) {
        if (aEnzyme == null) {
            return;
        }
        int cleavage = aEnzyme.isEnzymaticProduct(aParentSeq, aSubSeq);
        String descr = aHeader.getDescription();
        switch (cleavage) {
            case 4: {
                if (descr != null) {
                    aHeader.setDescription("(*EE*) " + descr);
                    break;
                }
                aHeader.setRest("(*EE*) " + aHeader.getRest());
                break;
            }
            case 2: {
                if (descr != null) {
                    aHeader.setDescription("(*NE*) " + descr);
                    break;
                }
                aHeader.setRest("(*NE*) " + aHeader.getRest());
                break;
            }
            case 3: {
                if (descr != null) {
                    aHeader.setDescription("(*CE*) " + descr);
                    break;
                }
                aHeader.setRest("(*CE*) " + aHeader.getRest());
                break;
            }
            case 1: {
                if (descr != null) {
                    aHeader.setDescription("(*FE*) " + descr);
                    break;
                }
                aHeader.setRest("(*FE*) " + aHeader.getRest());
            }
        }
    }
}

