/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui.workerthreads;

import com.compomics.dbtoolkit.gui.interfaces.CursorModifiable;
import com.compomics.dbtoolkit.gui.interfaces.StatusView;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.util.protein.Protein;
import java.awt.Cursor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;

public class PeptideMappingThread
implements Runnable {
    private JFrame iParent = null;
    DBLoader iLoader = null;
    private ProgressMonitor iMonitor = null;
    private Collection iPeptides = null;
    private Filter iFilter = null;
    private File iOutputFile = null;

    public PeptideMappingThread(JFrame aParent, DBLoader aLoader, Collection aPeptides, Filter aFilter, File aOutputFile) {
        this.iParent = aParent;
        this.iLoader = aLoader;
        this.iPeptides = aPeptides;
        this.iFilter = aFilter;
        this.iOutputFile = aOutputFile;
    }

    public void run() {
        try {
            if (this.iParent != null) {
                if (this.iParent instanceof CursorModifiable) {
                    ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(3));
                } else {
                    this.iParent.setCursor(new Cursor(3));
                }
                if (this.iParent instanceof StatusView) {
                    ((StatusView)((Object)this.iParent)).setStatus("Started mapping " + this.iPeptides.size() + " peptides to protein sequences...");
                }
                this.iMonitor = new ProgressMonitor(this.iParent, "Mapping " + this.iPeptides.size() + " peptides to protein sequences...", "Initializing...", 0, this.iLoader.getMaximum() + 3);
                this.iMonitor.setMillisToDecideToPopup(0);
                this.iMonitor.setMillisToPopup(0);
                this.iMonitor.setNote("Mapping in progress...");
                this.iMonitor.setProgress(1);
            }
            HashMap<String, InnerProteinCollection> iMappings = new HashMap<String, InnerProteinCollection>();
            for (String pepSeq : this.iPeptides) {
                iMappings.put(pepSeq, new InnerProteinCollection(pepSeq));
            }
            Protein entry = null;
            boolean cancelled = false;
            entry = this.iFilter == null ? this.iLoader.nextProtein() : this.iLoader.nextFilteredProtein(this.iFilter);
            while (entry != null && !cancelled) {
                String proteinSequence = entry.getSequence().getSequence();
                String proteinAccession = entry.getHeader().getAccession();
                String proteinDescription = entry.getHeader().getDescription();
                int proteinScore = entry.getHeader().getScore();
                for (String pepSequence : this.iPeptides) {
                    int start = -1;
                    start = proteinSequence.indexOf(pepSequence);
                    if (start <= -1) continue;
                    InnerProteinCollection proteins = (InnerProteinCollection)iMappings.get(pepSequence);
                    String previous = null;
                    if (start > 0) {
                        previous = proteinSequence.substring(start - 1, start);
                    }
                    InnerMappedProtein imp = new InnerMappedProtein(proteinAccession, proteinDescription, previous, start + 1, start + pepSequence.length(), proteinScore);
                    proteins.addProtein(imp);
                }
                if (this.iParent != null) {
                    if (this.iLoader.monitorProgress() < this.iMonitor.getMaximum()) {
                        this.iMonitor.setProgress(this.iLoader.monitorProgress());
                    } else {
                        int delta = this.iLoader.monitorProgress() - this.iMonitor.getMaximum();
                        double modulo = delta / 1024;
                        String affix = "KB";
                        if (modulo % 5.0 == 0.0) {
                            double temp = modulo / 1024.0;
                            if (temp > 1.0) {
                                modulo = temp;
                                affix = "MB";
                            }
                            this.iMonitor.setNote("Reading from buffer (" + new BigDecimal(modulo).setScale(1, 4).doubleValue() + affix + ")...");
                        }
                    }
                    if (this.iMonitor.isCanceled()) {
                        cancelled = true;
                    }
                }
                if (this.iFilter == null) {
                    entry = this.iLoader.nextProtein();
                    continue;
                }
                entry = this.iLoader.nextFilteredProtein(this.iFilter);
            }
            this.iLoader.reset();
            if (!cancelled) {
                if (this.iParent != null) {
                    this.iMonitor.setNote("Evaluating primary accession numbers...");
                }
                TreeSet<InnerMappedProtein> primaries = new TreeSet<InnerMappedProtein>();
                for (InnerProteinCollection lProteins : iMappings.values()) {
                    InnerMappedProtein primary;
                    if (lProteins.getMappedProteinsCount() <= 0 || primaries.contains(primary = lProteins.getPrimaryProtein())) continue;
                    Collection lInnerProteins = lProteins.getMappedProteins();
                    boolean replaced = false;
                    for (InnerMappedProtein lInnerProtein : lInnerProteins) {
                        if (!primaries.contains(lInnerProtein) || lInnerProtein.getScore() != primary.getScore()) continue;
                        lProteins.setPrimary(lInnerProtein);
                        replaced = true;
                        break;
                    }
                    if (replaced) continue;
                    primaries.add(primary);
                }
                if (this.iParent != null) {
                    if (this.iLoader.monitorProgress() < this.iMonitor.getMaximum()) {
                        this.iMonitor.setProgress(this.iLoader.monitorProgress());
                    } else {
                        int delta = this.iLoader.monitorProgress() - this.iMonitor.getMaximum();
                        double modulo = delta / 1024;
                        String affix = "KB";
                        if (modulo % 5.0 == 0.0) {
                            double temp = modulo / 1024.0;
                            if (temp > 1.0) {
                                modulo = temp;
                                affix = "MB";
                            }
                            this.iMonitor.setNote("Reading from buffer (" + new BigDecimal(modulo).setScale(1, 4).doubleValue() + affix + ")...");
                        }
                    }
                    if (this.iMonitor.isCanceled()) {
                        cancelled = true;
                    }
                }
                if (this.iParent != null) {
                    this.iMonitor.setNote("Primary accession numbers assigned. Writing output...");
                }
                BufferedWriter bw = new BufferedWriter(new FileWriter(this.iOutputFile));
                bw.write("Accession\tStart\tStop\tPrevious (if any)\tSequence\tDescription\tIsoforms\n");
                for (String pepSeq : iMappings.keySet()) {
                    InnerProteinCollection mappedProteins = (InnerProteinCollection)iMappings.get(pepSeq);
                    bw.write(mappedProteins.getCSVLine());
                    bw.write("\n");
                }
                bw.flush();
                bw.close();
            }
            if (this.iParent != null) {
                this.iMonitor.setProgress(this.iMonitor.getMaximum());
                this.iMonitor.close();
                if (this.iParent instanceof CursorModifiable) {
                    ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(0));
                } else {
                    this.iParent.setCursor(new Cursor(0));
                }
                String status = null;
                if (cancelled) {
                    status = "Cancelled mapping of peptides to proteins. Output file '" + this.iOutputFile.getAbsolutePath() + "' has been deleted.";
                    this.iOutputFile.delete();
                } else {
                    status = "Mapped " + this.iPeptides.size() + " peptides to proteins; output written to ''" + this.iOutputFile.getAbsolutePath() + "'.";
                }
                if (this.iParent instanceof StatusView) {
                    ((StatusView)((Object)this.iParent)).setStatus(status);
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private class InnerProteinCollection {
        private String iPeptideSequence = null;
        private Collection iMappedProteins = null;
        private InnerMappedProtein iPrimary = null;

        public InnerProteinCollection(String aPeptideSequence) {
            this.iPeptideSequence = aPeptideSequence;
            this.iMappedProteins = new TreeSet();
        }

        public void addProtein(InnerMappedProtein aProtein) {
            this.iMappedProteins.add(aProtein);
            if (this.iPrimary == null) {
                this.iPrimary = aProtein;
            } else if (aProtein.getScore() > this.iPrimary.getScore()) {
                this.iPrimary = aProtein;
            } else if (aProtein.getScore() == this.iPrimary.getScore() && aProtein.compareTo(this.iPrimary) < 0) {
                this.iPrimary = aProtein;
            }
        }

        public void setPrimary(InnerMappedProtein aProtein) {
            if (!this.iMappedProteins.contains(aProtein)) {
                throw new IllegalArgumentException("The protein you specified as primary (" + aProtein.getIsoformString() + ") is not part of this collection!");
            }
            this.iPrimary = aProtein;
        }

        public Collection getMappedProteins() {
            return this.iMappedProteins;
        }

        public InnerMappedProtein getPrimaryProtein() {
            return this.iPrimary;
        }

        public String getCSVLine() {
            StringBuffer sb = new StringBuffer();
            if (this.iMappedProteins.size() == 0) {
                sb.append(" -- No mapping found for sequence: " + this.iPeptideSequence + "!");
            } else {
                sb.append(this.iPrimary.getAccession() + "\t" + this.iPrimary.getStart() + "\t" + this.iPrimary.getStop() + "\t" + (this.iPrimary.getPrevious() == null ? "-" : this.iPrimary.getPrevious()) + "\t" + this.iPeptideSequence + "\t" + this.iPrimary.getDescription() + "\t");
                for (InnerMappedProtein lProtein : this.iMappedProteins) {
                    if (lProtein.equals(this.iPrimary)) continue;
                    sb.append(lProtein.getIsoformString() + "^A");
                }
                if (sb.charAt(sb.length() - 1) == 'A' && sb.charAt(sb.length() - 2) == '^') {
                    sb.delete(sb.length() - 2, sb.length());
                }
            }
            return sb.toString();
        }

        public int getMappedProteinsCount() {
            return this.iMappedProteins.size();
        }
    }

    private class InnerMappedProtein
    implements Comparable {
        private String iAccession = null;
        private String iDescription = null;
        private int iStart = -1;
        private int iStop = -1;
        private int iScore = -1;
        private String iPrevious = null;

        public InnerMappedProtein(String aAccession, String aDescription, String aPrevious, int aStart, int aStop, int aScore) {
            this.iAccession = aAccession;
            this.iDescription = aDescription;
            this.iPrevious = aPrevious;
            this.iStart = aStart;
            this.iStop = aStop;
            this.iScore = aScore;
        }

        public String getAccession() {
            return this.iAccession;
        }

        public String getDescription() {
            return this.iDescription;
        }

        public String getPrevious() {
            return this.iPrevious;
        }

        public int getStart() {
            return this.iStart;
        }

        public int getStop() {
            return this.iStop;
        }

        public int getScore() {
            return this.iScore;
        }

        public String getIsoformString() {
            return this.iAccession + " (" + this.iStart + "-" + this.iStop + ")";
        }

        public int compareTo(Object o) {
            InnerMappedProtein imp = (InnerMappedProtein)o;
            int result = 0;
            result = this.getAccession().compareTo(imp.getAccession());
            if (result == 0) {
                result = this.getStart() - imp.getStart();
            }
            return result;
        }

        public boolean equals(Object o) {
            boolean result = false;
            if (this.getClass().getName().equals(o.getClass().getName())) {
                InnerMappedProtein imp = (InnerMappedProtein)o;
                if (this.getAccession().equals(imp.getAccession()) && this.getStart() == imp.getStart()) {
                    result = true;
                }
            }
            return result;
        }
    }
}

