/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui.workerthreads;

import com.compomics.dbtoolkit.gui.interfaces.CursorModifiable;
import com.compomics.dbtoolkit.gui.interfaces.StatusView;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.util.protein.AASequenceImpl;
import com.compomics.util.protein.Protein;
import java.awt.Cursor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;

public class FASTAOutputThread
implements Runnable {
    private DBLoader iLoader = null;
    private File iOutput = null;
    private JFrame iParent = null;
    private ProgressMonitor iMonitor = null;
    private Filter iFilter = null;
    private HashMap iSubstitutions = null;
    private double iMinMass = -1.0;
    private double iMaxMass = -1.0;

    public FASTAOutputThread(JFrame aParent, DBLoader aLoader, File aOutput) {
        this(aParent, aLoader, aOutput, null, null, -1.0, -1.0);
    }

    public FASTAOutputThread(JFrame aParent, DBLoader aLoader, File aOutput, Filter aFilter) {
        this(aParent, aLoader, aOutput, aFilter, null, -1.0, -1.0);
    }

    public FASTAOutputThread(JFrame aParent, DBLoader aLoader, File aOutput, Filter aFilter, double aMinMass, double aMaxMass) {
        this(aParent, aLoader, aOutput, aFilter, null, aMinMass, aMaxMass);
    }

    public FASTAOutputThread(JFrame aParent, DBLoader aLoader, File aOutput, HashMap aSubstitutions) {
        this(aParent, aLoader, aOutput, null, aSubstitutions, -1.0, -1.0);
    }

    public FASTAOutputThread(JFrame aParent, DBLoader aLoader, File aOutput, Filter aFilter, HashMap aSubstitutions, double aMinMass, double aMaxMass) {
        this.iParent = aParent;
        this.iLoader = aLoader;
        this.iOutput = aOutput;
        this.iFilter = aFilter;
        this.iSubstitutions = aSubstitutions;
        this.iMinMass = aMinMass;
        this.iMaxMass = aMaxMass;
    }

    public static HashMap parseSubstitutions(String aSubstitutionString) throws ParseException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (aSubstitutionString == null) {
            throw new IllegalArgumentException("The substitution String you tried to parse was 'null'!");
        }
        if ((aSubstitutionString = aSubstitutionString.trim()).startsWith(";")) {
            aSubstitutionString = aSubstitutionString.substring(1);
        }
        if (aSubstitutionString.endsWith(";")) {
            aSubstitutionString = aSubstitutionString.substring(0, aSubstitutionString.length() - 1);
        }
        String substString = aSubstitutionString;
        while (substString.length() > 0) {
            String set = null;
            if (substString.indexOf(";") > 0) {
                set = substString.substring(0, substString.indexOf(";"));
                substString = substString.substring(substString.indexOf(";") + 1).trim();
            } else {
                set = substString;
                substString = "";
            }
            int equals = set.indexOf("=");
            if (equals <= 0) {
                throw new ParseException("Unable to parse substitutions: missing equals sign in set!", aSubstitutionString.indexOf(set));
            }
            String targets = set.substring(0, equals).trim();
            String destination = set.substring(equals + 1).trim();
            int comma = -1;
            while ((comma = targets.indexOf(",")) > 0) {
                String target = targets.substring(0, comma).trim();
                result.put(target, destination);
                targets = targets.substring(comma + 1).trim();
            }
            result.put(targets, destination);
        }
        return result;
    }

    public void run() {
        try {
            int entriesWritten = 0;
            if (this.iParent != null) {
                if (this.iParent instanceof CursorModifiable) {
                    ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(3));
                } else {
                    this.iParent.setCursor(new Cursor(3));
                }
                if (this.iParent instanceof StatusView) {
                    ((StatusView)((Object)this.iParent)).setStatus("Started outputting FASTA database to '" + this.iOutput.getAbsoluteFile() + "'...");
                }
                this.iMonitor = new ProgressMonitor(this.iParent, "Outputting FASTA database to '" + this.iOutput.getAbsoluteFile() + "'...", "Initializing...", 0, this.iLoader.getMaximum() + 1);
                this.iMonitor.setMillisToDecideToPopup(0);
                this.iMonitor.setMillisToPopup(0);
                this.iMonitor.setNote("Writing database file...");
                this.iMonitor.setProgress(1);
            }
            PrintWriter out = new PrintWriter(new FileWriter(this.iOutput));
            String entry = null;
            boolean cancelled = false;
            entry = this.iFilter == null ? this.iLoader.nextFASTAEntry() : this.iLoader.nextFilteredFASTAEntry(this.iFilter);
            while (entry != null && !cancelled) {
                if (this.iSubstitutions == null) {
                    Protein p = new Protein(entry);
                    if (this.iMinMass < 0.0 && this.iMaxMass < 0.0 || this.iMinMass >= 0.0 && this.iMaxMass > 0.0 && p.getMass() >= this.iMinMass && p.getMass() <= this.iMaxMass) {
                        out.print(entry + "\n");
                        ++entriesWritten;
                    }
                } else {
                    BufferedReader br = new BufferedReader(new StringReader(entry));
                    String header = br.readLine();
                    String sequenceLine = null;
                    while ((sequenceLine = br.readLine()) != null) {
                        sequenceLine = sequenceLine.trim();
                        for (String target : this.iSubstitutions.keySet()) {
                            String destination = (String)this.iSubstitutions.get(target);
                            while (sequenceLine.indexOf(target) >= 0) {
                                int start = sequenceLine.indexOf(target);
                                sequenceLine = sequenceLine.substring(0, start) + destination + sequenceLine.substring(start + target.length());
                            }
                        }
                        AASequenceImpl seq = new AASequenceImpl(sequenceLine);
                        if (!(this.iMinMass < 0.0 && this.iMaxMass < 0.0) && (!(this.iMinMass >= 0.0) || !(this.iMaxMass > 0.0) || !(seq.getMass() >= this.iMinMass) || !(seq.getMass() <= this.iMaxMass))) continue;
                        out.print(header + "\n");
                        out.print(sequenceLine + "\n");
                        ++entriesWritten;
                    }
                    br.close();
                }
                if (this.iParent != null) {
                    if (this.iLoader.monitorProgress() < this.iMonitor.getMaximum()) {
                        this.iMonitor.setProgress(this.iLoader.monitorProgress());
                    } else {
                        int delta = this.iLoader.monitorProgress() - this.iMonitor.getMaximum();
                        double modulo = delta / 1024;
                        String affix = "KB";
                        if (modulo % 5.0 == 0.0) {
                            double temp = modulo / 1024.0;
                            if (temp > 1.0) {
                                modulo = temp;
                                affix = "MB";
                            }
                            this.iMonitor.setNote("Reading from buffer (" + new BigDecimal(modulo).setScale(1, 4).doubleValue() + affix + ")...");
                        }
                    }
                    if (this.iMonitor.isCanceled()) {
                        cancelled = true;
                    }
                }
                if (this.iFilter == null) {
                    entry = this.iLoader.nextFASTAEntry();
                    continue;
                }
                entry = this.iLoader.nextFilteredFASTAEntry(this.iFilter);
            }
            out.flush();
            out.close();
            this.iLoader.reset();
            if (this.iParent != null) {
                this.iMonitor.setProgress(this.iMonitor.getMaximum());
                this.iMonitor.close();
                if (this.iParent instanceof CursorModifiable) {
                    ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(0));
                } else {
                    this.iParent.setCursor(new Cursor(0));
                }
                String status = null;
                if (cancelled) {
                    this.iOutput.delete();
                    status = "Cancelled output to file '" + this.iOutput.getAbsoluteFile() + "'. Deleted unfinished output file.";
                } else {
                    status = "Created FASTA DB file '" + this.iOutput.getAbsoluteFile() + "', written " + entriesWritten + " entries.";
                }
                if (this.iParent instanceof StatusView) {
                    ((StatusView)((Object)this.iParent)).setStatus(status);
                }
            } else {
                System.out.println("Created FASTA DB file '" + this.iOutput.getAbsoluteFile() + "', written " + entriesWritten + " entries.");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

