/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui.workerthreads;

import com.compomics.dbtoolkit.gui.interfaces.CursorModifiable;
import com.compomics.dbtoolkit.gui.interfaces.StatusView;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.math.BigDecimal;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;

public class CounterThread
implements Runnable {
    private JFrame iParent = null;
    DBLoader iLoader = null;
    private ProgressMonitor iMonitor = null;
    private String iDBName = null;

    public CounterThread(JFrame aParent, DBLoader aLoader, String aDBName) {
        this.iParent = aParent;
        this.iLoader = aLoader;
        this.iDBName = aDBName;
    }

    public void run() {
        try {
            if (this.iParent instanceof CursorModifiable) {
                ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(3));
            } else {
                this.iParent.setCursor(new Cursor(3));
            }
            if (this.iParent instanceof StatusView) {
                ((StatusView)((Object)this.iParent)).setStatus("Started counting entries in database '" + this.iDBName + "'...");
            }
            int max = this.iLoader.getMaximum();
            this.iMonitor = new ProgressMonitor(this.iParent, "Counting entries in database '" + this.iDBName + "'...", "Initializing...", 0, max + 1);
            this.iMonitor.setMillisToDecideToPopup(0);
            this.iMonitor.setMillisToPopup(0);
            this.iMonitor.setNote("Counting...");
            this.iMonitor.setProgress(1);
            Timer t = new Timer(500, new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    int progress = CounterThread.this.iLoader.monitorProgress();
                    if (progress < CounterThread.this.iMonitor.getMaximum()) {
                        CounterThread.this.iMonitor.setProgress(progress);
                    } else {
                        int delta = progress - CounterThread.this.iMonitor.getMaximum();
                        double modulo = delta / 1024;
                        String affix = "KB";
                        if (modulo % 5.0 == 0.0) {
                            double temp = modulo / 1024.0;
                            if (temp > 1.0) {
                                modulo = temp;
                                affix = "MB";
                            }
                            CounterThread.this.iMonitor.setNote("Reading from buffer (" + new BigDecimal(modulo).setScale(1, 4).doubleValue() + affix + ")...");
                        }
                    }
                    if (CounterThread.this.iMonitor.isCanceled()) {
                        CounterThread.this.iLoader.cancelCount();
                        CounterThread.this.iMonitor.setNote("Cancelling counting operation...");
                    }
                }
            });
            t.start();
            long count = this.iLoader.countNumberOfEntries();
            t.stop();
            this.iMonitor.setProgress(this.iMonitor.getMaximum());
            this.iMonitor.close();
            if (this.iParent instanceof CursorModifiable) {
                ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(0));
            }
            this.iParent.setCursor(new Cursor(0));
            String status = null;
            status = count == -1L ? "Count in database '" + this.iDBName + "' was cancelled by user." : "Counted " + count + " entries in database '" + this.iDBName + "'.";
            if (this.iParent instanceof StatusView) {
                ((StatusView)((Object)this.iParent)).setStatus(status);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

