/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui.workerthreads;

import com.compomics.dbtoolkit.gui.interfaces.CursorModifiable;
import com.compomics.dbtoolkit.gui.interfaces.StatusView;
import com.compomics.util.io.MonitorableFileInputStream;
import com.compomics.util.io.MonitorableInputStream;
import java.awt.Cursor;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;

public class ConcatenateThread
implements Runnable {
    private File iSource1 = null;
    private File iSource2 = null;
    private File iDestination = null;
    private JFrame iParent = null;
    private ProgressMonitor iMonitor = null;

    public ConcatenateThread(File aSource, File aDestination) {
        this(aSource, aDestination, (JFrame)null);
    }

    public ConcatenateThread(File aSource, File aDestination, JFrame aParent) {
        this.iSource1 = aSource;
        this.iDestination = aDestination;
        this.iParent = aParent;
    }

    public ConcatenateThread(File aSource1, File aSource2, File aDestination) {
        this(aSource1, aSource2, aDestination, null);
    }

    public ConcatenateThread(File aSource1, File aSource2, File aDestination, JFrame aParent) {
        this.iSource1 = aSource1;
        this.iSource2 = aSource2;
        this.iDestination = aDestination;
        this.iParent = aParent;
    }

    public void run() {
        if (this.iSource2 == null) {
            this.copyFile();
        } else {
            this.appendTwoFiles();
        }
    }

    private void copyFile() {
        try {
            MonitorableFileInputStream mis = new MonitorableFileInputStream(this.iSource1);
            BufferedInputStream bis = new BufferedInputStream(mis, 25600);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.iDestination), 25600);
            if (this.iParent != null) {
                if (this.iParent instanceof CursorModifiable) {
                    ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(3));
                } else {
                    this.iParent.setCursor(new Cursor(3));
                }
                if (this.iParent instanceof StatusView) {
                    ((StatusView)((Object)this.iParent)).setStatus("Started copying file '" + this.iSource1.getAbsoluteFile() + "' to '" + this.iDestination.getAbsoluteFile() + "'...");
                }
                this.iMonitor = new ProgressMonitor(this.iParent, "Copying file '" + this.iSource1.getAbsoluteFile() + "' to '" + this.iDestination.getAbsoluteFile() + "'...", "Initializing...", 0, ((MonitorableInputStream)mis).getMaximum() + 1);
                this.iMonitor.setMillisToDecideToPopup(500);
                this.iMonitor.setMillisToPopup(500);
                this.iMonitor.setNote("Copying file...");
                this.iMonitor.setProgress(1);
            }
            int current = 0;
            int previous = 0;
            boolean cancelled = false;
            while ((current = bis.read()) != -1 && !cancelled) {
                bos.write(current);
                if (this.iParent == null) continue;
                int local = ((MonitorableInputStream)mis).monitorProgress();
                if (local > previous) {
                    if (local < this.iMonitor.getMaximum()) {
                        this.iMonitor.setProgress(local);
                    } else {
                        int delta = local - this.iMonitor.getMaximum();
                        double modulo = delta / 1024;
                        String affix = "KB";
                        if (modulo % 5.0 == 0.0) {
                            double temp = modulo / 1024.0;
                            if (temp > 1.0) {
                                modulo = temp;
                                affix = "MB";
                            }
                            this.iMonitor.setNote("Reading from buffer (" + new BigDecimal(modulo).setScale(1, 4).doubleValue() + affix + ")...");
                        }
                    }
                    previous = local;
                }
                if (!this.iMonitor.isCanceled()) continue;
                cancelled = true;
            }
            bos.flush();
            bos.close();
            bis.close();
            if (this.iParent != null) {
                this.iMonitor.setProgress(this.iMonitor.getMaximum());
                this.iMonitor.close();
                if (this.iParent instanceof CursorModifiable) {
                    ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(0));
                } else {
                    this.iParent.setCursor(new Cursor(0));
                }
                String status = null;
                if (cancelled) {
                    this.iDestination.delete();
                    status = "Cancelled copy to file '" + this.iDestination + "'. Deleted unfinished output file.";
                } else {
                    StringBuffer tempSB = new StringBuffer("Copied file '" + this.iSource1 + "' to output file '" + this.iDestination + "'.");
                    status = tempSB.toString();
                }
                if (this.iParent instanceof StatusView) {
                    ((StatusView)((Object)this.iParent)).setStatus(status);
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void appendTwoFiles() {
        try {
            MonitorableFileInputStream mis1 = new MonitorableFileInputStream(this.iSource1);
            MonitorableFileInputStream mis2 = new MonitorableFileInputStream(this.iSource2);
            BufferedInputStream bis1 = new BufferedInputStream(mis1, 25600);
            BufferedInputStream bis2 = new BufferedInputStream(mis2, 25600);
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.iDestination), 25600);
            if (this.iParent != null) {
                if (this.iParent instanceof CursorModifiable) {
                    ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(3));
                } else {
                    this.iParent.setCursor(new Cursor(3));
                }
                if (this.iParent instanceof StatusView) {
                    ((StatusView)((Object)this.iParent)).setStatus("Started appending files '" + this.iSource1 + "' and '" + this.iSource2 + "' to '" + this.iDestination + "'...");
                }
                this.iMonitor = new ProgressMonitor(this.iParent, "Appending files '" + this.iSource1 + "' and '" + this.iSource2 + "' to '" + this.iDestination + "'...", "Initializing...", 0, ((MonitorableInputStream)mis1).getMaximum() + ((MonitorableInputStream)mis2).getMaximum() + 1);
                this.iMonitor.setMillisToDecideToPopup(500);
                this.iMonitor.setMillisToPopup(500);
                this.iMonitor.setNote("Appending files...");
                this.iMonitor.setProgress(1);
            }
            int current = 0;
            int previous = 0;
            boolean cancelled = false;
            while ((current = bis1.read()) != -1 && !cancelled) {
                bos.write(current);
                if (this.iParent == null) continue;
                int local = ((MonitorableInputStream)mis1).monitorProgress();
                if (local > previous) {
                    if (local < this.iMonitor.getMaximum()) {
                        this.iMonitor.setProgress(local);
                    } else {
                        int delta = local - this.iMonitor.getMaximum();
                        double modulo = delta / 1024;
                        String affix = "KB";
                        if (modulo % 5.0 == 0.0) {
                            double temp = modulo / 1024.0;
                            if (temp > 1.0) {
                                modulo = temp;
                                affix = "MB";
                            }
                            this.iMonitor.setNote("Reading from buffer (" + new BigDecimal(modulo).setScale(1, 4).doubleValue() + affix + ")...");
                        }
                    }
                    previous = local;
                }
                if (!this.iMonitor.isCanceled()) continue;
                cancelled = true;
            }
            int currentProg = ((MonitorableInputStream)mis1).getMaximum();
            while ((current = bis2.read()) != -1 && !cancelled) {
                bos.write(current);
                if (this.iParent == null) continue;
                int local = currentProg + ((MonitorableInputStream)mis2).monitorProgress();
                if (local > previous) {
                    if (local < this.iMonitor.getMaximum()) {
                        this.iMonitor.setProgress(local);
                    } else {
                        int delta = local - this.iMonitor.getMaximum();
                        double modulo = delta / 1024;
                        String affix = "KB";
                        if (modulo % 5.0 == 0.0) {
                            double temp = modulo / 1024.0;
                            if (temp > 1.0) {
                                modulo = temp;
                                affix = "MB";
                            }
                            this.iMonitor.setNote("Reading from buffer (" + new BigDecimal(modulo).setScale(1, 4).doubleValue() + affix + ")...");
                        }
                    }
                    previous = local;
                }
                if (!this.iMonitor.isCanceled()) continue;
                cancelled = true;
            }
            bos.flush();
            bos.close();
            bis1.close();
            bis2.close();
            if (this.iParent != null) {
                this.iMonitor.setProgress(this.iMonitor.getMaximum());
                this.iMonitor.close();
                if (this.iParent instanceof CursorModifiable) {
                    ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(0));
                } else {
                    this.iParent.setCursor(new Cursor(0));
                }
                String status = null;
                if (cancelled) {
                    this.iDestination.delete();
                    status = "Cancelled appending to file '" + this.iDestination + "'. Deleted unfinished output file.";
                } else {
                    StringBuffer tempSB = new StringBuffer("Appended files '" + this.iSource1 + "' and '" + this.iSource2 + "' to output file '" + this.iDestination + "'.");
                    status = tempSB.toString();
                }
                if (this.iParent instanceof StatusView) {
                    ((StatusView)((Object)this.iParent)).setStatus(status);
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

