/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui.workerthreads;

import com.compomics.dbtoolkit.gui.interfaces.CursorModifiable;
import com.compomics.dbtoolkit.gui.interfaces.StatusView;
import com.compomics.dbtoolkit.io.UnknownDBFormatException;
import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.util.protein.Header;
import com.compomics.util.protein.Protein;
import java.awt.Cursor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;

public class ClearRedundancyThread
implements Runnable {
    private JFrame iParent = null;
    private ProgressMonitor iMonitor = null;
    private File iTempFolder = null;
    private File iOutput = null;
    private DBLoader iLoader = null;
    AutoDBLoader iAuto = null;
    private int iCurrentProgress = 0;
    private boolean iCancelled = false;

    public ClearRedundancyThread(File aTempFolder, File aOutput, DBLoader aLoader, AutoDBLoader aAuto) {
        this(aTempFolder, aOutput, aLoader, aAuto, null);
    }

    public ClearRedundancyThread(File aTempFolder, File aOutput, DBLoader aLoader, AutoDBLoader aAuto, JFrame aParent) {
        this.iTempFolder = aTempFolder;
        this.iOutput = aOutput;
        this.iLoader = aLoader;
        this.iAuto = aAuto;
        this.iParent = aParent;
    }

    public void run() {
        try {
            int i;
            int factor = 1;
            if (this.iParent != null) {
                if (this.iParent instanceof CursorModifiable) {
                    ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(3));
                } else {
                    this.iParent.setCursor(new Cursor(3));
                }
                if (this.iParent instanceof StatusView) {
                    ((StatusView)((Object)this.iParent)).setStatus("Started clearing redundancy from DB (outputting to '" + this.iOutput.getAbsoluteFile() + "')...");
                }
                int fullProgress = this.iLoader.getMaximum() * 2;
                this.iMonitor = new ProgressMonitor(this.iParent, "Clearing redundancy from DB. Outputting to '" + this.iOutput.getAbsoluteFile() + "'...", "Initializing...", 0, fullProgress + 1);
                this.iMonitor.setMillisToDecideToPopup(0);
                this.iMonitor.setMillisToPopup(0);
                this.iMonitor.setNote("Subdividing database into temporary files in '" + this.iTempFolder.getAbsolutePath() + "'...");
                this.iMonitor.setProgress(1);
                this.iCancelled = false;
            }
            Protein protein = null;
            HashMap<String, File> files = new HashMap<String, File>();
            HashMap<String, PrintWriter> writers = new HashMap<String, PrintWriter>();
            int numberOfEntriesRead = 0;
            int writtenToResultFile = 0;
            while ((protein = this.iLoader.nextProtein()) != null && !this.iCancelled) {
                ++numberOfEntriesRead;
                long length = protein.getLength();
                String key = Long.toString(length);
                if (writers.get(key) != null) {
                    PrintWriter out = (PrintWriter)writers.get(key);
                    protein.writeToFASTAFile(out);
                } else {
                    File outFile = new File(this.iTempFolder + "/" + key + ".tmp");
                    outFile.createNewFile();
                    PrintWriter out = new PrintWriter(new FileWriter(outFile));
                    protein.writeToFASTAFile(out);
                    files.put(key, outFile);
                    writers.put(key, out);
                }
                if (this.iParent == null) continue;
                this.iCurrentProgress = this.iLoader.monitorProgress();
                this.iMonitor.setProgress(this.iCurrentProgress);
                if (!this.iMonitor.isCanceled()) continue;
                this.iCancelled = true;
            }
            if (this.iParent != null) {
                this.iMonitor.setNote("Switching to generated temporary files...");
            }
            this.iLoader.reset();
            for (PrintWriter out : writers.values()) {
                out.flush();
                out.close();
                out = null;
            }
            Set col = files.keySet();
            String[] allFiles = new String[col.size()];
            col.toArray(allFiles);
            long[] sorted = new long[allFiles.length];
            int combinedSize = 0;
            for (int i2 = 0; i2 < allFiles.length; ++i2) {
                String lFile = allFiles[i2];
                sorted[i2] = Long.parseLong(allFiles[i2]);
                allFiles[i2] = null;
                if (this.iParent == null) continue;
                combinedSize += (int)((File)files.get(lFile)).length();
            }
            Arrays.sort(sorted);
            if (this.iParent != null) {
                ProgressMonitor pm = this.iMonitor;
                int max = combinedSize;
                this.iCurrentProgress = this.iMonitor.getMaximum() / 2;
                this.iMonitor = new ProgressMonitor(this.iParent, "Clearing redundancy from DB. Outputting to '" + this.iOutput.getAbsoluteFile() + "'...", "Initializing temporary files...", 0, this.iCurrentProgress + max);
                this.iMonitor.setMillisToDecideToPopup(0);
                this.iMonitor.setMillisToPopup(0);
                this.iMonitor.setNote("Processing temporary files...");
                this.iMonitor.setProgress(this.iCurrentProgress);
                pm.close();
            }
            PrintWriter outputWriter = null;
            if (!this.iCancelled) {
                outputWriter = new PrintWriter(new FileWriter(this.iOutput));
            }
            for (i = 0; i < sorted.length && !this.iCancelled; ++i) {
                File temp = (File)files.get(Long.toString(sorted[i]));
                writtenToResultFile += this.processRedundancy(temp, outputWriter, factor);
            }
            if (outputWriter != null) {
                outputWriter.flush();
                outputWriter.close();
            }
            if (this.iParent != null) {
                this.iMonitor.setNote("Cleaning up temporary files...");
            }
            for (i = 0; i < sorted.length; ++i) {
                String lFile = Long.toString(sorted[i]);
                File temp = (File)files.get(lFile);
                boolean gone = false;
                int count = 0;
                while (!gone) {
                    gone = temp.delete();
                    if (++count <= 2) continue;
                    System.gc();
                    count = 0;
                }
                if (this.iParent == null || this.iCurrentProgress >= this.iMonitor.getMaximum()) continue;
                ++this.iCurrentProgress;
                this.iMonitor.setProgress(this.iCurrentProgress);
            }
            if (this.iParent != null) {
                this.iMonitor.setProgress(this.iMonitor.getMaximum());
            }
            StringBuffer tempSB = new StringBuffer("Created cleared DB file '" + this.iOutput.getAbsoluteFile() + "'.");
            tempSB.append(" Written " + writtenToResultFile + " entries to result file (" + numberOfEntriesRead + " entries read from original DB - reduction to " + writtenToResultFile * 100 / numberOfEntriesRead + "% of DB)");
            if (this.iParent != null) {
                this.iMonitor.setProgress(this.iMonitor.getMaximum());
                this.iMonitor.close();
                if (this.iParent instanceof CursorModifiable) {
                    ((CursorModifiable)((Object)this.iParent)).setCursorOnComponents(new Cursor(0));
                } else {
                    this.iParent.setCursor(new Cursor(0));
                }
                String status = null;
                if (this.iCancelled) {
                    this.iOutput.delete();
                    status = "Cancelled DB output to file '" + this.iOutput.getAbsoluteFile() + "'. Deleted unfinished output file and temporary files.";
                } else {
                    status = tempSB.toString();
                }
                if (this.iParent instanceof StatusView) {
                    ((StatusView)((Object)this.iParent)).setStatus(status);
                }
            } else {
                System.out.println("\n\t" + tempSB.toString() + "\n");
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private int processRedundancy(File aFile, PrintWriter aOutput, int aFactor) throws IOException {
        int counter = 0;
        try {
            DBLoader loader = this.iAuto.getLoaderForFile(aFile.getAbsolutePath());
            Protein protein = null;
            HashMap<String, Header> sequences = new HashMap<String, Header>();
            if (this.iParent != null) {
                this.iMonitor.setNote("Processing '" + aFile.getAbsolutePath() + "'...");
            }
            while ((protein = loader.nextProtein()) != null && !this.iCancelled) {
                String sequence = protein.getSequence().getSequence();
                Header header = protein.getHeader();
                Object temp = sequences.get(sequence);
                if (temp != null) {
                    Header inHash = (Header)temp;
                    if (inHash.getScore() < header.getScore()) {
                        if (inHash.hasAddenda()) {
                            String addenda = inHash.getAddenda();
                            header.addAddendum(addenda);
                        }
                        header.addAddendum(inHash.getCoreHeader());
                        sequences.put(sequence, header);
                    } else {
                        inHash.addAddendum(header.getCoreHeader());
                    }
                } else {
                    sequences.put(sequence, header);
                }
                if (this.iParent == null) continue;
                this.iMonitor.setProgress(this.iCurrentProgress + loader.monitorProgress());
                if (!this.iMonitor.isCanceled()) continue;
                this.iCancelled = true;
            }
            this.iCurrentProgress += loader.getMaximum();
            loader.close();
            loader = null;
            Iterator iterator = sequences.keySet().iterator();
            if (this.iParent != null) {
                this.iMonitor.setNote("Writing output (progress may appear to halt)...");
            }
            while (iterator.hasNext() && !this.iCancelled) {
                String sequence = (String)iterator.next();
                Header header = (Header)sequences.get(sequence);
                Protein toWrite = new Protein(header.getFullHeaderWithAddenda(), sequence);
                toWrite.writeToFASTAFile(aOutput);
                ++counter;
                if (this.iParent == null || !this.iMonitor.isCanceled()) continue;
                this.iCancelled = true;
            }
            aOutput.flush();
        }
        catch (UnknownDBFormatException e) {
            e.printStackTrace();
        }
        return counter;
    }
}

