/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui.components;

import com.compomics.dbtoolkit.gui.interfaces.StatusView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class StatusPanel
extends JPanel
implements StatusView {
    private JLabel lblState = null;
    private JLabel lblError = null;
    private JTextArea txtState = null;
    private JTextArea txtError = null;
    JLabel lblStatus = null;
    JLabel lblErrors = null;
    private boolean iLog = false;
    private SimpleDateFormat iSDF = null;

    public StatusPanel() {
        this("Status report", true, true);
    }

    public StatusPanel(boolean aBorder) {
        this("Status report", true, aBorder);
    }

    public StatusPanel(String aToolTip, boolean aLog, boolean aBorder) {
        super.setLayout(new BoxLayout(this, 1));
        this.iLog = aLog;
        JPanel status = new JPanel(new BorderLayout());
        this.lblStatus = new JLabel(" Status : ", 2);
        this.lblStatus.setForeground(Color.blue);
        this.lblStatus.setFont(this.lblStatus.getFont().deriveFont(1));
        if (!this.iLog) {
            this.lblState = new JLabel("", 2);
            this.lblState.setForeground(Color.blue);
            status.add((Component)this.lblStatus, "West");
            status.add((Component)this.lblState, "Center");
        } else {
            this.txtState = new JTextArea(3, 15);
            this.txtState.setForeground(Color.blue);
            this.txtState.setEditable(false);
            status.add((Component)this.lblStatus, "North");
            status.add((Component)new JScrollPane(this.txtState), "Center");
        }
        JPanel error = new JPanel(new BorderLayout());
        this.lblErrors = new JLabel(" Errors : ", 2);
        this.lblErrors.setForeground(Color.red);
        this.lblErrors.setFont(this.lblErrors.getFont().deriveFont(1));
        if (!this.iLog) {
            this.lblError = new JLabel("", 2);
            this.lblError.setForeground(Color.red);
            error.add((Component)this.lblErrors, "West");
            error.add((Component)this.lblError, "Center");
        } else {
            this.txtError = new JTextArea(3, 15);
            this.txtError.setForeground(Color.red);
            this.txtError.setEditable(false);
            error.add((Component)this.lblErrors, "North");
            error.add((Component)new JScrollPane(this.txtError), "Center");
        }
        if (aBorder) {
            this.setBorder(BorderFactory.createEtchedBorder(1));
        }
        this.setToolTipText(aToolTip);
        this.add(status);
        this.add(Box.createRigidArea(new Dimension(status.getWidth(), 5)));
        this.add(error);
        this.iSDF = new SimpleDateFormat("dd-MM-yyyy (HH:mm:ss) : ");
    }

    public void setStatus(String aState) {
        if (!this.iLog) {
            this.lblState.setText(aState);
        } else {
            this.txtState.append(this.getTimestamp() + aState + "\n");
            this.txtState.setCaretPosition(this.txtState.getText().length());
        }
    }

    public void setError(String aError) {
        if (!this.iLog) {
            this.lblError.setText(aError);
        } else {
            this.txtError.append(this.getTimestamp() + aError + "\n");
            this.txtError.setCaretPosition(this.txtError.getText().length());
        }
    }

    public void setStatusColor(Color aColor) {
        this.lblStatus.setForeground(aColor);
        if (!this.iLog) {
            this.lblState.setForeground(aColor);
        } else {
            this.txtState.setForeground(aColor);
        }
    }

    public void setErrorColor(Color aColor) {
        this.lblErrors.setForeground(aColor);
        if (!this.iLog) {
            this.lblError.setForeground(aColor);
        } else {
            this.txtError.setForeground(aColor);
        }
    }

    private String getTimestamp() {
        return this.iSDF.format(new Date());
    }
}

