/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui.components;

import com.compomics.dbtoolkit.gui.workerthreads.ProcessThread;
import com.compomics.dbtoolkit.io.implementations.ProteinSequenceRegExpFilter;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class RegularExpressionFilterDialog
extends JDialog {
    private JFrame iParent = null;
    private JComboBox cmbPrimFilter = null;
    private JTextField txtPrimFilter = null;
    private JTextArea txtRegularExpression = null;
    private JTextArea txtTestString = null;
    private JButton btnTest = null;
    private JButton btnOK = null;
    private JButton btnCancel = null;
    private DBLoader iLoader = null;
    private String iDBType = null;
    private static HashMap iFilters = null;

    public RegularExpressionFilterDialog(JFrame aParent, String aTitle, DBLoader aLoader, String aDBType) {
        super(aParent, aTitle, true);
        this.iParent = aParent;
        this.iLoader = aLoader;
        this.iDBType = aDBType;
        if (iFilters == null) {
            this.loadFilters();
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                RegularExpressionFilterDialog.this.close();
            }
        });
        this.constructScreen();
        this.setResizable(false);
    }

    private void constructScreen() {
        JPanel top = this.getPrimaryFilterPanel();
        JPanel middle = this.getMainPanel();
        JPanel bottom = this.getOptionPanel();
        this.getContentPane().add((Component)top, "North");
        this.getContentPane().add((Component)bottom, "South");
        this.getContentPane().add((Component)middle, "Center");
        this.pack();
    }

    private JPanel getPrimaryFilterPanel() {
        this.txtPrimFilter = new JTextField(20);
        this.txtPrimFilter.setEnabled(false);
        Object[] resultString = null;
        Object loTemp = iFilters.get(this.iDBType.toUpperCase());
        if (loTemp != null) {
            HashMap allFilters = (HashMap)loTemp;
            Set s = allFilters.keySet();
            resultString = new String[s.size() + 1];
            s.toArray(resultString);
            resultString[resultString.length - 1] = "None";
        } else {
            resultString = new String[]{"None"};
        }
        Arrays.sort(resultString);
        this.cmbPrimFilter = new JComboBox<Object>(resultString);
        this.cmbPrimFilter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && ((String)e.getItem()).equalsIgnoreCase("None")) {
                    RegularExpressionFilterDialog.this.txtPrimFilter.setEnabled(false);
                } else {
                    RegularExpressionFilterDialog.this.txtPrimFilter.setEnabled(true);
                }
            }
        });
        this.cmbPrimFilter.setSelectedItem("None");
        this.cmbPrimFilter.setMaximumSize(this.cmbPrimFilter.getPreferredSize());
        this.txtPrimFilter.setMaximumSize(this.txtPrimFilter.getPreferredSize());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createTitledBorder("Filter settings"));
        panel.add(Box.createRigidArea(new Dimension(5, this.cmbPrimFilter.getHeight())));
        panel.add(this.cmbPrimFilter);
        panel.add(Box.createRigidArea(new Dimension(10, this.cmbPrimFilter.getHeight())));
        panel.add(this.txtPrimFilter);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    private JPanel getMainPanel() {
        this.txtRegularExpression = new JTextArea(10, 40);
        JLabel lblRegularExpression = new JLabel("Specify regular expression pattern here");
        lblRegularExpression.setFont(this.txtRegularExpression.getFont());
        lblRegularExpression.setForeground(this.txtRegularExpression.getForeground());
        this.txtTestString = new JTextArea(10, 40);
        JLabel lblTestString = new JLabel("Enter test text here (optional, use 'Test' button to perform test)");
        lblTestString.setFont(this.txtTestString.getFont());
        lblTestString.setForeground(this.txtTestString.getForeground());
        this.txtRegularExpression.setMaximumSize(this.txtRegularExpression.getPreferredSize());
        lblRegularExpression.setMaximumSize(lblRegularExpression.getPreferredSize());
        this.txtTestString.setMaximumSize(this.txtTestString.getPreferredSize());
        lblTestString.setMaximumSize(lblTestString.getPreferredSize());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder("Regular Expression"));
        JPanel jpanRegularExpression = new JPanel();
        JPanel jpanRegularExpressionLabel = new JPanel();
        jpanRegularExpression.add(this.txtRegularExpression);
        panel.add(Box.createRigidArea(new Dimension(this.txtRegularExpression.getWidth(), 15)));
        jpanRegularExpressionLabel.add(lblRegularExpression);
        JPanel jpanTestString = new JPanel();
        JPanel jpanTestStringLabel = new JPanel();
        jpanTestString.add(this.txtTestString);
        panel.add(Box.createRigidArea(new Dimension(this.txtTestString.getWidth(), 15)));
        jpanTestStringLabel.add(lblTestString);
        panel.add(jpanRegularExpressionLabel);
        panel.add(new JScrollPane(jpanRegularExpression, 20, 30));
        panel.add(jpanTestStringLabel);
        panel.add(new JScrollPane(jpanTestString, 20, 30));
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    private JPanel getOptionPanel() {
        this.btnTest = new JButton("Test");
        this.btnTest.setMnemonic(84);
        this.btnTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RegularExpressionFilterDialog.this.testPressed();
            }
        });
        this.btnOK = new JButton("OK");
        this.btnOK.setMnemonic(79);
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RegularExpressionFilterDialog.this.okPressed();
            }
        });
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setMnemonic(67);
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RegularExpressionFilterDialog.this.close();
            }
        });
        this.btnOK.setMaximumSize(this.btnOK.getPreferredSize());
        this.btnCancel.setMaximumSize(this.btnCancel.getPreferredSize());
        JPanel jpanButtons = new JPanel();
        jpanButtons.setLayout(new BoxLayout(jpanButtons, 0));
        jpanButtons.add(Box.createRigidArea(new Dimension(15, this.btnCancel.getHeight())));
        jpanButtons.add(this.btnTest);
        jpanButtons.add(Box.createHorizontalGlue());
        jpanButtons.add(this.btnOK);
        jpanButtons.add(this.btnCancel);
        jpanButtons.add(Box.createRigidArea(new Dimension(15, this.btnCancel.getHeight())));
        return jpanButtons;
    }

    private void loadFilters() {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("filters.properties");
            Properties p = null;
            if (is != null) {
                p = new Properties();
                p.load(is);
                is.close();
            }
            iFilters = new HashMap();
            if (p != null) {
                Enumeration<Object> e = p.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = p.getProperty(key).trim();
                    StringTokenizer lst = new StringTokenizer(value, ",");
                    String className = lst.nextToken().trim();
                    String db_key = lst.nextToken().trim();
                    HashMap<String, String> addTo = null;
                    Object tempObject = iFilters.get(db_key.toUpperCase());
                    addTo = tempObject == null ? new HashMap<String, String>() : (HashMap<String, String>)tempObject;
                    addTo.put(db_key.toUpperCase() + " " + key + " filter", className);
                    iFilters.put(db_key.toUpperCase(), addTo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void okPressed() {
        Runnable pt = this.processInput();
        if (pt != null) {
            Thread t = new Thread(pt);
            t.start();
            this.close();
        }
    }

    private void testPressed() {
        Pattern p = this.processPattern();
        if (p != null) {
            String testString = this.txtTestString.getText().trim();
            if (testString.equals("")) {
                JOptionPane.showMessageDialog(this, "You specified an empty test text!", "No test text specified!", 0);
            } else {
                Matcher matcher = p.matcher(testString);
                if (matcher.find()) {
                    JOptionPane.showMessageDialog(this, "Your regular expression matched the test text.", "Test text matches expression", 1);
                } else {
                    JOptionPane.showMessageDialog(this, "Your regular expression did not match the test text!", "Test text does not match expression!", 0);
                }
            }
        }
    }

    private Pattern processPattern() {
        Pattern result = null;
        String regExp = this.txtRegularExpression.getText().trim();
        if (regExp.equals("")) {
            JOptionPane.showMessageDialog(this, "You need to specify a regular expression pattern!", "No regular expression pattern specified!", 0);
        } else {
            try {
                result = Pattern.compile(regExp);
            }
            catch (PatternSyntaxException pse) {
                JOptionPane.showMessageDialog(this, new String[]{"The regular expression pattern could not be parsed.", "Error was:", pse.getMessage()}, "Regular expression pattern error!", 0);
            }
        }
        return result;
    }

    private Runnable processInput() {
        File file;
        ProcessThread pt = null;
        Filter filter = null;
        boolean type = false;
        if (!((String)this.cmbPrimFilter.getSelectedItem()).equalsIgnoreCase("NONE")) {
            String filterName = (String)this.cmbPrimFilter.getSelectedItem();
            HashMap tempHM = (HashMap)iFilters.get(this.iDBType.toUpperCase());
            String filterClass = (String)tempHM.get(filterName);
            Class<?> c = null;
            try {
                c = Class.forName(filterClass);
            }
            catch (ClassNotFoundException cnfe) {
                JOptionPane.showMessageDialog(this, "The class for the " + filterName + " cannot be found (" + filterClass + ")!", "No filter available!", 0);
                return null;
            }
            Constructor<?> defaultConst = null;
            Constructor<?> constructor = null;
            try {
                defaultConst = c.getConstructor(new Class[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                constructor = c.getConstructor("".getClass());
            }
            catch (Exception e) {
                // empty catch block
            }
            String filterString = this.txtPrimFilter.getText().trim();
            if (defaultConst == null && filterString == null || filterString.equals("")) {
                JOptionPane.showMessageDialog(this, "You need to specify a filter string for use with the " + filterName + "!", "No filter string specified!", 0);
                return null;
            }
            if (filterString != null) {
                if (filterString.startsWith("!")) {
                    Constructor<?> dual = null;
                    try {
                        dual = c.getConstructor("".getClass(), Boolean.TYPE);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (dual == null) {
                        JOptionPane.showMessageDialog(this, "Your request for an inverted version of the " + filterName + " cannot be processed, since this Filter does not allow inversion!", "No inverse filter available!", 0);
                        return null;
                    }
                    try {
                        filter = (Filter)dual.newInstance(filterString.substring(1), new Boolean(true));
                    }
                    catch (Exception ie) {
                        JOptionPane.showMessageDialog(this, new String[]{"Could not create instance of " + filterName + " with a string and boolean argument!", ie.getMessage(), "\n"}, "Unable to create filter!", 0);
                        return null;
                    }
                }
                if (constructor == null) {
                    JOptionPane.showMessageDialog(this, "Your request for a configurable " + filterName + " cannot be processed, since this Filter does not allow specification of a filter string!", "No configurable filter available!", 0);
                    return null;
                }
                try {
                    filter = (Filter)constructor.newInstance(filterString);
                }
                catch (Exception ie) {
                    JOptionPane.showMessageDialog(this, new String[]{"Could not create instance of " + filterName + " with a String argument!", ie.getMessage(), "\n"}, "Unable to create filter!", 0);
                    return null;
                }
            }
            if (defaultConst != null) {
                try {
                    filter = (Filter)defaultConst.newInstance(new Object[0]);
                }
                catch (Exception ie) {
                    JOptionPane.showMessageDialog(this, new String[]{"Could not create instance of " + filterName + " without arguments!", ie.getMessage(), "\n"}, "Unable to create filter!", 0);
                    return null;
                }
            } else {
                filter = null;
            }
        } else {
            filter = null;
        }
        Pattern pattern = this.processPattern();
        if (pattern != null && (file = this.getProcessOutputFile()) != null) {
            ProteinSequenceRegExpFilter regExpFilter = new ProteinSequenceRegExpFilter(pattern);
            pt = ProcessThread.getSubsetTask(this.iLoader, file, this.iParent, filter, null, false, -1.0, -1.0, regExpFilter);
        }
        return pt;
    }

    private File getProcessOutputFile() {
        File file = null;
        JFileChooser jfc = new JFileChooser("/");
        jfc.setDialogType(1);
        jfc.setDialogTitle("Output generated DB to...");
        jfc.setApproveButtonToolTipText("Save generated DB to this file.");
        int returnVal = jfc.showSaveDialog(this);
        if (returnVal == 0) {
            file = new File(jfc.getSelectedFile().getAbsoluteFile().toString());
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this.iParent, "The specified file could not be created! (" + ioe.getMessage() + ")", "Error creating output file!", 0);
                    file = null;
                }
            }
        } else {
            file = null;
        }
        return file;
    }
}

