/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui.components;

import com.compomics.dbtoolkit.gui.workerthreads.FASTAOutputThread;
import com.compomics.dbtoolkit.gui.workerthreads.ProcessThread;
import com.compomics.dbtoolkit.io.QueryParser;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.dbtoolkit.io.interfaces.ProteinFilter;
import com.compomics.util.io.MascotEnzymeReader;
import com.compomics.util.protein.Enzyme;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ProcessDialog
extends JDialog {
    private JFrame iParent = null;
    private JComboBox cmbPrimFilter = null;
    private JTextField txtPrimFilter = null;
    private JCheckBox chkMassLimits = null;
    private JCheckBox chkDigest = null;
    private JTextField txtMinMass = null;
    private JTextField txtMaxMass = null;
    private JComboBox cmbEnzymes = null;
    private JTextField txtEnzymeFile = null;
    private JButton btnChangeEnzymeFile = null;
    private JTextField txtMiscleavage = null;
    private JTextField txtCleave = null;
    private JTextField txtRestrict = null;
    private JTextField txtPosition = null;
    private JRadioButton radRagging = null;
    private JRadioButton radSubset = null;
    private JRadioButton radDigestOnly = null;
    private JRadioButton radFilterOnly = null;
    private JComboBox cmbTerminus = null;
    private JTextField txtTruncate = null;
    private JCheckBox chkTruncate = null;
    private JLabel lblTruncate = null;
    private JTextArea txtQuery = null;
    private JLabel lblQuery = null;
    private JButton btnOK = null;
    private JButton btnCancel = null;
    private DBLoader iLoader = null;
    private String iDBType = null;
    private MascotEnzymeReader iReader = null;
    private static HashMap iFilters = null;
    private static final String DEFAULT_ENZYMES_FILE = "enzymes.txt";

    public ProcessDialog(JFrame aParent, String aTitle, DBLoader aLoader, String aDBType) {
        super(aParent, aTitle, true);
        this.iParent = aParent;
        this.iLoader = aLoader;
        this.iDBType = aDBType;
        if (iFilters == null) {
            this.loadFilters();
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                ProcessDialog.this.close();
            }
        });
        this.constructScreen();
    }

    private void constructScreen() {
        JPanel top = this.getPrimaryFilterPanel();
        JPanel middle = this.getMainPanel();
        JPanel bottom = this.getOptionPanel();
        this.getContentPane().add((Component)top, "North");
        this.getContentPane().add((Component)bottom, "South");
        this.getContentPane().add((Component)middle, "Center");
        this.pack();
    }

    private JPanel getPrimaryFilterPanel() {
        this.txtPrimFilter = new JTextField(20);
        this.txtPrimFilter.setEnabled(false);
        Object[] resultString = null;
        Object loTemp = iFilters.get(this.iDBType.toUpperCase());
        if (loTemp != null) {
            HashMap allFilters = (HashMap)loTemp;
            Set s = allFilters.keySet();
            resultString = new String[s.size() + 1];
            s.toArray(resultString);
            resultString[resultString.length - 1] = "None";
        } else {
            resultString = new String[]{"None"};
        }
        Arrays.sort(resultString);
        this.cmbPrimFilter = new JComboBox<Object>(resultString);
        this.cmbPrimFilter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && ((String)e.getItem()).equalsIgnoreCase("None")) {
                    ProcessDialog.this.txtPrimFilter.setEnabled(false);
                } else {
                    ProcessDialog.this.txtPrimFilter.setEnabled(true);
                }
            }
        });
        this.cmbPrimFilter.setSelectedItem("None");
        this.cmbPrimFilter.setMaximumSize(this.cmbPrimFilter.getPreferredSize());
        this.txtPrimFilter.setMaximumSize(this.txtPrimFilter.getPreferredSize());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createTitledBorder("Filter settings"));
        panel.add(Box.createRigidArea(new Dimension(5, this.cmbPrimFilter.getHeight())));
        panel.add(this.cmbPrimFilter);
        panel.add(Box.createRigidArea(new Dimension(10, this.cmbPrimFilter.getHeight())));
        panel.add(this.txtPrimFilter);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    private JPanel getMainPanel() {
        this.radRagging = new JRadioButton("Ragging", true);
        this.radRagging.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessDialog.this.cmbTerminus.setEnabled(true);
                ProcessDialog.this.chkTruncate.setEnabled(true);
                ProcessDialog.this.txtTruncate.setEnabled(true);
                ProcessDialog.this.lblTruncate.setEnabled(true);
                ProcessDialog.this.txtMinMass.setEnabled(true);
                ProcessDialog.this.txtMaxMass.setEnabled(true);
                ProcessDialog.this.chkMassLimits.setSelected(true);
                ProcessDialog.this.txtQuery.setEnabled(false);
                ProcessDialog.this.lblQuery.setEnabled(false);
                ProcessDialog.this.chkDigest.setEnabled(true);
                ProcessDialog.this.chkDigest.setSelected(true);
            }
        });
        this.radSubset = new JRadioButton("Sequence-based Subset", false);
        this.radSubset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessDialog.this.cmbTerminus.setEnabled(false);
                ProcessDialog.this.chkTruncate.setEnabled(false);
                ProcessDialog.this.txtTruncate.setEnabled(false);
                ProcessDialog.this.lblTruncate.setEnabled(false);
                ProcessDialog.this.txtMinMass.setEnabled(true);
                ProcessDialog.this.txtMaxMass.setEnabled(true);
                ProcessDialog.this.chkMassLimits.setSelected(true);
                ProcessDialog.this.txtQuery.setEnabled(true);
                ProcessDialog.this.lblQuery.setEnabled(true);
                ProcessDialog.this.chkDigest.setEnabled(true);
                ProcessDialog.this.chkDigest.setSelected(true);
            }
        });
        this.radDigestOnly = new JRadioButton("Enzymatic digest only", false);
        this.radDigestOnly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessDialog.this.cmbTerminus.setEnabled(false);
                ProcessDialog.this.chkTruncate.setEnabled(false);
                ProcessDialog.this.txtTruncate.setEnabled(false);
                ProcessDialog.this.lblTruncate.setEnabled(false);
                ProcessDialog.this.txtQuery.setEnabled(false);
                ProcessDialog.this.lblQuery.setEnabled(false);
                ProcessDialog.this.txtMinMass.setEnabled(true);
                ProcessDialog.this.txtMaxMass.setEnabled(true);
                ProcessDialog.this.chkMassLimits.setSelected(true);
                ProcessDialog.this.chkDigest.setSelected(true);
                ProcessDialog.this.chkDigest.setEnabled(false);
            }
        });
        this.radFilterOnly = new JRadioButton("Filter database only", false);
        this.radFilterOnly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessDialog.this.cmbTerminus.setEnabled(false);
                ProcessDialog.this.chkTruncate.setEnabled(false);
                ProcessDialog.this.txtTruncate.setEnabled(false);
                ProcessDialog.this.lblTruncate.setEnabled(false);
                ProcessDialog.this.txtQuery.setEnabled(false);
                ProcessDialog.this.lblQuery.setEnabled(false);
                ProcessDialog.this.txtMinMass.setEnabled(false);
                ProcessDialog.this.txtMaxMass.setEnabled(false);
                ProcessDialog.this.chkMassLimits.setSelected(false);
                ProcessDialog.this.chkDigest.setSelected(false);
                ProcessDialog.this.chkDigest.setEnabled(false);
            }
        });
        ButtonGroup bp = new ButtonGroup();
        bp.add(this.radRagging);
        bp.add(this.radSubset);
        bp.add(this.radDigestOnly);
        bp.add(this.radFilterOnly);
        this.cmbTerminus = new JComboBox<String>(new String[]{"N-terminal", "C-terminal"});
        this.cmbTerminus.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    ProcessDialog.this.lblTruncate.setText(ProcessDialog.this.cmbTerminus.getSelectedItem() + " residus before ragging.");
                }
            }
        });
        this.chkTruncate = new JCheckBox("Truncate entries to", true);
        this.chkTruncate.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (ProcessDialog.this.chkTruncate.isSelected()) {
                    ProcessDialog.this.txtTruncate.setEnabled(true);
                } else {
                    ProcessDialog.this.txtTruncate.setEnabled(false);
                }
            }
        });
        this.txtTruncate = new JTextField("100", 5);
        this.lblTruncate = new JLabel("N-terminal residus before ragging.");
        this.lblTruncate.setFont(this.chkTruncate.getFont());
        this.lblTruncate.setForeground(this.chkTruncate.getForeground());
        this.txtQuery = new JTextArea(10, 40);
        this.lblQuery = new JLabel("Enter restriction query here");
        this.lblQuery.setFont(this.chkTruncate.getFont());
        this.lblQuery.setForeground(this.chkTruncate.getForeground());
        this.txtQuery.setEnabled(false);
        this.lblQuery.setEnabled(false);
        this.radRagging.setMaximumSize(this.radRagging.getPreferredSize());
        this.radSubset.setMaximumSize(this.radSubset.getPreferredSize());
        this.cmbTerminus.setMaximumSize(this.cmbTerminus.getPreferredSize());
        this.chkTruncate.setMaximumSize(this.chkTruncate.getPreferredSize());
        this.txtTruncate.setMaximumSize(this.txtTruncate.getPreferredSize());
        this.txtQuery.setMaximumSize(this.txtQuery.getPreferredSize());
        this.lblQuery.setMaximumSize(this.lblQuery.getPreferredSize());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder("Processing style"));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        JPanel topRadioPanel = new JPanel();
        topRadioPanel.setLayout(new BoxLayout(topRadioPanel, 1));
        JPanel bottomRadioPanel = new JPanel();
        bottomRadioPanel.setLayout(new BoxLayout(bottomRadioPanel, 1));
        JPanel extraRadioPanel = new JPanel();
        extraRadioPanel.setLayout(new BoxLayout(extraRadioPanel, 0));
        JPanel extraRadioPanel2 = new JPanel();
        extraRadioPanel2.setLayout(new BoxLayout(extraRadioPanel2, 0));
        JPanel jpanRagging = new JPanel();
        jpanRagging.setLayout(new BoxLayout(jpanRagging, 1));
        JPanel jpanWrapRagging = new JPanel();
        jpanWrapRagging.setLayout(new BoxLayout(jpanWrapRagging, 1));
        JPanel jpanSubset = new JPanel();
        jpanSubset.setLayout(new BoxLayout(jpanSubset, 1));
        JPanel jpanWrapSubset = new JPanel();
        jpanWrapSubset.setLayout(new BoxLayout(jpanWrapSubset, 1));
        JPanel jpanTerminus = new JPanel();
        jpanTerminus.setLayout(new BoxLayout(jpanTerminus, 0));
        JPanel jpanTruncate = new JPanel();
        jpanTruncate.setLayout(new BoxLayout(jpanTruncate, 0));
        JPanel jpanQuery = new JPanel();
        JPanel jpanQueryLabel = new JPanel();
        topRadioPanel.add(Box.createRigidArea(new Dimension(5, this.radRagging.getHeight())));
        topRadioPanel.add(this.radRagging);
        topRadioPanel.add(Box.createVerticalGlue());
        jpanTerminus.add(this.cmbTerminus);
        jpanTerminus.add(Box.createHorizontalGlue());
        jpanTruncate.add(this.chkTruncate);
        jpanTruncate.add(this.txtTruncate);
        jpanTruncate.add(Box.createRigidArea(new Dimension(10, this.chkTruncate.getHeight())));
        jpanTruncate.add(this.lblTruncate);
        jpanTruncate.add(Box.createHorizontalGlue());
        jpanRagging.add(Box.createRigidArea(new Dimension(jpanTerminus.getWidth(), 15)));
        jpanRagging.add(jpanTerminus);
        jpanRagging.add(jpanTruncate);
        jpanRagging.add(Box.createVerticalGlue());
        jpanWrapRagging.add(jpanRagging);
        jpanWrapRagging.add(Box.createVerticalGlue());
        bottomRadioPanel.add(Box.createRigidArea(new Dimension(5, this.radSubset.getHeight())));
        bottomRadioPanel.add(this.radSubset);
        bottomRadioPanel.add(Box.createVerticalGlue());
        topPanel.add(topRadioPanel);
        topPanel.add(Box.createRigidArea(new Dimension(120, topRadioPanel.getHeight())));
        topPanel.add(jpanRagging);
        topPanel.add(Box.createHorizontalGlue());
        jpanQuery.add(this.txtQuery);
        jpanSubset.add(Box.createRigidArea(new Dimension(this.txtQuery.getWidth(), 15)));
        jpanQueryLabel.add(this.lblQuery);
        jpanSubset.add(jpanQueryLabel);
        jpanSubset.add(new JScrollPane(jpanQuery, 20, 30));
        jpanSubset.add(Box.createVerticalGlue());
        jpanWrapSubset.add(jpanSubset);
        jpanWrapSubset.add(Box.createVerticalGlue());
        extraRadioPanel.add(this.radDigestOnly);
        extraRadioPanel.add(Box.createHorizontalGlue());
        extraRadioPanel2.add(this.radFilterOnly);
        extraRadioPanel2.add(Box.createHorizontalGlue());
        bottomPanel.add(bottomRadioPanel);
        bottomPanel.add(Box.createRigidArea(new Dimension(this.radSubset.getWidth() + 20, bottomRadioPanel.getHeight())));
        bottomPanel.add(jpanSubset);
        bottomPanel.add(Box.createHorizontalGlue());
        panel.add(topPanel);
        panel.add(Box.createRigidArea(new Dimension(bottomPanel.getWidth(), 25)));
        panel.add(bottomPanel);
        panel.add(Box.createRigidArea(new Dimension(bottomPanel.getWidth(), 25)));
        panel.add(extraRadioPanel);
        panel.add(Box.createRigidArea(new Dimension(bottomPanel.getWidth(), 25)));
        panel.add(extraRadioPanel2);
        return panel;
    }

    private JPanel getOptionPanel() {
        this.chkDigest = new JCheckBox("Enzymatic Digest", true);
        this.chkDigest.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                boolean lState = false;
                if (ProcessDialog.this.chkDigest.isSelected()) {
                    lState = true;
                }
                ProcessDialog.this.txtMiscleavage.setEnabled(lState);
                ProcessDialog.this.btnChangeEnzymeFile.setEnabled(lState);
                ProcessDialog.this.cmbEnzymes.setEnabled(lState);
            }
        });
        this.txtMiscleavage = new JTextField("1", 3);
        this.txtEnzymeFile = new JTextField(DEFAULT_ENZYMES_FILE, 15);
        this.txtEnzymeFile.setEnabled(false);
        this.btnChangeEnzymeFile = new JButton("...");
        this.btnChangeEnzymeFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser jfc = new JFileChooser("/");
                int returnVal = jfc.showOpenDialog((JComponent)e.getSource());
                if (returnVal == 0) {
                    ProcessDialog.this.txtEnzymeFile.setText(jfc.getSelectedFile().getAbsoluteFile().toString());
                    ProcessDialog.this.fillEnzymeList();
                }
            }
        });
        this.txtCleave = new JTextField("<none>", 8);
        this.txtCleave.setEnabled(false);
        this.txtRestrict = new JTextField("<none>", 8);
        this.txtRestrict.setEnabled(false);
        this.txtPosition = new JTextField("<none>", 8);
        this.txtPosition.setEnabled(false);
        this.fillEnzymeList();
        this.cmbEnzymes.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String selected = (String)e.getItem();
                    ProcessDialog.this.stateChangedEnzyme(selected);
                }
            }
        });
        this.chkMassLimits = new JCheckBox("Use mass limits", true);
        this.txtMinMass = new JTextField("600", 6);
        this.txtMaxMass = new JTextField("4000", 6);
        this.chkMassLimits.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (ProcessDialog.this.chkMassLimits.isSelected()) {
                    ProcessDialog.this.txtMinMass.setEnabled(true);
                    ProcessDialog.this.txtMaxMass.setEnabled(true);
                } else {
                    ProcessDialog.this.txtMinMass.setEnabled(false);
                    ProcessDialog.this.txtMaxMass.setEnabled(false);
                }
            }
        });
        this.btnOK = new JButton("OK");
        this.btnOK.setMnemonic(79);
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessDialog.this.okPressed();
            }
        });
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setMnemonic(67);
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProcessDialog.this.close();
            }
        });
        this.txtMiscleavage.setMaximumSize(this.txtMiscleavage.getPreferredSize());
        this.txtEnzymeFile.setMaximumSize(this.txtEnzymeFile.getPreferredSize());
        this.btnChangeEnzymeFile.setMaximumSize(this.btnChangeEnzymeFile.getPreferredSize());
        this.txtMinMass.setMaximumSize(this.txtMinMass.getPreferredSize());
        this.txtMaxMass.setMaximumSize(this.txtMaxMass.getPreferredSize());
        this.txtCleave.setMaximumSize(this.txtCleave.getPreferredSize());
        this.txtRestrict.setMaximumSize(this.txtRestrict.getPreferredSize());
        this.txtPosition.setMaximumSize(this.txtPosition.getPreferredSize());
        this.btnOK.setMaximumSize(this.btnOK.getPreferredSize());
        this.btnCancel.setMaximumSize(this.btnCancel.getPreferredSize());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        JPanel jpanEnzymeDigest = new JPanel();
        jpanEnzymeDigest.setLayout(new BoxLayout(jpanEnzymeDigest, 1));
        jpanEnzymeDigest.setBorder(BorderFactory.createTitledBorder("Enzymatic digestion"));
        JPanel jpanMassConstraints = new JPanel();
        jpanMassConstraints.setLayout(new BoxLayout(jpanMassConstraints, 0));
        jpanMassConstraints.setBorder(BorderFactory.createTitledBorder("Mass limits"));
        JPanel jpanButtons = new JPanel();
        jpanButtons.setLayout(new BoxLayout(jpanButtons, 0));
        JPanel jpanTopPart = new JPanel();
        jpanTopPart.setLayout(new BoxLayout(jpanTopPart, 0));
        JPanel jpanPart1 = new JPanel();
        jpanPart1.setLayout(new BoxLayout(jpanPart1, 1));
        JPanel jpanPart2 = new JPanel();
        jpanPart2.setLayout(new BoxLayout(jpanPart2, 1));
        JPanel jpanDigest = new JPanel();
        jpanDigest.setLayout(new BoxLayout(jpanDigest, 0));
        jpanDigest.add(Box.createRigidArea(new Dimension(5, this.chkDigest.getHeight())));
        jpanDigest.add(this.chkDigest);
        jpanDigest.add(Box.createHorizontalGlue());
        JPanel jpanCleave = new JPanel();
        jpanCleave.setLayout(new BoxLayout(jpanCleave, 0));
        jpanCleave.add(Box.createHorizontalGlue());
        jpanCleave.add(new JLabel("Cleave"));
        jpanCleave.add(Box.createRigidArea(new Dimension(10, this.chkDigest.getHeight())));
        jpanCleave.add(this.txtCleave);
        JPanel jpanEnzymes = new JPanel();
        jpanEnzymes.setLayout(new BoxLayout(jpanEnzymes, 0));
        jpanEnzymes.add(Box.createRigidArea(new Dimension(20, this.cmbEnzymes.getHeight())));
        jpanEnzymes.add(new JLabel("Available Enzymes"));
        jpanEnzymes.add(Box.createRigidArea(new Dimension(15, this.cmbEnzymes.getHeight())));
        jpanEnzymes.add(this.cmbEnzymes);
        jpanEnzymes.add(Box.createHorizontalGlue());
        JPanel jpanRestrict = new JPanel();
        jpanRestrict.setLayout(new BoxLayout(jpanRestrict, 0));
        jpanRestrict.add(Box.createHorizontalGlue());
        jpanRestrict.add(new JLabel("Restrict"));
        jpanRestrict.add(Box.createRigidArea(new Dimension(10, this.cmbEnzymes.getHeight())));
        jpanRestrict.add(this.txtRestrict);
        JPanel jpanMiscleavages = new JPanel();
        jpanMiscleavages.setLayout(new BoxLayout(jpanMiscleavages, 0));
        jpanMiscleavages.add(Box.createRigidArea(new Dimension(20, this.txtMiscleavage.getHeight())));
        jpanMiscleavages.add(new JLabel("Number of miscleavages"));
        jpanMiscleavages.add(Box.createRigidArea(new Dimension(15, this.txtMiscleavage.getHeight())));
        jpanMiscleavages.add(this.txtMiscleavage);
        jpanMiscleavages.add(Box.createHorizontalGlue());
        JPanel jpanPosition = new JPanel();
        jpanPosition.setLayout(new BoxLayout(jpanPosition, 0));
        jpanPosition.add(Box.createHorizontalGlue());
        jpanPosition.add(new JLabel("Position"));
        jpanPosition.add(Box.createRigidArea(new Dimension(10, this.txtMiscleavage.getHeight())));
        jpanPosition.add(this.txtPosition);
        JPanel jpanEnzymeFile = new JPanel();
        jpanEnzymeFile.setLayout(new BoxLayout(jpanEnzymeFile, 0));
        jpanEnzymeFile.add(Box.createRigidArea(new Dimension(20, this.txtEnzymeFile.getHeight())));
        jpanEnzymeFile.add(new JLabel("Enzyme definition file"));
        jpanEnzymeFile.add(Box.createRigidArea(new Dimension(15, this.txtEnzymeFile.getHeight())));
        jpanEnzymeFile.add(this.txtEnzymeFile);
        jpanEnzymeFile.add(Box.createRigidArea(new Dimension(15, this.txtEnzymeFile.getHeight())));
        jpanEnzymeFile.add(this.btnChangeEnzymeFile);
        jpanEnzymeFile.add(Box.createHorizontalGlue());
        jpanPart1.add(jpanDigest);
        jpanPart1.add(Box.createRigidArea(new Dimension(jpanEnzymeDigest.getWidth(), 5)));
        jpanPart1.add(jpanEnzymes);
        jpanPart1.add(Box.createRigidArea(new Dimension(jpanEnzymeDigest.getWidth(), 5)));
        jpanPart1.add(jpanMiscleavages);
        jpanPart1.setMaximumSize(jpanPart1.getPreferredSize());
        jpanPart2.add(jpanCleave);
        jpanPart2.add(Box.createRigidArea(new Dimension(jpanEnzymeDigest.getWidth(), 5)));
        jpanPart2.add(jpanRestrict);
        jpanPart2.add(Box.createRigidArea(new Dimension(jpanEnzymeDigest.getWidth(), 5)));
        jpanPart2.add(jpanPosition);
        jpanPart2.setMaximumSize(jpanPart2.getPreferredSize());
        jpanTopPart.add(jpanPart1);
        jpanTopPart.add(Box.createRigidArea(new Dimension(20, jpanPart1.getHeight())));
        jpanTopPart.add(jpanPart2);
        jpanTopPart.add(Box.createHorizontalGlue());
        jpanEnzymeDigest.add(jpanTopPart);
        jpanEnzymeDigest.add(Box.createRigidArea(new Dimension(jpanEnzymeDigest.getWidth(), 5)));
        jpanEnzymeDigest.add(jpanEnzymeFile);
        jpanMassConstraints.add(Box.createRigidArea(new Dimension(5, this.chkMassLimits.getHeight())));
        jpanMassConstraints.add(this.chkMassLimits);
        jpanMassConstraints.add(Box.createRigidArea(new Dimension(20, this.chkMassLimits.getHeight())));
        jpanMassConstraints.add(new JLabel(" From "));
        jpanMassConstraints.add(Box.createRigidArea(new Dimension(5, this.chkMassLimits.getHeight())));
        jpanMassConstraints.add(this.txtMinMass);
        jpanMassConstraints.add(Box.createRigidArea(new Dimension(5, this.chkMassLimits.getHeight())));
        jpanMassConstraints.add(new JLabel("Da  to "));
        jpanMassConstraints.add(Box.createRigidArea(new Dimension(5, this.chkMassLimits.getHeight())));
        jpanMassConstraints.add(this.txtMaxMass);
        jpanMassConstraints.add(Box.createRigidArea(new Dimension(5, this.chkMassLimits.getHeight())));
        jpanMassConstraints.add(new JLabel("Da"));
        jpanMassConstraints.add(Box.createHorizontalGlue());
        jpanButtons.add(Box.createHorizontalGlue());
        jpanButtons.add(this.btnOK);
        jpanButtons.add(this.btnCancel);
        jpanButtons.add(Box.createRigidArea(new Dimension(15, this.btnCancel.getHeight())));
        panel.add(Box.createRigidArea(new Dimension(panel.getWidth(), 5)));
        panel.add(jpanEnzymeDigest);
        panel.add(Box.createRigidArea(new Dimension(panel.getWidth(), 10)));
        panel.add(jpanMassConstraints);
        panel.add(Box.createRigidArea(new Dimension(panel.getWidth(), 25)));
        panel.add(jpanButtons);
        panel.add(Box.createRigidArea(new Dimension(panel.getWidth(), 10)));
        return panel;
    }

    private void fillEnzymeList() {
        Object[] contents = new String[]{"None"};
        try {
            String file = this.txtEnzymeFile.getText();
            InputStream inEnzymeStream = this.getClass().getClassLoader().getResourceAsStream(file);
            if (inEnzymeStream == null) {
                inEnzymeStream = ClassLoader.getSystemResourceAsStream(this.txtEnzymeFile.getText());
            }
            if (inEnzymeStream == null) {
                File enzymeFile = new File(this.txtEnzymeFile.getText());
                inEnzymeStream = new FileInputStream(enzymeFile);
            }
            this.iReader = new MascotEnzymeReader(inEnzymeStream);
            String[] names = this.iReader.getEnzymeNames();
            if (names.length == 0) {
                JOptionPane.showMessageDialog(this, new String[]{"Unable to read Enzymes in the file '" + file + "'.", "Perhaps you selected the wrong file?", "\n"}, "Unable to read Enzymes!", 0);
            } else {
                if (this.cmbEnzymes != null) {
                    JOptionPane.showMessageDialog(this, new String[]{"Read " + names.length + " Enzymes in file '" + file + "'.", "\n"}, "Read " + names.length + " Enzymes!", -1);
                }
                contents = names;
            }
            Arrays.sort(contents);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (this.cmbEnzymes == null) {
            this.cmbEnzymes = new JComboBox<String>(contents);
        } else {
            this.cmbEnzymes.setModel(new DefaultComboBoxModel<String>(contents));
        }
        String item = (String)this.cmbEnzymes.getSelectedItem();
        this.stateChangedEnzyme(item);
        this.cmbEnzymes.setMaximumSize(this.cmbEnzymes.getPreferredSize());
    }

    private void stateChangedEnzyme(String aSelected) {
        if (aSelected.equalsIgnoreCase("None")) {
            this.txtCleave.setText("<none>");
            this.txtRestrict.setText("<none>");
            this.txtPosition.setText("<none>");
        } else {
            Enzyme enzyme = this.iReader.getEnzyme(aSelected);
            char[] temp = enzyme.getCleavage();
            if (temp != null) {
                this.txtCleave.setText(new String(temp));
            } else {
                this.txtCleave.setText("<none>");
            }
            temp = enzyme.getRestrict();
            if (temp != null) {
                this.txtRestrict.setText(new String(temp));
            } else {
                this.txtRestrict.setText("<none>");
            }
            this.txtPosition.setText(enzyme.getPosition() == 0 ? "C-Terminus" : "N-Terminus");
        }
    }

    private void loadFilters() {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("filters.properties");
            Properties p = null;
            if (is != null) {
                p = new Properties();
                p.load(is);
                is.close();
            }
            iFilters = new HashMap();
            if (p != null) {
                Enumeration<Object> e = p.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = p.getProperty(key).trim();
                    StringTokenizer lst = new StringTokenizer(value, ",");
                    String className = lst.nextToken().trim();
                    String db_key = lst.nextToken().trim();
                    HashMap<String, String> addTo = null;
                    Object tempObject = iFilters.get(db_key.toUpperCase());
                    addTo = tempObject == null ? new HashMap<String, String>() : (HashMap<String, String>)tempObject;
                    addTo.put(db_key.toUpperCase() + " " + key + " filter", className);
                    iFilters.put(db_key.toUpperCase(), addTo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void okPressed() {
        Runnable pt = this.processInput();
        if (pt != null) {
            Thread t = new Thread(pt);
            t.start();
            this.close();
        }
    }

    private Runnable processInput() {
        File file;
        Runnable pt = null;
        boolean massLimits = false;
        double minMass = 0.0;
        double maxMass = 0.0;
        Enzyme enzyme = null;
        Filter filter = null;
        boolean type = false;
        if (this.chkMassLimits.isSelected()) {
            massLimits = true;
            try {
                minMass = Double.parseDouble(this.txtMinMass.getText());
                maxMass = Double.parseDouble(this.txtMaxMass.getText());
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "The mass limits should be specified, and they should be correctly formatted (decimal) numbers!", "Error reading mass limits!", 0);
                return null;
            }
        } else {
            massLimits = false;
        }
        if (!((String)this.cmbPrimFilter.getSelectedItem()).equalsIgnoreCase("NONE")) {
            String filterName = (String)this.cmbPrimFilter.getSelectedItem();
            HashMap tempHM = (HashMap)iFilters.get(this.iDBType.toUpperCase());
            String filterClass = (String)tempHM.get(filterName);
            Class<?> c = null;
            try {
                c = Class.forName(filterClass);
            }
            catch (ClassNotFoundException cnfe) {
                JOptionPane.showMessageDialog(this, "The class for the " + filterName + " cannot be found (" + filterClass + ")!", "No filter available!", 0);
                return null;
            }
            Constructor<?> defaultConst = null;
            Constructor<?> constructor = null;
            try {
                defaultConst = c.getConstructor(new Class[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                constructor = c.getConstructor("".getClass());
            }
            catch (Exception e) {
                // empty catch block
            }
            String filterString = this.txtPrimFilter.getText().trim();
            if (defaultConst == null && filterString == null || filterString.equals("")) {
                JOptionPane.showMessageDialog(this, "You need to specify a filter string for use with the " + filterName + "!", "No filter string specified!", 0);
                return null;
            }
            if (filterString != null) {
                if (filterString.startsWith("!")) {
                    Constructor<?> dual = null;
                    try {
                        dual = c.getConstructor("".getClass(), Boolean.TYPE);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (dual == null) {
                        JOptionPane.showMessageDialog(this, "Your request for an inverted version of the " + filterName + " cannot be processed, since this Filter does not allow inversion!", "No inverse filter available!", 0);
                        return null;
                    }
                    try {
                        filter = (Filter)dual.newInstance(filterString.substring(1), new Boolean(true));
                    }
                    catch (Exception ie) {
                        JOptionPane.showMessageDialog(this, new String[]{"Could not create instance of " + filterName + " with a string and boolean argument!", ie.getMessage(), "\n"}, "Unable to create filter!", 0);
                        return null;
                    }
                }
                if (constructor == null) {
                    JOptionPane.showMessageDialog(this, "Your request for a configurable " + filterName + " cannot be processed, since this Filter does not allow specification of a filter string!", "No configurable filter available!", 0);
                    return null;
                }
                try {
                    filter = (Filter)constructor.newInstance(filterString);
                }
                catch (Exception ie) {
                    JOptionPane.showMessageDialog(this, new String[]{"Could not create instance of " + filterName + " with a String argument!", ie.getMessage(), "\n"}, "Unable to create filter!", 0);
                    return null;
                }
            }
            if (defaultConst != null) {
                try {
                    filter = (Filter)defaultConst.newInstance(new Object[0]);
                }
                catch (Exception ie) {
                    JOptionPane.showMessageDialog(this, new String[]{"Could not create instance of " + filterName + " without arguments!", ie.getMessage(), "\n"}, "Unable to create filter!", 0);
                    return null;
                }
            } else {
                filter = null;
            }
        } else {
            filter = null;
        }
        if (this.chkDigest.isSelected() && !((String)this.cmbEnzymes.getSelectedItem()).equalsIgnoreCase("NONE")) {
            enzyme = this.iReader.getEnzyme((String)this.cmbEnzymes.getSelectedItem());
            try {
                enzyme.setMiscleavages(Integer.parseInt(this.txtMiscleavage.getText()));
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "The number of allowed missed cleavages should be specified, and it should be a correctly formatted whole number!", "Error reading allowed missed cleavages!", 0);
                return null;
            }
        } else {
            enzyme = null;
        }
        if (this.radRagging.isSelected()) {
            boolean truncate = false;
            int truncateSize = 0;
            if (this.chkTruncate.isSelected()) {
                truncate = true;
                try {
                    truncateSize = Integer.parseInt(this.txtTruncate.getText());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(this, "The truncation size should be specified, and it should be a correctly formatted whole number!", "Error reading truncation size!", 0);
                    return null;
                }
            }
            int terminus = 0;
            String term = (String)this.cmbTerminus.getSelectedItem();
            if (term.startsWith("N")) {
                terminus = 0;
            } else if (term.startsWith("C")) {
                terminus = 1;
            }
            File file2 = this.getProcessOutputFile();
            if (file2 != null) {
                pt = ProcessThread.getRaggingTask(this.iLoader, file2, this.iParent, filter, enzyme, massLimits, minMass, maxMass, terminus, truncate, truncateSize);
            }
        } else if (this.radSubset.isSelected()) {
            String query = this.txtQuery.getText();
            if (query == null || query.trim().equals("")) {
                JOptionPane.showMessageDialog(this, "You need to specify a query, upon which a subset selection will be based!", "No query found!", 0);
                return null;
            }
            ProteinFilter protFilter = null;
            try {
                protFilter = new QueryParser().parseQuery(query);
            }
            catch (ParseException pe) {
                JOptionPane.showMessageDialog(this, new String[]{"Your query could not be parsed!", "\n", "Parser returned the following message:", pe.getMessage(), "\n"}, "Query could not be parsed!", 0);
                return null;
            }
            if (protFilter == null) {
                JOptionPane.showMessageDialog(this, new String[]{"Your query could not be parsed!", "\n", "Parser did not return a message.", "\n"}, "Query could not be parsed!", 0);
                return null;
            }
            File file3 = this.getProcessOutputFile();
            if (file3 != null) {
                pt = ProcessThread.getSubsetTask(this.iLoader, file3, this.iParent, filter, enzyme, massLimits, minMass, maxMass, protFilter);
            }
        } else if (this.radDigestOnly.isSelected()) {
            if (((String)this.cmbEnzymes.getSelectedItem()).equalsIgnoreCase("NONE")) {
                JOptionPane.showMessageDialog(this, "Your need to select an enzyme for the digest!", "No enzyme selected!", 0);
                return null;
            }
            file = this.getProcessOutputFile();
            if (file != null) {
                pt = ProcessThread.getSubsetTask(this.iLoader, file, this.iParent, filter, enzyme, massLimits, minMass, maxMass, (ProteinFilter)null);
            }
        } else if (this.radFilterOnly.isSelected() && (file = this.getProcessOutputFile()) != null) {
            pt = new FASTAOutputThread(this.iParent, this.iLoader, file, filter);
        }
        return pt;
    }

    private File getProcessOutputFile() {
        File file = null;
        JFileChooser jfc = new JFileChooser("/");
        jfc.setDialogType(1);
        jfc.setDialogTitle("Output generated DB to...");
        jfc.setApproveButtonToolTipText("Save generated DB to this file.");
        int returnVal = jfc.showSaveDialog(this);
        if (returnVal == 0) {
            file = new File(jfc.getSelectedFile().getAbsoluteFile().toString());
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this.iParent, "The specified file could not be created! (" + ioe.getMessage() + ")", "Error creating output file!", 0);
                    file = null;
                }
            }
        } else {
            file = null;
        }
        return file;
    }
}

