/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui.components;

import com.compomics.dbtoolkit.gui.workerthreads.PeptideMappingThread;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PeptideMappingDialog
extends JDialog {
    private JFrame iParent = null;
    private JComboBox cmbPrimFilter = null;
    private JTextField txtPrimFilter = null;
    private JTextArea txtPeptides = null;
    private JButton btnOK = null;
    private JButton btnCancel = null;
    private DBLoader iLoader = null;
    private String iDBType = null;
    private static HashMap iFilters = null;

    public PeptideMappingDialog(JFrame aParent, String aTitle, DBLoader aLoader, String aDBType) {
        super(aParent, aTitle, true);
        this.iParent = aParent;
        this.iLoader = aLoader;
        this.iDBType = aDBType;
        if (iFilters == null) {
            this.loadFilters();
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                PeptideMappingDialog.this.close();
            }
        });
        this.constructScreen();
        this.setResizable(false);
    }

    private void constructScreen() {
        JPanel top = this.getPrimaryFilterPanel();
        JPanel middle = this.getMainPanel();
        JPanel bottom = this.getOptionPanel();
        this.getContentPane().add((Component)top, "North");
        this.getContentPane().add((Component)bottom, "South");
        this.getContentPane().add((Component)middle, "Center");
        this.pack();
    }

    private JPanel getPrimaryFilterPanel() {
        this.txtPrimFilter = new JTextField(20);
        this.txtPrimFilter.setEnabled(false);
        Object[] resultString = null;
        Object loTemp = iFilters.get(this.iDBType.toUpperCase());
        if (loTemp != null) {
            HashMap allFilters = (HashMap)loTemp;
            Set s = allFilters.keySet();
            resultString = new String[s.size() + 1];
            s.toArray(resultString);
            resultString[resultString.length - 1] = "None";
        } else {
            resultString = new String[]{"None"};
        }
        Arrays.sort(resultString);
        this.cmbPrimFilter = new JComboBox<Object>(resultString);
        this.cmbPrimFilter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && ((String)e.getItem()).equalsIgnoreCase("None")) {
                    PeptideMappingDialog.this.txtPrimFilter.setEnabled(false);
                } else {
                    PeptideMappingDialog.this.txtPrimFilter.setEnabled(true);
                }
            }
        });
        this.cmbPrimFilter.setSelectedItem("None");
        this.cmbPrimFilter.setMaximumSize(this.cmbPrimFilter.getPreferredSize());
        this.txtPrimFilter.setMaximumSize(this.txtPrimFilter.getPreferredSize());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setBorder(BorderFactory.createTitledBorder("Filter settings"));
        panel.add(Box.createRigidArea(new Dimension(5, this.cmbPrimFilter.getHeight())));
        panel.add(this.cmbPrimFilter);
        panel.add(Box.createRigidArea(new Dimension(10, this.cmbPrimFilter.getHeight())));
        panel.add(this.txtPrimFilter);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    private JPanel getMainPanel() {
        this.txtPeptides = new JTextArea(10, 40);
        JLabel lblPeptides = new JLabel("Enter peptide list here");
        lblPeptides.setFont(this.txtPeptides.getFont());
        lblPeptides.setForeground(this.txtPeptides.getForeground());
        this.txtPeptides.setMaximumSize(this.txtPeptides.getPreferredSize());
        lblPeptides.setMaximumSize(lblPeptides.getPreferredSize());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder("Peptide list"));
        JPanel jpanPeptides = new JPanel();
        JPanel jpanPeptidesLabel = new JPanel();
        jpanPeptides.add(this.txtPeptides);
        panel.add(Box.createRigidArea(new Dimension(this.txtPeptides.getWidth(), 15)));
        jpanPeptidesLabel.add(lblPeptides);
        panel.add(jpanPeptidesLabel);
        panel.add(new JScrollPane(jpanPeptides, 20, 30));
        panel.add(Box.createVerticalGlue());
        return panel;
    }

    private JPanel getOptionPanel() {
        this.btnOK = new JButton("OK");
        this.btnOK.setMnemonic(79);
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PeptideMappingDialog.this.okPressed();
            }
        });
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setMnemonic(67);
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PeptideMappingDialog.this.close();
            }
        });
        this.btnOK.setMaximumSize(this.btnOK.getPreferredSize());
        this.btnCancel.setMaximumSize(this.btnCancel.getPreferredSize());
        JPanel jpanButtons = new JPanel();
        jpanButtons.setLayout(new BoxLayout(jpanButtons, 0));
        jpanButtons.add(Box.createHorizontalGlue());
        jpanButtons.add(this.btnOK);
        jpanButtons.add(this.btnCancel);
        jpanButtons.add(Box.createRigidArea(new Dimension(15, this.btnCancel.getHeight())));
        return jpanButtons;
    }

    private void loadFilters() {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("filters.properties");
            Properties p = null;
            if (is != null) {
                p = new Properties();
                p.load(is);
                is.close();
            }
            iFilters = new HashMap();
            if (p != null) {
                Enumeration<Object> e = p.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = p.getProperty(key).trim();
                    StringTokenizer lst = new StringTokenizer(value, ",");
                    String className = lst.nextToken().trim();
                    String db_key = lst.nextToken().trim();
                    HashMap<String, String> addTo = null;
                    Object tempObject = iFilters.get(db_key.toUpperCase());
                    addTo = tempObject == null ? new HashMap<String, String>() : (HashMap<String, String>)tempObject;
                    addTo.put(db_key.toUpperCase() + " " + key + " filter", className);
                    iFilters.put(db_key.toUpperCase(), addTo);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void okPressed() {
        Runnable pt = this.processInput();
        if (pt != null) {
            Thread t = new Thread(pt);
            t.start();
            this.close();
        }
    }

    private Runnable processInput() {
        File file;
        PeptideMappingThread pt = null;
        Filter filter = null;
        boolean type = false;
        if (!((String)this.cmbPrimFilter.getSelectedItem()).equalsIgnoreCase("NONE")) {
            String filterName = (String)this.cmbPrimFilter.getSelectedItem();
            HashMap tempHM = (HashMap)iFilters.get(this.iDBType.toUpperCase());
            String filterClass = (String)tempHM.get(filterName);
            Class<?> c = null;
            try {
                c = Class.forName(filterClass);
            }
            catch (ClassNotFoundException cnfe) {
                JOptionPane.showMessageDialog(this, "The class for the " + filterName + " cannot be found (" + filterClass + ")!", "No filter available!", 0);
                return null;
            }
            Constructor<?> defaultConst = null;
            Constructor<?> constructor = null;
            try {
                defaultConst = c.getConstructor(new Class[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                constructor = c.getConstructor("".getClass());
            }
            catch (Exception e) {
                // empty catch block
            }
            String filterString = this.txtPrimFilter.getText().trim();
            if (defaultConst == null && filterString == null || filterString.equals("")) {
                JOptionPane.showMessageDialog(this, "You need to specify a filter string for use with the " + filterName + "!", "No filter string specified!", 0);
                return null;
            }
            if (filterString != null) {
                if (filterString.startsWith("!")) {
                    Constructor<?> dual = null;
                    try {
                        dual = c.getConstructor("".getClass(), Boolean.TYPE);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (dual == null) {
                        JOptionPane.showMessageDialog(this, "Your request for an inverted version of the " + filterName + " cannot be processed, since this Filter does not allow inversion!", "No inverse filter available!", 0);
                        return null;
                    }
                    try {
                        filter = (Filter)dual.newInstance(filterString.substring(1), new Boolean(true));
                    }
                    catch (Exception ie) {
                        JOptionPane.showMessageDialog(this, new String[]{"Could not create instance of " + filterName + " with a string and boolean argument!", ie.getMessage(), "\n"}, "Unable to create filter!", 0);
                        return null;
                    }
                }
                if (constructor == null) {
                    JOptionPane.showMessageDialog(this, "Your request for a configurable " + filterName + " cannot be processed, since this Filter does not allow specification of a filter string!", "No configurable filter available!", 0);
                    return null;
                }
                try {
                    filter = (Filter)constructor.newInstance(filterString);
                }
                catch (Exception ie) {
                    JOptionPane.showMessageDialog(this, new String[]{"Could not create instance of " + filterName + " with a String argument!", ie.getMessage(), "\n"}, "Unable to create filter!", 0);
                    return null;
                }
            }
            if (defaultConst != null) {
                try {
                    filter = (Filter)defaultConst.newInstance(new Object[0]);
                }
                catch (Exception ie) {
                    JOptionPane.showMessageDialog(this, new String[]{"Could not create instance of " + filterName + " without arguments!", ie.getMessage(), "\n"}, "Unable to create filter!", 0);
                    return null;
                }
            } else {
                filter = null;
            }
        } else {
            filter = null;
        }
        String peptidesText = this.txtPeptides.getText();
        if (peptidesText == null || peptidesText.trim().equals("")) {
            JOptionPane.showMessageDialog(this, "You need to specify a list of peptide sequences, one sequence per line!", "No peptide sequences found!", 0);
            return null;
        }
        TreeSet<String> peptides = new TreeSet<String>();
        try {
            BufferedReader br = new BufferedReader(new StringReader(peptidesText));
            String line = null;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                peptides.add(line);
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if ((file = this.getProcessOutputFile()) != null) {
            pt = new PeptideMappingThread(this.iParent, this.iLoader, peptides, filter, file);
        }
        return pt;
    }

    private File getProcessOutputFile() {
        File file = null;
        JFileChooser jfc = new JFileChooser("/");
        jfc.setDialogType(1);
        jfc.setDialogTitle("Output generated DB to...");
        jfc.setApproveButtonToolTipText("Save generated DB to this file.");
        int returnVal = jfc.showSaveDialog(this);
        if (returnVal == 0) {
            file = new File(jfc.getSelectedFile().getAbsoluteFile().toString());
            if (!file.exists()) {
                try {
                    file.createNewFile();
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this.iParent, "The specified file could not be created! (" + ioe.getMessage() + ")", "Error creating output file!", 0);
                    file = null;
                }
            }
        } else {
            file = null;
        }
        return file;
    }
}

