/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui.components;

import com.compomics.dbtoolkit.gui.components.JPanelDataSender;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class FileInputPanel
extends JPanelDataSender {
    private JLabel lblFile = null;
    private JTextField txtFile = null;
    private JButton btnBrowse = null;
    private boolean iTextFieldEditable = true;
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    public static final int DIR_SELECT_DIALOG = Integer.MIN_VALUE;

    public FileInputPanel() {
        this(" File: ");
    }

    public FileInputPanel(String aLabel) {
        this(aLabel, "File selection", 0);
    }

    public FileInputPanel(String aLabel, String aTitle, final int aFileChooserType) {
        if (!aLabel.trim().endsWith(":")) {
            aLabel = aLabel + " : ";
        }
        this.setLayout(new BorderLayout(5, 5));
        this.lblFile = new JLabel(" " + aLabel);
        this.txtFile = new JTextField(15);
        this.txtFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileInputPanel.this.processSubmission();
            }
        });
        this.btnBrowse = new JButton("Browse...");
        this.btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File f;
                File startHere = new File("/");
                if (!FileInputPanel.this.txtFile.getText().trim().equals("") && (f = new File(FileInputPanel.this.txtFile.getText().trim())).exists()) {
                    startHere = f;
                }
                JFileChooser jfc = new JFileChooser(startHere);
                int returnVal = 0;
                if (aFileChooserType == 0) {
                    jfc.setDialogType(0);
                    returnVal = jfc.showOpenDialog(FileInputPanel.this.txtFile);
                } else if (aFileChooserType == 1) {
                    jfc.setDialogType(1);
                    returnVal = jfc.showSaveDialog(FileInputPanel.this.txtFile);
                } else if (aFileChooserType == Integer.MIN_VALUE) {
                    jfc.setDialogType(2);
                    jfc.setFileSelectionMode(1);
                    returnVal = jfc.showDialog(FileInputPanel.this.txtFile, "Select folder");
                } else {
                    returnVal = jfc.showDialog(FileInputPanel.this.txtFile, "Select");
                }
                if (returnVal == 0) {
                    FileInputPanel.this.txtFile.setText(jfc.getSelectedFile().getAbsoluteFile().toString());
                    FileInputPanel.this.processSubmission();
                }
            }
        });
        this.btnBrowse.setMnemonic(66);
        if (aFileChooserType == Integer.MIN_VALUE) {
            this.txtFile.setToolTipText("Enter folder here");
            this.btnBrowse.setToolTipText("Select a folder");
        } else {
            this.txtFile.setToolTipText("Enter filename here + <enter>");
            this.btnBrowse.setToolTipText("Browse for a file");
        }
        this.add((Component)this.lblFile, "West");
        this.add((Component)this.btnBrowse, "East");
        this.add((Component)this.txtFile, "Center");
        this.setBorder(BorderFactory.createTitledBorder(aTitle));
    }

    public void setEnabled(boolean aEnabled) {
        super.setEnabled(aEnabled);
        this.txtFile.setEnabled(aEnabled);
        this.lblFile.setEnabled(aEnabled);
        this.btnBrowse.setEnabled(aEnabled);
    }

    public void textFieldEditable(boolean aEditable) {
        this.txtFile.setEditable(aEditable);
    }

    public void setTextFieldText(String aText) {
        this.txtFile.setText(aText);
    }

    private void processSubmission() {
        super.notifyReceivers(this.txtFile.getText());
    }
}

