/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui.components;

import com.compomics.dbtoolkit.gui.components.FileInputPanel;
import com.compomics.dbtoolkit.gui.interfaces.GUIDataReceiver;
import com.compomics.dbtoolkit.gui.workerthreads.ConcatenateThread;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ConcatenateDialog
extends JDialog
implements GUIDataReceiver {
    private JFrame iParent = null;
    private String iCurrentFile = null;
    private FileInputPanel top = null;
    private FileInputPanel middle = null;
    private FileInputPanel bottom = null;
    private String iFrom1 = null;
    private String iFrom2 = null;
    private String iToAppend = null;

    public ConcatenateDialog(JFrame aParent, String aTitle, String aCurrentFile) {
        super(aParent, aTitle, true);
        this.iParent = aParent;
        this.iCurrentFile = aCurrentFile;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                ConcatenateDialog.this.close();
            }
        });
        this.constructScreen();
        this.setResizable(false);
    }

    public void transmitData(Component aSource, Object aData) {
        if (aSource == this.top) {
            this.iFrom1 = (String)aData;
            this.middle.setEnabled(true);
        } else if (aSource == this.middle) {
            this.iFrom2 = (String)aData;
        } else if (aSource == this.bottom) {
            this.iToAppend = (String)aData;
        }
    }

    private void constructScreen() {
        JPanel main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        this.top = new FileInputPanel("Select first file to append", "First file to append (or file to copy)", 0);
        this.top.addReceiver(this);
        this.top.textFieldEditable(false);
        this.middle = new FileInputPanel("Select second file to append", "Second file to append", 0);
        this.middle.addReceiver(this);
        this.middle.setEnabled(false);
        this.middle.textFieldEditable(false);
        this.bottom = new FileInputPanel("Select output file", "Output file", 1);
        this.bottom.addReceiver(this);
        this.bottom.textFieldEditable(false);
        JPanel buttons = this.getButtonPanel();
        main.add(Box.createRigidArea(new Dimension(this.top.getWidth(), 10)));
        main.add(this.top);
        main.add(Box.createRigidArea(new Dimension(this.top.getWidth(), 5)));
        main.add(this.middle);
        main.add(Box.createRigidArea(new Dimension(this.top.getWidth(), 5)));
        main.add(this.bottom);
        main.add(Box.createRigidArea(new Dimension(this.top.getWidth(), 20)));
        main.add(buttons);
        this.getContentPane().add((Component)main, "Center");
        this.pack();
    }

    private JPanel getButtonPanel() {
        JPanel result = new JPanel();
        result.setLayout(new BoxLayout(result, 0));
        JButton okButton = new JButton("OK");
        okButton.setMnemonic(79);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMnemonic(67);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConcatenateDialog.this.okPressed();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConcatenateDialog.this.cancelPressed();
            }
        });
        okButton.setMaximumSize(okButton.getPreferredSize());
        cancelButton.setMaximumSize(cancelButton.getPreferredSize());
        result.add(Box.createHorizontalGlue());
        result.add(okButton);
        result.add(cancelButton);
        result.add(Box.createRigidArea(new Dimension(15, cancelButton.getHeight())));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void okPressed() {
        File in1 = null;
        File in2 = null;
        File out = null;
        if (this.iFrom1 == null) {
            JOptionPane.showMessageDialog(this, "You need to specify at least one file to read from!", "No input file specified!", 0);
            return;
        }
        if (this.iToAppend == null) {
            JOptionPane.showMessageDialog(this, "You need to specify a file to append to!", "No output file specified!", 0);
            return;
        }
        in1 = new File(this.iFrom1);
        out = new File(this.iToAppend);
        if (!in1.exists()) {
            JOptionPane.showMessageDialog(this, "The input file you specified (" + this.iFrom1 + ") can not be found!", "Input file can not be found!", 0);
            return;
        }
        boolean outputExisted = false;
        try {
            if (!out.exists()) {
                out.createNewFile();
            } else {
                outputExisted = true;
            }
        }
        catch (IOException ioe) {
            JOptionPane.showMessageDialog(this, "The output file you specified (" + this.iToAppend + ") can not be created!", "Output file can not be created!", 0);
            return;
        }
        if (this.iFrom2 != null) {
            in2 = new File(this.iFrom2);
            if (!in2.exists()) {
                JOptionPane.showMessageDialog(this, "The second input file you specified (" + this.iFrom2 + ") can not be found!", "Second input file can not be found!", 0);
                return;
            }
            String thirdLine = null;
            thirdLine = outputExisted ? "(All information in '" + this.iToAppend + "' will be lost!)" : "(Outputting in '" + this.iToAppend + "'.)";
            int reply = JOptionPane.showConfirmDialog(this, new String[]{"You specified two input files!", "Do you wish to concatenate these files into the destination file?", thirdLine}, "Confirm concatenation.", 0, 3);
            if (reply != 0) return;
            ConcatenateThread ct = new ConcatenateThread(in1, in2, out, this.iParent);
            Thread t = new Thread(ct);
            t.start();
            this.close();
            return;
        }
        String thirdLine = null;
        thirdLine = outputExisted ? "(All information in '" + this.iToAppend + "' will be lost!)" : "(Outputting in '" + this.iToAppend + "'.)";
        int reply = JOptionPane.showConfirmDialog(this, new String[]{"You specified only one input file!", "Do you wish to copy this file into the destination file?", thirdLine}, "Confirm copy.", 0, 3);
        if (reply != 0) return;
        ConcatenateThread ct = new ConcatenateThread(in1, out, this.iParent);
        Thread t = new Thread(ct);
        t.start();
        this.close();
    }

    private void cancelPressed() {
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }
}

