/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui.components;

import com.compomics.dbtoolkit.gui.components.FileInputPanel;
import com.compomics.dbtoolkit.gui.interfaces.GUIDataReceiver;
import com.compomics.dbtoolkit.gui.workerthreads.ClearRedundancyThread;
import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ClearRedundancyDialog
extends JDialog
implements GUIDataReceiver {
    private DBLoader iLoader = null;
    private AutoDBLoader iAuto = null;
    private File iOutput = null;
    private File iTempFolder = null;
    private JFrame iParent = null;
    private FileInputPanel top = null;
    private FileInputPanel middle = null;

    public ClearRedundancyDialog(JFrame aParent, String aTitle, DBLoader aLoader, AutoDBLoader aAuto) {
        super(aParent, aTitle, true);
        this.iParent = aParent;
        this.iLoader = aLoader;
        this.iAuto = aAuto;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                ClearRedundancyDialog.this.close();
            }
        });
        this.constructScreen();
        this.setResizable(false);
    }

    public void transmitData(Component aSource, Object aData) {
        if (aSource == this.top) {
            this.iTempFolder = new File((String)aData);
        } else if (aSource == this.middle) {
            this.iOutput = new File((String)aData);
        }
    }

    private void constructScreen() {
        JPanel main = new JPanel();
        main.setLayout(new BoxLayout(main, 1));
        this.top = new FileInputPanel("Specify temporary storage folder here", "Temporary folder", Integer.MIN_VALUE);
        this.top.textFieldEditable(false);
        this.top.addReceiver(this);
        this.middle = new FileInputPanel("Specify output file here", "Output file", 1);
        this.middle.textFieldEditable(false);
        this.middle.addReceiver(this);
        JPanel buttons = this.getButtonPanel();
        main.add(Box.createRigidArea(new Dimension(this.top.getWidth(), 10)));
        main.add(this.top);
        main.add(Box.createRigidArea(new Dimension(this.top.getWidth(), 5)));
        main.add(this.middle);
        main.add(Box.createRigidArea(new Dimension(this.top.getWidth(), 20)));
        main.add(buttons);
        this.getContentPane().add((Component)main, "Center");
        this.pack();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void okPressed() {
        int choice;
        if (this.iTempFolder == null) {
            JOptionPane.showMessageDialog(this, "You need to select a temporary storage folder!", "No temporary folder selected!", 0);
            return;
        }
        if (!this.iTempFolder.isDirectory()) {
            JOptionPane.showMessageDialog(this, "The temporary storage folder has to be a directory!", "Temporary folder selected!", 0);
            return;
        }
        if (this.iOutput == null) {
            JOptionPane.showMessageDialog(this, "You need to select an output file!", "No output file selected!", 0);
            return;
        }
        if (!this.iTempFolder.exists()) {
            JOptionPane.showMessageDialog(this, new String[]{"The temporary storage folder does not exist!", "Please create the folder before procedding!"}, "Temporary folder does not exist!", 0);
            return;
        }
        if (this.iOutput.exists() && (choice = JOptionPane.showConfirmDialog(this, new String[]{"The output file already exists!", "Do you wish to delete all information in file '" + this.iOutput.getAbsolutePath() + "'?"}, "Output file already exists!", 0, 3)) == 1) {
            return;
        }
        ClearRedundancyThread crd = new ClearRedundancyThread(this.iTempFolder, this.iOutput, this.iLoader, this.iAuto, this.iParent);
        Thread t = new Thread(crd);
        t.start();
        this.close();
    }

    private JPanel getButtonPanel() {
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        JButton okButton = new JButton("OK");
        okButton.setMnemonic(79);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClearRedundancyDialog.this.okPressed();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMnemonic(67);
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClearRedundancyDialog.this.close();
            }
        });
        okButton.setMaximumSize(okButton.getPreferredSize());
        cancelButton.setMaximumSize(cancelButton.getPreferredSize());
        buttons.add(Box.createHorizontalGlue());
        buttons.add(okButton);
        buttons.add(cancelButton);
        buttons.add(Box.createRigidArea(new Dimension(15, okButton.getHeight())));
        return buttons;
    }
}

