/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class AboutDialog
extends JDialog {
    private JTextArea txtHelp = null;
    private JButton btnOK = null;
    private JLabel[] lblLabels = null;
    private static JLabel lblImageTools = null;
    private static JLabel lblImageRUG = null;
    private static ImageIcon iRug = null;
    private static String iHelpText = null;
    private static final String TEXTFILE = "about.txt";

    public AboutDialog(JFrame aParent, String aTitle) {
        super(aParent, aTitle, true);
        if (iHelpText == null) {
            this.loadHelpText();
        }
        if (lblImageTools == null || iRug == null) {
            this.loadImages();
        }
        this.constructScreen();
    }

    private void constructScreen() {
        this.txtHelp = new JTextArea(15, 50);
        this.txtHelp.setFont(new Font("Monospaced", 0, 12));
        this.txtHelp.setText(iHelpText);
        this.txtHelp.setCaretPosition(0);
        this.txtHelp.setEditable(false);
        this.btnOK = new JButton("OK");
        this.btnOK.setMnemonic(79);
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.close();
            }
        });
        this.lblLabels = new JLabel[8];
        this.lblLabels[0] = new JLabel("DBToolKit program version " + this.getLastVersion());
        this.lblLabels[1] = new JLabel(" ");
        this.lblLabels[2] = new JLabel("Lennart Martens (lennart.martens@UGent.be)");
        this.lblLabels[3] = new JLabel("          Ghent University (www.UGent.be)");
        this.lblLabels[4] = new JLabel("          FWO Flanders (www.fwo.be)");
        this.lblLabels[5] = new JLabel(" ");
        this.lblLabels[6] = new JLabel("This application is freeware and open source (Apache2 license)");
        this.lblLabels[7] = new JLabel(" ");
        JPanel jpanMain = new JPanel();
        jpanMain.setLayout(new BoxLayout(jpanMain, 1));
        JPanel jpanButton = new JPanel();
        jpanButton.setLayout(new BoxLayout(jpanButton, 0));
        JPanel jpanLabels = new JPanel();
        jpanLabels.setLayout(new BoxLayout(jpanLabels, 0));
        JPanel jpanTextLabels = new JPanel();
        jpanTextLabels.setLayout(new BoxLayout(jpanTextLabels, 1));
        JScrollPane jspText = new JScrollPane(this.txtHelp, 20, 30);
        JPanel jpanScroll = new JPanel();
        jpanScroll.setLayout(new BoxLayout(jpanScroll, 0));
        jpanScroll.add(Box.createRigidArea(new Dimension(20, jspText.getHeight())));
        jpanScroll.add(jspText);
        jpanScroll.add(Box.createRigidArea(new Dimension(20, jspText.getHeight())));
        jpanButton.add(Box.createHorizontalGlue());
        jpanButton.add(this.btnOK);
        jpanButton.add(Box.createRigidArea(new Dimension(15, this.btnOK.getHeight())));
        jpanMain.add(Box.createRigidArea(new Dimension(this.txtHelp.getWidth(), 15)));
        for (int i = 0; i < this.lblLabels.length; ++i) {
            JLabel lLabel = this.lblLabels[i];
            lLabel.setForeground(Color.black);
            jpanTextLabels.add(lLabel);
            jpanTextLabels.add(Box.createRigidArea(new Dimension(this.txtHelp.getWidth(), 5)));
        }
        jpanLabels.add(Box.createRigidArea(new Dimension(20, jpanTextLabels.getHeight())));
        jpanLabels.add(lblImageTools);
        jpanLabels.add(Box.createRigidArea(new Dimension(20, jpanTextLabels.getHeight())));
        jpanLabels.add(jpanTextLabels);
        jpanLabels.add(Box.createRigidArea(new Dimension(20, jpanTextLabels.getHeight())));
        jpanLabels.add(lblImageRUG);
        jpanLabels.add(Box.createRigidArea(new Dimension(20, jpanTextLabels.getHeight())));
        jpanLabels.add(Box.createHorizontalGlue());
        jpanMain.add(jpanLabels);
        jpanMain.add(Box.createRigidArea(new Dimension(this.txtHelp.getWidth(), 20)));
        jpanMain.add(jpanScroll);
        jpanMain.add(Box.createRigidArea(new Dimension(this.txtHelp.getWidth(), 20)));
        jpanMain.add(jpanButton);
        jpanMain.add(Box.createRigidArea(new Dimension(this.txtHelp.getWidth(), 15)));
        this.getContentPane().add((Component)jpanMain, "Center");
        this.pack();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    private void loadHelpText() {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(TEXTFILE);
            if (is == null && (is = ClassLoader.getSystemResourceAsStream(TEXTFILE)) == null) {
                iHelpText = "No help file (about.txt) could be found in the classpath!";
            }
            if (is != null) {
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                StringBuffer sb = new StringBuffer();
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                iHelpText = sb.toString();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void loadImages() {
        URL url;
        lblImageTools = new JLabel("No image found!");
        try {
            url = this.getClass().getClassLoader().getResource("toolbox.jpg");
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                lblImageTools = new JLabel(icon);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            url = this.getClass().getClassLoader().getResource("rugLogo.jpg");
            if (url != null) {
                iRug = new ImageIcon(url);
                lblImageRUG = new JLabel(iRug);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getLastVersion() {
        String result = null;
        int start = iHelpText.lastIndexOf("- Version ") + 10;
        int end = iHelpText.indexOf("\n", start);
        result = start > 0 && end > 0 ? iHelpText.substring(start, end).trim() : "(unknown - missing original help text)!";
        return result;
    }
}

