/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui;

import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class DBToolModel {
    private String iFilename = null;
    private DBLoader iLoader = null;
    private AutoDBLoader iAuto = null;
    private Vector iEntries = null;
    private String iCacheFilename = null;
    private int iNrOfEntries = 2;
    private static String[] iDBNames = null;
    private static Properties iDBLoaders = null;
    private static String[] iDBLoaderClasses = null;

    public DBToolModel() {
        if (iDBLoaders == null || iDBNames == null) {
            this.loadDBs();
        }
        this.iAuto = new AutoDBLoader(this.getAllDBLoaderClassNames());
    }

    public String getFilename() {
        return this.iFilename;
    }

    public void setFilename(String aFilename) {
        this.iFilename = aFilename;
    }

    public int getNrOfEntries() {
        return this.iNrOfEntries;
    }

    public DBLoader getLoader() {
        return this.iLoader;
    }

    public void setLoader(DBLoader aLoader) {
        this.iLoader = aLoader;
    }

    public void setNrOfEntries(int aNrOfEntries) {
        this.iNrOfEntries = aNrOfEntries;
    }

    public String getPreviewText(int aCharsPerLine) throws IOException {
        StringBuffer text = new StringBuffer("");
        if (this.iFilename != null) {
            if (this.iEntries == null || this.iEntries.size() / 2 != this.iNrOfEntries || !this.iFilename.equals(this.iCacheFilename)) {
                this.iLoader.reset();
                this.iEntries = new Vector();
                for (int i = 0; i < this.iNrOfEntries; ++i) {
                    String entry = this.iLoader.nextFASTAEntry();
                    if (entry == null) continue;
                    StringTokenizer lst = new StringTokenizer(entry, "\n");
                    this.iEntries.add(lst.nextToken());
                    this.iEntries.add(lst.nextToken());
                }
                this.iLoader.reset();
                this.iCacheFilename = this.iFilename;
            }
            text = this.reformatCache(aCharsPerLine);
        }
        return text.toString();
    }

    public void clear() {
        this.iEntries = null;
        this.iFilename = null;
        this.iLoader = null;
    }

    public String[] getDBNames() {
        return iDBNames;
    }

    public Properties getALlKnownDBLoaders() {
        return iDBLoaders;
    }

    public String getDBLoaderClassName(String aDBLoaderName) {
        return iDBLoaders.getProperty(aDBLoaderName);
    }

    public String[] getAllDBLoaderClassNames() {
        return iDBLoaderClasses;
    }

    public AutoDBLoader getAutoLoader() {
        return this.iAuto;
    }

    private StringBuffer reformatCache(int aCharsPerLine) {
        StringBuffer result = new StringBuffer();
        aCharsPerLine -= 5;
        int liSize = this.iEntries.size();
        for (int i = 0; i < liSize; ++i) {
            int j;
            int offset;
            StringBuffer lTemp = new StringBuffer((String)this.iEntries.get(i) + "\n");
            if (lTemp.length() > aCharsPerLine) {
                offset = aCharsPerLine - 1;
                j = 0;
                while (true) {
                    int tempOffset;
                    if ((tempOffset = lTemp.toString().lastIndexOf(" ", offset)) > 0) {
                        lTemp.replace(tempOffset, tempOffset + 1, "\n ");
                    } else {
                        lTemp.replace(offset, offset + 1, "\n ");
                    }
                    if ((offset += aCharsPerLine - 1) > lTemp.length()) break;
                    ++j;
                }
            }
            result.append(lTemp.toString());
            lTemp = new StringBuffer((String)this.iEntries.get(++i) + "\n");
            if (lTemp.length() > aCharsPerLine) {
                offset = aCharsPerLine - 1;
                j = 0;
                while (true) {
                    lTemp.insert(offset, "\n");
                    if ((offset += aCharsPerLine) > lTemp.length()) break;
                    ++j;
                }
            }
            result.append(lTemp.toString() + "\n");
        }
        return result;
    }

    private void loadDBs() {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("DBLoaders.properties");
            if (is == null) {
                throw new RuntimeException("Unable to load 'DBLoaders.properties' file from classpath! (File not found)");
            }
            iDBLoaders = new Properties();
            iDBLoaders.load(is);
            is.close();
            Set<Object> s = iDBLoaders.keySet();
            iDBNames = new String[s.size()];
            iDBLoaderClasses = new String[iDBNames.length];
            Iterator<Object> lIterator = s.iterator();
            int counter = 0;
            while (lIterator.hasNext()) {
                String o;
                DBToolModel.iDBNames[counter] = o = (String)lIterator.next();
                ++counter;
            }
            Arrays.sort(iDBNames);
            for (int i = 0; i < iDBNames.length; ++i) {
                String lName = iDBNames[i];
                DBToolModel.iDBLoaderClasses[i] = iDBLoaders.getProperty(lName);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new RuntimeException("Unable to load 'DBLoaders.properties' file from classpath! (" + ioe.getMessage() + ")");
        }
    }
}

