/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui;

import com.compomics.dbtoolkit.gui.DBTool;
import com.compomics.dbtoolkit.gui.DBToolModel;
import com.compomics.dbtoolkit.gui.components.AboutDialog;
import com.compomics.dbtoolkit.gui.components.ClearRedundancyDialog;
import com.compomics.dbtoolkit.gui.components.ConcatenateDialog;
import com.compomics.dbtoolkit.gui.components.PeptideMappingDialog;
import com.compomics.dbtoolkit.gui.components.ProcessDialog;
import com.compomics.dbtoolkit.gui.components.RegularExpressionFilterDialog;
import com.compomics.dbtoolkit.gui.interfaces.GUIDataReceiver;
import com.compomics.dbtoolkit.gui.workerthreads.CounterThread;
import com.compomics.dbtoolkit.gui.workerthreads.FASTAOutputThread;
import com.compomics.dbtoolkit.gui.workerthreads.ShuffleDBThread;
import com.compomics.dbtoolkit.io.DBLoaderFactory;
import com.compomics.dbtoolkit.io.UnknownDBFormatException;
import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.HashMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.border.TitledBorder;

public class DBToolController
implements GUIDataReceiver {
    private DBTool iView = null;
    private DBToolModel iModel = null;

    public DBToolController(DBTool aView) {
        this.iView = aView;
        this.iModel = new DBToolModel();
    }

    void exitTriggered() {
        this.iView.dispose();
        this.iModel = null;
        System.exit(0);
    }

    int getNrOfEntries() {
        return this.iModel.getNrOfEntries();
    }

    public void transmitData(Component aSource, Object aData) {
        if (aSource == this.iView.fip) {
            File file = new File((String)aData);
            if (file.exists()) {
                this.iView.status.setError("None");
                this.iView.status.setStatus("Processing incoming file ('" + aData + "')...");
                this.processIncomingFile((String)aData);
            } else {
                this.showError("File '" + aData + "' was not found!", "File not found!");
                this.clearGUI();
                this.iModel.clear();
            }
        }
    }

    public void processDataTriggered() {
        if (this.iModel.getLoader() != null) {
            ProcessDialog pd = new ProcessDialog(this.iView, "Process data options", this.iModel.getLoader(), this.iModel.getLoader().getDBName());
            pd.setLocation(this.iView.getPoint(4, 4));
            pd.setVisible(true);
        } else {
            this.showError("You need to load a database first!", "No DB file loaded!");
        }
    }

    public void processRegExpFilterTriggered() {
        if (this.iModel.getLoader() != null) {
            RegularExpressionFilterDialog refd = new RegularExpressionFilterDialog(this.iView, "Regular expression subset selection", this.iModel.getLoader(), this.iModel.getLoader().getDBName());
            refd.setLocation(this.iView.getPoint(4, 4));
            refd.setVisible(true);
        } else {
            this.showError("You need to load a database first!", "No DB file loaded!");
        }
    }

    public void processPeptideMappingTriggered() {
        if (this.iModel.getLoader() != null) {
            PeptideMappingDialog pmd = new PeptideMappingDialog(this.iView, "Peptide mapping options", this.iModel.getLoader(), this.iModel.getLoader().getDBName());
            pmd.setLocation(this.iView.getPoint(4, 4));
            pmd.setVisible(true);
        } else {
            this.showError("You need to load a database first!", "No DB file loaded!");
        }
    }

    public void processConcatTriggered() {
        ConcatenateDialog cd = new ConcatenateDialog(this.iView, "Concatenate (or copy - when you select 1 input file)", null);
        cd.setLocation(this.iView.getPoint(4, 4));
        cd.setVisible(true);
    }

    public void requestFASTALines() {
        boolean lbOK = false;
        while (!lbOK) {
            String reply = JOptionPane.showInputDialog(this.iView, "Please specify the number of FASTA entries to display in the preview area.", "Preview area settings", 3);
            try {
                if (reply == null || reply.trim().equals("")) break;
                int nrOfEntries = Integer.parseInt(reply);
                this.iModel.setNrOfEntries(nrOfEntries);
                TitledBorder tbord = (TitledBorder)this.iView.previewPane.getBorder();
                tbord.setTitle("Preview pane (" + nrOfEntries + " FASTA entries)");
                this.prepareAndDisplayPreviewText();
                this.iView.previewPane.repaint();
                lbOK = true;
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog(this.iView, "You must enter a number here!", "Invalid response!", 0);
            }
            catch (IOException ioe) {
                this.showError("Unable to read '" + this.iModel.getLoader().getDBName() + "' formatted file '" + this.iModel.getFilename() + "'!", "Unable to read preview!");
            }
        }
    }

    private void showError(String aMessage, String aTitle) {
        JOptionPane.showMessageDialog(this.iView, aMessage, aTitle, 0);
        this.iView.status.setError(aMessage);
    }

    private void processIncomingFile(String aFilename) {
        try {
            DBLoader loader;
            block15: {
                if (this.iModel.getLoader() != null) {
                    this.iModel.getLoader().close();
                    this.iModel.setLoader(null);
                }
                AutoDBLoader auto = new AutoDBLoader(this.iModel.getAllDBLoaderClassNames());
                loader = null;
                try {
                    loader = auto.getLoaderForFile(aFilename);
                }
                catch (UnknownDBFormatException udfe) {
                    String choice;
                    block16: {
                        choice = (String)JOptionPane.showInputDialog(this.iView, new String[]{"DB format could not be detected automatically!", "Please select the correct format manually.", "\n"}, "DB format unknown!", 3, null, this.iModel.getDBNames(), "FASTA");
                        if (choice == null) break block15;
                        loader = null;
                        try {
                            loader = DBLoaderFactory.getDBLoader(choice);
                        }
                        catch (UnknownDBFormatException udfeIntern) {
                            String className = this.iModel.getDBLoaderClassName(choice);
                            if (className != null) {
                                try {
                                    Class<?> c = Class.forName(className);
                                    Constructor<?> constr = c.getConstructor(new Class[0]);
                                    Object o = constr.newInstance(new Object[0]);
                                    if (o instanceof DBLoader) {
                                        loader = (DBLoader)o;
                                    }
                                }
                                catch (Exception e) {
                                    this.showError("DBLoader for database format '" + choice + "' could not be found!", "Invalid DB format!");
                                    this.iModel.clear();
                                    this.iView.status.setStatus("No file loaded.");
                                }
                            }
                            if (loader != null) break block16;
                            throw udfeIntern;
                        }
                    }
                    if (loader == null) {
                        throw new UnknownDBFormatException(choice);
                    }
                    loader.load(aFilename);
                }
            }
            if (loader != null) {
                String name = loader.getDBName();
                this.iModel.setFilename(aFilename);
                this.iModel.setLoader(loader);
                this.prepareAndDisplayPreviewText();
                this.iView.status.setStatus(name + " formatted file '" + this.iModel.getFilename() + "' loaded.");
            } else {
                this.iView.status.setStatus("No file loaded.");
                this.iModel.clear();
                this.iView.clear();
            }
        }
        catch (IOException ioe) {
            this.showError("File could not be read: " + ioe.getMessage(), "Unable to read file!");
            this.iModel.clear();
            this.clearGUI();
        }
        catch (UnknownDBFormatException udfe) {
            this.showError("Database format was invalid for file '" + this.iModel.getFilename() + "'!", "Invalid DB format!");
            this.iModel.clear();
            this.clearGUI();
        }
    }

    public void prepareAndDisplayPreviewText() throws IOException {
        String previewText = "";
        previewText = this.iModel.getPreviewText(this.iView.getNrOfCharsOnPreviewPane());
        this.iView.preview.setText(previewText);
        this.iView.preview.setCaretPosition(0);
    }

    public void countRequested() {
        if (this.iModel.getFilename() != null) {
            CounterThread ct = new CounterThread(this.iView, this.iModel.getLoader(), this.iModel.getFilename());
            new Thread(ct).start();
        } else {
            this.showError("You need to load a DB file first!", "No DB file loaded!");
        }
    }

    public void triggerResized() {
        try {
            this.prepareAndDisplayPreviewText();
        }
        catch (IOException ioe) {
            this.showError("Unable to retrieve preview for '" + this.iModel.getLoader().getDBName() + "' formatted file '" + this.iModel.getFilename() + "!", "Preview unavailable!");
        }
    }

    public void FASTAOutputRequested() {
        if (this.iModel.getFilename() == null) {
            this.showError("You need to load a DB file first!", "No database loaded!");
        } else {
            boolean lbContinue = true;
            File file = new File("/");
            while (lbContinue) {
                JFileChooser jfc = new JFileChooser(file);
                jfc.setDialogType(1);
                jfc.setDialogTitle("Save as");
                int returnVal = jfc.showSaveDialog(this.iView);
                String result = null;
                if (returnVal == 0) {
                    result = jfc.getSelectedFile().getAbsoluteFile().toString();
                }
                if (result == null) {
                    return;
                }
                file = new File(result);
                if (file.exists()) {
                    int answer = JOptionPane.showConfirmDialog(this.iView, new String[]{"The file '" + file.getAbsoluteFile() + "' already exists!", "Do you want to overwrite?"}, "File already exists!", 0);
                    if (answer != 0) continue;
                    lbContinue = false;
                    continue;
                }
                try {
                    file.createNewFile();
                    lbContinue = false;
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this.iView, "Unable to create the file '" + file.getAbsoluteFile() + "'!", "Unable to create file!", 0);
                }
            }
            try {
                DBLoader loader = this.iModel.getLoader();
                FASTAOutputThread fot = new FASTAOutputThread(this.iView, loader, file);
                Thread t = new Thread(fot);
                t.start();
            }
            catch (Exception ioe) {
                this.showError("Error occurred while attempting to write to DB to FASTA file: '" + ioe.getMessage() + "'", "Unable to create FASTA file!");
            }
        }
    }

    public void replacedOutputRequested() {
        if (this.iModel.getFilename() == null) {
            this.showError("You need to load a DB file first!", "No database loaded!");
        } else {
            boolean lbContinue = true;
            HashMap substitutions = null;
            while (lbContinue) {
                String substString = JOptionPane.showInputDialog(this.iView, new String[]{"Please specify a substitution set", "Example:", "     I,L=1;K,Q=2", "To replace 'I' and 'L' with '1', and 'K' and 'Q' with '2'."}, "Substitution set.", 3);
                if (substString == null || substString.trim().equals("")) {
                    return;
                }
                try {
                    substitutions = FASTAOutputThread.parseSubstitutions(substString.trim());
                    lbContinue = false;
                }
                catch (ParseException pe) {
                    JOptionPane.showMessageDialog(this.iView, new String[]{"Unable to parse the substitution set: " + substString, "Error: " + pe.getMessage(), "At position: " + pe.getErrorOffset() + "."}, "Parsing error!", 2);
                }
            }
            lbContinue = true;
            File file = new File("/");
            while (lbContinue) {
                JFileChooser jfc = new JFileChooser(file);
                jfc.setDialogType(1);
                jfc.setDialogTitle("Save as");
                String result = null;
                int returnVal = jfc.showSaveDialog(this.iView);
                if (returnVal == 0) {
                    result = jfc.getSelectedFile().getAbsoluteFile().toString();
                }
                if (result == null) {
                    return;
                }
                file = new File(result);
                if (file.exists()) {
                    int answer = JOptionPane.showConfirmDialog(this.iView, new String[]{"The file '" + file.getAbsoluteFile() + "' already exists!", "Do you want to overwrite?"}, "File already exists!", 0);
                    if (answer != 0) continue;
                    lbContinue = false;
                    continue;
                }
                try {
                    file.createNewFile();
                    lbContinue = false;
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this.iView, "Unable to create the file '" + file.getAbsoluteFile() + "'!", "Unable to create file!", 0);
                }
            }
            try {
                System.out.println("Should be writing to '" + file.getAbsolutePath() + "'.");
                DBLoader loader = this.iModel.getLoader();
                FASTAOutputThread fot = new FASTAOutputThread((JFrame)this.iView, loader, file, substitutions);
                Thread t = new Thread(fot);
                t.start();
            }
            catch (Exception ioe) {
                this.showError("Error occurred while attempting to write to DB to FASTA file: '" + ioe.getMessage() + "'", "Unable to create FASTA file!");
            }
        }
    }

    public void reversedOutputRequested() {
        if (this.iModel.getFilename() == null) {
            this.showError("You need to load a DB file first!", "No database loaded!");
        } else {
            boolean lbContinue = true;
            File file = new File("/");
            while (lbContinue) {
                JFileChooser jfc = new JFileChooser(file);
                jfc.setDialogType(1);
                jfc.setDialogTitle("Save as");
                String result = null;
                int returnVal = jfc.showSaveDialog(this.iView);
                if (returnVal == 0) {
                    result = jfc.getSelectedFile().getAbsoluteFile().toString();
                }
                if (result == null) {
                    return;
                }
                file = new File(result);
                if (file.exists()) {
                    int answer = JOptionPane.showConfirmDialog(this.iView, new String[]{"The file '" + file.getAbsoluteFile() + "' already exists!", "Do you want to overwrite?"}, "File already exists!", 0);
                    if (answer != 0) continue;
                    lbContinue = false;
                    continue;
                }
                try {
                    file.createNewFile();
                    lbContinue = false;
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this.iView, "Unable to create the file '" + file.getAbsoluteFile() + "'!", "Unable to create file!", 0);
                }
            }
            try {
                DBLoader loader = this.iModel.getLoader();
                ShuffleDBThread sdt = new ShuffleDBThread(loader, file, 1, this.iView);
                Thread t = new Thread(sdt);
                t.start();
            }
            catch (Exception ioe) {
                this.showError("Error occurred while attempting to write the DB to reversed FASTA file: '" + ioe.getMessage() + "'", "Unable to create reversed FASTA file!");
            }
        }
    }

    public void shuffleOutputRequested() {
        if (this.iModel.getFilename() == null) {
            this.showError("You need to load a DB file first!", "No database loaded!");
        } else {
            boolean lbContinue = true;
            File file = new File("/");
            while (lbContinue) {
                JFileChooser jfc = new JFileChooser(file);
                jfc.setDialogType(1);
                jfc.setDialogTitle("Save as");
                String result = null;
                int returnVal = jfc.showSaveDialog(this.iView);
                if (returnVal == 0) {
                    result = jfc.getSelectedFile().getAbsoluteFile().toString();
                }
                if (result == null) {
                    return;
                }
                file = new File(result);
                if (file.exists()) {
                    int answer = JOptionPane.showConfirmDialog(this.iView, new String[]{"The file '" + file.getAbsoluteFile() + "' already exists!", "Do you want to overwrite?"}, "File already exists!", 0);
                    if (answer != 0) continue;
                    lbContinue = false;
                    continue;
                }
                try {
                    file.createNewFile();
                    lbContinue = false;
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this.iView, "Unable to create the file '" + file.getAbsoluteFile() + "'!", "Unable to create file!", 0);
                }
            }
            try {
                DBLoader loader = this.iModel.getLoader();
                ShuffleDBThread sdt = new ShuffleDBThread(loader, file, 0, this.iView);
                Thread t = new Thread(sdt);
                t.start();
            }
            catch (Exception ioe) {
                this.showError("Error occurred while attempting to write the DB to reversed FASTA file: '" + ioe.getMessage() + "'", "Unable to create reversed FASTA file!");
            }
        }
    }

    public void processClearRedTriggered() {
        if (this.iModel.getFilename() == null) {
            this.showError("You need to load a DB file first!", "No database loaded!");
        } else {
            ClearRedundancyDialog crd = new ClearRedundancyDialog(this.iView, "Clear redundancy in DB", this.iModel.getLoader(), this.iModel.getAutoLoader());
            crd.setLocation(this.iView.getPoint(4, 4));
            crd.setVisible(true);
        }
    }

    public void clearGUI() {
        this.iView.clear();
    }

    public void showAbout() {
        AboutDialog ad = new AboutDialog(this.iView, "About DBToolKit");
        ad.setLocation(this.iView.getPoint(2, 2));
        ad.setVisible(true);
    }
}

