/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.gui;

import com.compomics.dbtoolkit.gui.CursorModifiableJFrameImpl;
import com.compomics.dbtoolkit.gui.DBToolController;
import com.compomics.dbtoolkit.gui.components.FileInputPanel;
import com.compomics.dbtoolkit.gui.components.StatusPanel;
import com.compomics.dbtoolkit.gui.interfaces.StatusView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class DBTool
extends CursorModifiableJFrameImpl
implements StatusView {
    StatusPanel status = null;
    FileInputPanel fip = null;
    JTextArea preview = null;
    JScrollPane previewPane = null;
    HashMap lookAndFeels = null;
    private DBToolController iController = new DBToolController(this);
    private static final String WINDOW_ICON = "DBIcon.gif";

    public DBTool(String aName) {
        super(aName);
    }

    public void openWindow() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                DBTool.this.iController.exitTriggered();
            }
        });
        try {
            URL url = this.getClass().getClassLoader().getResource(WINDOW_ICON);
            if (url != null) {
                this.setIconImage(new ImageIcon(url).getImage());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                DBTool.this.iController.triggerResized();
            }
        });
        JMenuBar bar = this.getMenuBarForFrame();
        this.setJMenuBar(bar);
        this.getContentPane().add((Component)this.getScreen(), "Center");
        this.pack();
        this.setSize(this.getWidth() + 5, this.getHeight() + 5);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private JMenuBar getMenuBarForFrame() {
        JMenu file = new JMenu("File");
        file.setMnemonic('f');
        JMenuItem open = new JMenuItem("Process", 80);
        JMenuItem exit = new JMenuItem("Exit", 88);
        open.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBTool.this.iController.processDataTriggered();
            }
        });
        exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBTool.this.iController.exitTriggered();
            }
        });
        file.add(open);
        file.add(exit);
        JMenu settings = new JMenu("Settings");
        settings.setMnemonic(83);
        JMenuItem numFASTALines = new JMenuItem("Preview...");
        numFASTALines.setMnemonic(80);
        numFASTALines.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBTool.this.iController.requestFASTALines();
            }
        });
        JMenu lAndF = new JMenu("Look and feel...");
        lAndF.setMnemonic(76);
        UIManager.LookAndFeelInfo[] lfs = UIManager.getInstalledLookAndFeels();
        this.lookAndFeels = new HashMap(lfs.length);
        JMenuItem[] lafs = new JMenuItem[lfs.length];
        for (int i = 0; i < lfs.length; ++i) {
            final UIManager.LookAndFeelInfo lF = lfs[i];
            lafs[i] = new JMenuItem(lF.getName());
            lafs[i].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DBTool.this.setLAF(lF.getClassName());
                }
            });
            lAndF.add(lafs[i]);
            this.lookAndFeels.put(lF.getName(), lF.getClassName());
        }
        settings.add(lAndF);
        settings.add(numFASTALines);
        JMenu tools = new JMenu("Tools");
        tools.setMnemonic(84);
        JMenuItem tool1 = new JMenuItem("Count DB entries");
        tool1.setMnemonic(69);
        tool1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBTool.this.iController.countRequested();
            }
        });
        JMenuItem toFasta = new JMenuItem("Output as FASTA file...");
        toFasta.setMnemonic(79);
        toFasta.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBTool.this.iController.FASTAOutputRequested();
            }
        });
        JMenuItem toReplacedFasta = new JMenuItem("Output as FASTA file after replacing residues...");
        toReplacedFasta.setMnemonic(79);
        toReplacedFasta.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBTool.this.iController.replacedOutputRequested();
            }
        });
        JMenuItem regExpLimit = new JMenuItem("Filter proteins by regular expression...");
        regExpLimit.setMnemonic(77);
        regExpLimit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBTool.this.iController.processRegExpFilterTriggered();
            }
        });
        JMenuItem toReversedFasta = new JMenuItem("Output as reversed FASTA file...");
        toReversedFasta.setMnemonic(86);
        toReversedFasta.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBTool.this.iController.reversedOutputRequested();
            }
        });
        JMenuItem toShuffledFasta = new JMenuItem("Output as shuffled FASTA file...");
        toShuffledFasta.setMnemonic(83);
        toShuffledFasta.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBTool.this.iController.shuffleOutputRequested();
            }
        });
        JMenuItem concat = new JMenuItem("Concatenate DB's (or copy file)...");
        concat.setMnemonic(67);
        concat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBTool.this.iController.processConcatTriggered();
            }
        });
        JMenuItem pepMap = new JMenuItem("Map peptide list to database...");
        pepMap.setMnemonic(77);
        pepMap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBTool.this.iController.processPeptideMappingTriggered();
            }
        });
        JMenuItem clearRed = new JMenuItem("Clear redundancy in DB...");
        clearRed.setMnemonic(82);
        clearRed.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBTool.this.iController.processClearRedTriggered();
            }
        });
        tools.add(tool1);
        tools.add(toFasta);
        tools.add(toReplacedFasta);
        tools.add(regExpLimit);
        tools.add(toReversedFasta);
        tools.add(toShuffledFasta);
        tools.add(concat);
        tools.add(pepMap);
        tools.add(clearRed);
        JMenu help = new JMenu("Help");
        help.setMnemonic(72);
        JMenuItem about = new JMenuItem("About");
        about.setMnemonic(65);
        about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBTool.this.iController.showAbout();
            }
        });
        help.add(about);
        JMenuBar bar = new JMenuBar();
        bar.add(file);
        bar.add(settings);
        bar.add(tools);
        bar.add(help);
        return bar;
    }

    private JPanel getScreen() {
        JPanel screen = new JPanel(new BorderLayout());
        this.status = new StatusPanel(false);
        this.status.setStatus("No file loaded.");
        this.status.setError("None.");
        this.status.setBorder(BorderFactory.createTitledBorder("Status panel"));
        screen.add((Component)this.status, "South");
        this.fip = new FileInputPanel("Database file");
        this.fip.addReceiver(this.iController);
        screen.add((Component)this.fip, "North");
        this.preview = new JTextArea(20, 120);
        this.preview.setFont(new Font("monospaced", 0, 12));
        this.preview.setEditable(false);
        this.previewPane = new JScrollPane(this.preview);
        this.previewPane.setBorder(BorderFactory.createTitledBorder("Preview pane (" + this.iController.getNrOfEntries() + " FASTA entries)"));
        screen.add((Component)this.previewPane, "Center");
        return screen;
    }

    private void setLAF(String aClassName) {
        try {
            UIManager.setLookAndFeel(aClassName);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Graphics g) {
        this.preview.setBackground(this.getBackground());
        super.paint(g);
    }

    int getNrOfCharsOnPreviewPane() {
        FontMetrics fm = this.preview.getFontMetrics(this.preview.getFont());
        int charWidth = fm.charWidth('W');
        return (this.previewPane.getSize().width - 5) / charWidth;
    }

    public static void main(String[] args) {
        DBTool tool = null;
        try {
            tool = new DBTool("Database Processing Tool");
            tool.openWindow();
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(tool, new String[]{"Fatal exception occurred in program!", "\n", "     " + t.getMessage() + "'!", "\n", "Please contact the author about this if the problem persists.", "\n", "\n"}, "Program unexpectedly terminated!", 0);
            t.printStackTrace();
            System.exit(1);
        }
    }

    Point getPoint(int aFractionWidth, int aFractionHeight) {
        Point p = this.getLocation();
        Point result = new Point(p.x + this.getWidth() / aFractionWidth, p.y + this.getHeight() / aFractionHeight);
        return result;
    }

    public void setStatus(String aStatus) {
        this.status.setStatus(aStatus);
    }

    public void setError(String aError) {
        this.status.setError(aError);
    }

    public void clear() {
        this.preview.setText("");
        this.fip.setTextFieldText("");
        this.setStatus("No file loaded.");
    }
}

