/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.general;

import com.compomics.dbtoolkit.io.UnknownDBFormatException;
import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.util.general.CommandLineParser;
import com.compomics.util.protein.Protein;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;

public class RedundancyClearanceValidator {
    public static void main(String[] args) {
        String[] temp;
        CommandLineParser clp;
        String master;
        if (args == null || args.length == 0) {
            RedundancyClearanceValidator.printUsage();
        }
        if ((master = (clp = new CommandLineParser(args, new String[]{"master"})).getOptionParameter("master")) == null || master.trim().equals("")) {
            System.err.println("\n\nNo 'master' DB present in command-line!");
            RedundancyClearanceValidator.printUsage();
        }
        if ((temp = clp.getParameters()) == null || temp.length == 0) {
            System.err.println("\n\nNo non-redundant DB present in command-line!");
            RedundancyClearanceValidator.printUsage();
        }
        try {
            AutoDBLoader auto = new AutoDBLoader(new String[]{"com.compomics.dbtoolkit.io.implementations.FASTADBLoader", "com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader", "com.compomics.dbtoolkit.io.implementations.ZippedFASTADBLoader", "com.compomics.dbtoolkit.io.implementations.ZippedSwissProtDBLoader"});
            DBLoader loader = auto.getLoaderForFile(temp[0]);
            HashMap<String, String> all = new HashMap<String, String>();
            int counterRead = 0;
            Protein p = null;
            System.out.println("\n\nReading non-redundant DB '" + temp[0] + "'...");
            while ((p = loader.nextProtein()) != null) {
                ++counterRead;
                String tempSeq = p.getSequence().getSequence();
                all.put(tempSeq, "1");
            }
            loader.close();
            System.out.println("Completed reading non-redundant DB.\n\n * Found " + counterRead + " unique sequences.");
            HashMap<String, String> missed = new HashMap<String, String>();
            loader = auto.getLoaderForFile(master);
            p = null;
            int readCounter = 0;
            int foundCounter = 0;
            int missedCounter = 0;
            System.out.println("\n\nVerifying sequences in original DB '" + master + "'...");
            while ((p = loader.nextProtein()) != null) {
                ++readCounter;
                String tempSeq = p.getSequence().getSequence();
                if (all.containsKey(tempSeq)) {
                    ++foundCounter;
                    continue;
                }
                ++missedCounter;
                missed.put(tempSeq, "0");
            }
            loader.close();
            p = null;
            double foundPercent = (double)foundCounter / (double)readCounter * 100.0;
            double missedPercent = (double)missedCounter / (double)readCounter * 100.0;
            System.out.println("\n\n * Read " + readCounter + " sequences.\n");
            System.out.println("   - " + foundCounter + " sequences were found (" + new BigDecimal(foundPercent).setScale(2, 4) + "% of the DB is in the non-redundant.)");
            System.out.println("   - " + missedCounter + " sequences were NOT found (" + new BigDecimal(missedPercent).setScale(2, 4) + "% of the DB is missing in the non-redundant!!)");
            System.out.println("\n * Missed sequences were:\n");
            Iterator iter = missed.keySet().iterator();
            boolean any = false;
            while (iter.hasNext()) {
                any = true;
                System.out.println("\t" + iter.next());
            }
            if (!any) {
                System.out.println("\tNone!");
            }
            System.out.println("\n\nThank you, and goodbye!\n\n");
            all = null;
            missed = null;
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
            ioe.printStackTrace();
            System.exit(1);
        }
        catch (UnknownDBFormatException udfe) {
            System.err.println(udfe.getMessage());
            udfe.printStackTrace();
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.err.println("\n\nUsage:\n\tRedundancyClearanceValidator --master <original_DB> <non_redundant_DB>\n");
        System.exit(1);
    }
}

