/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.general;

import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.util.general.CommandLineParser;
import com.compomics.util.protein.Protein;
import java.util.HashMap;
import java.util.Iterator;

public class ProteinCounter {
    public static void main(String[] args) {
        try {
            String input;
            CommandLineParser clp;
            String[] tempAr;
            if (args == null || args.length == 0) {
                ProteinCounter.printUsage();
            }
            if ((tempAr = (clp = new CommandLineParser(args)).getParameters()) == null || tempAr.length == 0) {
                ProteinCounter.printUsage();
            }
            if ((input = tempAr[0]) == null) {
                ProteinCounter.printUsage();
            }
            boolean verify = false;
            if (clp.getFlags() != null && clp.getFlags().length > 0 && clp.getFlags()[0].trim().equals("v")) {
                verify = true;
            }
            DBLoader loader = new AutoDBLoader(new String[]{"com.compomics.dbtoolkit.io.implementations.FASTADBLoader", "com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader", "com.compomics.dbtoolkit.io.implementations.ZippedFASTADBLoader", "com.compomics.dbtoolkit.io.implementations.ZippedSwissProtDBLoader"}).getLoaderForFile(input);
            Protein p = null;
            HashMap<String, Integer> accessions = new HashMap<String, Integer>();
            int readCounter = 0;
            System.out.println("\n\nReading '" + input + "' with" + (verify ? "" : "out") + " verification...");
            while ((p = loader.nextProtein()) != null) {
                ++readCounter;
                String acc = p.getHeader().getAccession();
                if (accessions.containsKey(acc)) {
                    int current = (Integer)accessions.get(acc);
                    accessions.put(acc, new Integer(++current));
                    continue;
                }
                accessions.put(acc, new Integer(1));
            }
            loader.close();
            System.out.println("\n\nRead " + readCounter + " entries from DB, representing " + accessions.keySet().size() + " unique proteins (by accession number.)\n");
            if (verify) {
                Iterator iter = accessions.values().iterator();
                int temp = 0;
                while (iter.hasNext()) {
                    temp += ((Integer)iter.next()).intValue();
                }
                System.out.println("Verification should yield '0': " + (readCounter - temp) + ".\n\n");
            }
        }
        catch (Exception e) {
            System.err.println("\n\n" + e.getMessage() + "\n");
            e.printStackTrace();
        }
    }

    private static void printUsage() {
        System.err.println("\n\nUsage:\n\tProteinCounter [-v] <input_database>\n");
        System.exit(1);
    }
}

