/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.general;

import com.compomics.dbtoolkit.io.UnknownDBFormatException;
import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.implementations.SequenceRegion;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.util.protein.Protein;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;

public class PeptideSequenceRegionRetriever {
    private DBLoader iLoader = null;

    public PeptideSequenceRegionRetriever(String aDBFilename) throws UnknownDBFormatException, IOException {
        this.iLoader = new AutoDBLoader(new String[]{"com.compomics.dbtoolkit.io.implementations.FASTADBLoader", "com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader", "com.compomics.dbtoolkit.io.implementations.ZippedFASTADBLoader", "com.compomics.dbtoolkit.io.implementations.ZippedSwissProtDBLoader"}).getLoaderForFile(aDBFilename);
    }

    public void close() {
        if (this.iLoader != null) {
            this.iLoader.close();
        }
    }

    public void finalize() {
        this.close();
    }

    public SequenceRegion retrieveSequenceRegion(SequenceRegion aRegion) throws IOException {
        Vector v = new Vector(1);
        v.add(aRegion);
        v = this.retrieveSequenceRegions(v);
        SequenceRegion result = (SequenceRegion)v.get(0);
        return result;
    }

    public Vector retrieveSequenceRegions(Vector aRegions) throws IOException {
        this.iLoader.reset();
        int liSize = aRegions.size();
        HashMap<String, Object> all = new HashMap<String, Object>(liSize);
        for (int i = 0; i < liSize; ++i) {
            Object o = aRegions.elementAt(i);
            if (!(o instanceof SequenceRegion)) continue;
            SequenceRegion s = (SequenceRegion)o;
            s.setQueried(true);
            if (all.containsKey(s.getAccession())) {
                int count;
                Object check = all.get(s.getAccession());
                if (check instanceof Integer) {
                    count = (Integer)check;
                    all.put(s.getAccession() + "\u00a7" + ++count, s);
                    all.put(s.getAccession(), new Integer(count));
                    continue;
                }
                count = 1;
                all.put(s.getAccession() + "\u00a7" + count, check);
                all.put(s.getAccession() + "\u00a7" + ++count, s);
                all.put(s.getAccession(), new Integer(count));
                continue;
            }
            all.put(s.getAccession(), s);
        }
        Protein p = null;
        while ((p = this.iLoader.nextProtein()) != null) {
            String accession = p.getHeader().getAccession();
            if (!all.containsKey(accession)) continue;
            Object stored = all.get(accession);
            if (stored instanceof SequenceRegion) {
                this.processRegionInProtein((SequenceRegion)stored, p);
                continue;
            }
            int count = (Integer)stored;
            for (int i = 1; i <= count; ++i) {
                this.processRegionInProtein((SequenceRegion)all.get(accession + "\u00a7" + i), p);
            }
        }
        return aRegions;
    }

    private void processRegionInProtein(SequenceRegion aRegion, Protein aParent) {
        String temp = aParent.getSequence().getSequence();
        int location = temp.indexOf(aRegion.getQuerySequence());
        if (location < 0) {
            aRegion.setFound(false);
        } else {
            aRegion.setFound(true);
            int startLoc = location - aRegion.getNterminalResidueCount();
            if (startLoc < 0) {
                startLoc = 0;
            }
            aRegion.setNterminalAddition(temp.substring(startLoc, location));
            startLoc = location + aRegion.getQuerySequence().length();
            int endLoc = startLoc + aRegion.getCterminalResidueCount();
            if (endLoc > temp.length()) {
                endLoc = temp.length();
            }
            aRegion.setCterminalAddition(temp.substring(startLoc, endLoc));
        }
    }
}

