/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.general;

import com.compomics.dbtoolkit.io.UnknownDBFormatException;
import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.util.general.CommandLineParser;
import com.compomics.util.protein.Protein;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;

public class PeptideCoverage {
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            PeptideCoverage.printUsage();
        }
        CommandLineParser clp = new CommandLineParser(args, new String[]{"source", "control"});
        String source = null;
        source = clp.getOptionParameter("source");
        if (source == null) {
            System.err.println("\n\nNo protein DB defined as source!");
            PeptideCoverage.printUsage();
        }
        String control = null;
        control = clp.getOptionParameter("control");
        if (control == null) {
            System.err.println("\n\nNo peptide DB defined to check against!");
            PeptideCoverage.printUsage();
        }
        try {
            File sFile = new File(source);
            File cFile = new File(control);
            if (!sFile.exists()) {
                System.err.println("\n\nSource DB '" + source + "' does not exist!\nExiting...\n");
                System.exit(1);
            }
            if (!cFile.exists()) {
                System.err.println("\n\nControl DB '" + control + "' does not exist!\nExiting...\n");
                System.exit(1);
            }
            AutoDBLoader auto = new AutoDBLoader(new String[]{"com.compomics.dbtoolkit.io.implementations.FASTADBLoader", "com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader", "com.compomics.dbtoolkit.io.implementations.ZippedFASTADBLoader", "com.compomics.dbtoolkit.io.implementations.ZippedSwissProtDBLoader"});
            DBLoader proteinDB = auto.getLoaderForFile(sFile.getCanonicalPath());
            HashMap<String, Integer> all = new HashMap<String, Integer>();
            System.out.println("\n\nCollecting all unique accession numbers from source DB (" + source + ")...");
            int accCount = 0;
            Protein temp = null;
            while ((temp = proteinDB.nextProtein()) != null) {
                String accession = temp.getHeader().getAccession();
                all.put(accession, new Integer(0));
                ++accCount;
            }
            System.out.println("All accession numbers read (" + accCount + ").");
            proteinDB.close();
            DBLoader peptideDB = auto.getLoaderForFile(cFile.getCanonicalPath());
            System.out.println("\nCycling peptide database for matches...");
            temp = null;
            int pepCount = 0;
            while ((temp = peptideDB.nextProtein()) != null) {
                String accession = temp.getHeader().getAccession();
                int loc = -1;
                loc = accession.indexOf(" ");
                if (loc >= 0) {
                    accession = accession.substring(0, loc);
                }
                int count = (Integer)all.get(accession);
                all.put(accession, new Integer(++count));
                ++pepCount;
            }
            System.out.println("All peptides cycled (" + pepCount + " entries checked).\nOutputting results...");
            peptideDB.close();
            int missed = 0;
            int exactOne = 0;
            int plusOne = 0;
            int total = 0;
            Iterator iter = all.keySet().iterator();
            block9: while (iter.hasNext()) {
                int value = (Integer)all.get(iter.next());
                total += value;
                switch (value) {
                    case 0: {
                        ++missed;
                        continue block9;
                    }
                    case 1: {
                        ++exactOne;
                        continue block9;
                    }
                }
                ++plusOne;
            }
            System.out.println("\nFound " + missed + " proteins with NO coverage at all,");
            System.out.println("Found " + (exactOne + plusOne) + " proteins which can be found,");
            System.out.println("\t - " + exactOne + " had a single identifying peptide, and");
            System.out.println("\t - " + plusOne + " had more than one identifying peptide.");
            int sum = missed + exactOne + plusOne;
            System.out.println("\nChecksum for proteins (this should be 0): " + accCount + " - " + sum + " = " + (accCount - sum) + ".");
            System.out.println("\nChecksum for peptides (this should be 0): " + pepCount + " - " + total + " = " + (pepCount - total) + ".");
            System.out.println("\nPercentages:");
            double percentMissed = (double)missed / (double)sum * 100.0;
            double percentOnce = (double)exactOne / (double)sum * 100.0;
            double percentPlus = (double)plusOne / (double)sum * 100.0;
            double percentFound = percentOnce + percentPlus;
            System.out.println("\t - " + new BigDecimal(percentMissed).setScale(2, 4) + "% MISSED.");
            System.out.println("\t - " + new BigDecimal(percentFound).setScale(2, 4) + "% FOUND,");
            System.out.println("\t\t - " + new BigDecimal(percentOnce).setScale(2, 4) + "% by one peptide");
            System.out.println("\t\t - " + new BigDecimal(percentPlus).setScale(2, 4) + "% by more than one peptide.");
        }
        catch (IOException ioe) {
            System.err.println("\n\nIOException occurred!\n");
            ioe.printStackTrace();
        }
        catch (UnknownDBFormatException udfe) {
            System.err.println("\n\nUnable to identify DB!\n");
            udfe.printStackTrace();
        }
    }

    private static void printUsage() {
        System.err.println("\n\nUsage:\n\t PeptideCoverage --source <protein_DB> -- control <derived_peptide_DB>\n\n");
        System.exit(1);
    }
}

