/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.general;

import com.compomics.dbtoolkit.io.FilterLoader;
import com.compomics.dbtoolkit.io.UnknownDBFormatException;
import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.dbtoolkit.toolkit.EnzymeDigest;
import com.compomics.util.general.CommandLineParser;
import com.compomics.util.io.MascotEnzymeReader;
import com.compomics.util.protein.AASequenceImpl;
import com.compomics.util.protein.Enzyme;
import com.compomics.util.protein.Header;
import com.compomics.util.protein.Protein;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;

public class NoEnzymeSimulator {
    private String iCenter = null;

    public NoEnzymeSimulator(String aCenter) {
        this.iCenter = aCenter.toUpperCase();
    }

    public String getCenter() {
        return this.iCenter;
    }

    public Protein[] performRagging(Protein aProtein) {
        return this.performRagging(aProtein, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public Protein[] performRagging(Protein aProtein, Enzyme aEnzyme) {
        return this.performRagging(aProtein, aEnzyme, Double.MIN_VALUE, Double.MAX_VALUE);
    }

    public Protein[] performRagging(Protein aProtein, Enzyme aEnzyme, double aLower, double aUpper) {
        Protein[] result = null;
        String sequence = aProtein.getSequence().getSequence();
        int location = -1;
        HashMap all = new HashMap();
        int starting = -1;
        while ((location = sequence.indexOf(this.iCenter, starting)) >= 0) {
            starting = location + 1;
            this.handleNterm(aProtein, all, aEnzyme, location, aLower, aUpper);
            this.handleCterm(aProtein, all, aEnzyme, location, aLower, aUpper);
            this.handleNtermToCterm(aProtein, all, aEnzyme, location, aLower, aUpper);
        }
        result = new Protein[all.values().size()];
        Iterator iter = all.values().iterator();
        int counter = 0;
        while (iter.hasNext()) {
            result[counter] = (Protein)iter.next();
            ++counter;
        }
        return result;
    }

    public Protein[] performRagging(Protein aProtein, double aLower, double aUpper) {
        return this.performRagging(aProtein, null, aLower, aUpper);
    }

    private void handleNterm(Protein aProtein, HashMap aStore, Enzyme aEnzyme, int aLocation, double aLower, double aUpper) {
        String sequence = aProtein.getSequence().getSequence();
        int end = aLocation + this.iCenter.length();
        int start = aLocation;
        boolean lContinue = true;
        int counter = -1;
        while (lContinue) {
            int newStart;
            if ((newStart = start - ++counter) < 0) {
                lContinue = false;
                continue;
            }
            AASequenceImpl seq = new AASequenceImpl(sequence.substring(newStart, end));
            double tempMass = seq.getMass();
            if (tempMass < aLower) continue;
            if (tempMass > aUpper) {
                lContinue = false;
                continue;
            }
            if (aStore.containsKey(seq.getSequence())) continue;
            Header head = (Header)aProtein.getHeader().clone();
            head.setLocation(newStart + 1, end);
            if (aEnzyme != null) {
                this.annotateHeader(head, sequence, seq.getSequence(), aEnzyme);
            }
            aStore.put(seq.getSequence(), new Protein(head, seq));
        }
    }

    private void handleCterm(Protein aProtein, HashMap aStore, Enzyme aEnzyme, int aLocation, double aLower, double aUpper) {
        String sequence = aProtein.getSequence().getSequence();
        int end = aLocation + this.iCenter.length();
        int start = aLocation;
        boolean lContinue = true;
        int counter = -1;
        while (lContinue) {
            int newEnd;
            if ((newEnd = end + ++counter) > sequence.length()) {
                lContinue = false;
                continue;
            }
            AASequenceImpl seq = new AASequenceImpl(sequence.substring(start, newEnd));
            double tempMass = seq.getMass();
            if (tempMass < aLower) continue;
            if (tempMass > aUpper) {
                lContinue = false;
                continue;
            }
            if (aStore.containsKey(seq.getSequence())) continue;
            Header head = (Header)aProtein.getHeader().clone();
            head.setLocation(start + 1, newEnd);
            if (aEnzyme != null) {
                this.annotateHeader(head, sequence, seq.getSequence(), aEnzyme);
            }
            aStore.put(seq.getSequence(), new Protein(head, seq));
        }
    }

    private void handleNtermToCterm(Protein aProtein, HashMap aStore, Enzyme aEnzyme, int aLocation, double aLower, double aUpper) {
        String sequence = aProtein.getSequence().getSequence();
        int start = aLocation;
        int end = aLocation + this.iCenter.length();
        int i = 0;
        while (start - i >= 0) {
            int tempStart = start - i;
            int j = 0;
            while (j + end <= sequence.length()) {
                int tempEnd = end + j;
                AASequenceImpl tempSeq = new AASequenceImpl(sequence.substring(tempStart, tempEnd));
                double tempMass = tempSeq.getMass();
                if (!(tempMass < aLower)) {
                    if (tempMass > aUpper) break;
                    if (!aStore.containsKey(tempSeq.getSequence())) {
                        Header head = (Header)aProtein.getHeader().clone();
                        head.setLocation(tempStart + 1, tempEnd);
                        if (aEnzyme != null) {
                            this.annotateHeader(head, sequence, tempSeq.getSequence(), aEnzyme);
                        }
                        aStore.put(tempSeq.getSequence(), new Protein(head, tempSeq));
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void handleCtermToNterm(Protein aProtein, HashMap aStore, Enzyme aEnzyme, int aLocation, double aLower, double aUpper) {
        String sequence = aProtein.getSequence().getSequence();
        int start = aLocation;
        int end = aLocation + this.iCenter.length();
        int i = 0;
        while (end + i <= sequence.length()) {
            int tempEnd = end + i;
            int j = 0;
            while (start - j >= 0) {
                int tempStart = start - j;
                AASequenceImpl tempSeq = new AASequenceImpl(sequence.substring(tempStart, tempEnd));
                double tempMass = tempSeq.getMass();
                if (!(tempMass < aLower)) {
                    if (tempMass > aUpper) break;
                    if (!aStore.containsKey(tempSeq.getSequence())) {
                        Header head = (Header)aProtein.getHeader().clone();
                        head.setLocation(tempStart + 1, tempEnd);
                        if (aEnzyme != null) {
                            this.annotateHeader(head, sequence, tempSeq.getSequence(), aEnzyme);
                        }
                        aStore.put(tempSeq.getSequence(), new Protein(head, tempSeq));
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void annotateHeader(Header aHeader, String aParentSeq, String aSubSeq, Enzyme aEnzyme) {
        int cleavage = aEnzyme.isEnzymaticProduct(aParentSeq, aSubSeq);
        String descr = aHeader.getDescription();
        switch (cleavage) {
            case 4: {
                if (descr != null) {
                    aHeader.setDescription("(*EE*) " + descr);
                    break;
                }
                aHeader.setRest("(*EE*) " + aHeader.getRest());
                break;
            }
            case 2: {
                if (descr != null) {
                    aHeader.setDescription("(*NE*) " + descr);
                    break;
                }
                aHeader.setRest("(*NE*) " + aHeader.getRest());
                break;
            }
            case 3: {
                if (descr != null) {
                    aHeader.setDescription("(*CE*) " + descr);
                    break;
                }
                aHeader.setRest("(*CE*) " + aHeader.getRest());
                break;
            }
            case 1: {
                if (descr != null) {
                    aHeader.setDescription("(*FE*) " + descr);
                    break;
                }
                aHeader.setRest("(*FE*) " + aHeader.getRest());
            }
        }
    }

    public static void main(String[] args) {
        try {
            DBLoader loader;
            Enzyme enzyme;
            double high;
            double low;
            String sequence;
            String inputDB;
            CommandLineParser clp;
            block33: {
                String[] temp;
                if (args == null || args.length == 0) {
                    NoEnzymeSimulator.printUsage();
                }
                if ((temp = (clp = new CommandLineParser(args, new String[]{"lowMass", "highMass", "enzyme", "sequence", "filter", "filterParam"})).getParameters()) == null || temp.length == 0) {
                    System.err.println("\n\nInput DB was NOT specified!");
                    NoEnzymeSimulator.printUsage();
                }
                if ((inputDB = temp[0]) == null) {
                    System.err.println("\n\nInput DB was NOT specified!");
                    NoEnzymeSimulator.printUsage();
                }
                if ((sequence = clp.getOptionParameter("sequence")) == null) {
                    System.err.println("\n\nSequence was NOT specified!");
                    NoEnzymeSimulator.printUsage();
                }
                String lowMass = clp.getOptionParameter("lowMass");
                low = -1.0;
                if (lowMass != null) {
                    try {
                        low = Double.parseDouble(lowMass);
                    }
                    catch (Exception e) {
                        System.err.println("\n\nLower mass must be a positive decimal number!");
                        NoEnzymeSimulator.printUsage();
                    }
                }
                String highMass = clp.getOptionParameter("highMass");
                high = -1.0;
                if (highMass != null) {
                    try {
                        high = Double.parseDouble(highMass);
                    }
                    catch (Exception e) {
                        System.err.println("\n\nUpper mass must be a positive decimal number!");
                        NoEnzymeSimulator.printUsage();
                    }
                }
                String enz = clp.getOptionParameter("enzyme");
                enzyme = null;
                if (enz != null) {
                    try {
                        InputStream in = EnzymeDigest.class.getClassLoader().getResourceAsStream("enzymes.txt");
                        if (in != null) {
                            MascotEnzymeReader mer = new MascotEnzymeReader(in);
                            enzyme = mer.getEnzyme(enz);
                            if (enzyme == null) {
                                System.err.println("The enzyme you specified (" + enz + ") was not found in the Mascot Enzymefile '" + EnzymeDigest.class.getClassLoader().getResource("enzymes.txt") + "'!");
                            }
                            break block33;
                        }
                        throw new IOException("File 'enzymes.txt' not found in current classpath!");
                    }
                    catch (IOException ioe) {
                        System.err.println("You specified enzyme '" + enz + "' for cleavage, but the Mascot Enzyme file was not found: " + ioe.getMessage());
                    }
                }
            }
            if ((loader = new AutoDBLoader(new String[]{"com.compomics.dbtoolkit.io.implementations.FASTADBLoader", "com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader", "com.compomics.dbtoolkit.io.implementations.ZippedFASTADBLoader", "com.compomics.dbtoolkit.io.implementations.ZippedSwissProtDBLoader"}).getLoaderForFile(inputDB)) == null) {
                System.err.println("\n\nUnable to find loader for database '" + inputDB + "'!\nExiting.\n\n");
                System.exit(1);
            }
            String filterName = clp.getOptionParameter("filter");
            Filter filter = null;
            if (filterName != null) {
                filter = FilterLoader.loadFilter(filterName, clp.getOptionParameter("filterParam"), loader);
            }
            NoEnzymeSimulator nes = new NoEnzymeSimulator(sequence);
            Protein current = null;
            current = filter == null ? loader.nextProtein() : loader.nextFilteredProtein(filter);
            while (current != null) {
                Protein[] result = null;
                if (enzyme != null) {
                    if (low > 0.0 || high > 0.0) {
                        if (low < 0.0) {
                            low = 0.0;
                        }
                        if (high < 0.0) {
                            high = Double.MAX_VALUE;
                        }
                        result = nes.performRagging(current, enzyme, low, high);
                    } else {
                        result = nes.performRagging(current, enzyme);
                    }
                } else if (enzyme == null && (low > 0.0 || high > 0.0)) {
                    if (low < 0.0) {
                        low = 0.0;
                    }
                    if (high < 0.0) {
                        high = Double.MAX_VALUE;
                    }
                    result = nes.performRagging(current, low, high);
                } else {
                    result = nes.performRagging(current);
                }
                for (int i = 0; i < result.length; ++i) {
                    Protein lProtein = result[i];
                    System.out.print(lProtein.getHeader().getFullHeaderWithAddenda() + "\n" + lProtein.getSequence().getSequence() + "\n");
                }
                if (filter == null) {
                    current = loader.nextProtein();
                    continue;
                }
                current = loader.nextFilteredProtein(filter);
            }
        }
        catch (IOException ioe) {
            System.err.println("\n\n" + ioe.getMessage() + "\n");
            ioe.printStackTrace();
        }
        catch (UnknownDBFormatException udfe) {
            System.err.println("\n\n" + udfe.getMessage() + "!\nExiting.\n\n");
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.err.println("\n\nUsage:\n\tNoEnzymeSimulator [--lowMass <lower_mass_limit> --highMass <upper_mass_limit> --enzyme <enzyme_name> --filter <filter_name> [--filterParam <filter_parameter>]] --sequence <center_sequence> <input_DB>\n\n");
        System.exit(1);
    }
}

