/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit;

import com.compomics.dbtoolkit.io.UnknownDBFormatException;
import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.util.general.CommandLineParser;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class DBConverter {
    private AutoDBLoader iAutoDBLoader = null;

    public DBConverter() {
        Properties p = null;
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("DBLoaders.properties");
            p = new Properties();
            if (is != null) {
                p.load(is);
                is.close();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (p == null || p.size() == 0) {
            System.out.println("\t - Unable to find 'DBLoaders.properties' file, defaulting to built-in types (SwissProt & FASTA only!)...");
            p = new Properties();
            p.put("1", "com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader");
            p.put("2", "com.compomics.dbtoolkit.io.implementations.FASTADBLoader");
        }
        String[] classNames = new String[p.size()];
        Iterator<Object> it = p.values().iterator();
        int counter = 0;
        while (it.hasNext()) {
            classNames[counter] = (String)it.next();
            ++counter;
        }
        this.iAutoDBLoader = new AutoDBLoader(classNames);
    }

    public void toFASTAFile(String aInputFilename, String aOutputFilename) {
        try {
            DBLoader db = this.iAutoDBLoader.getLoaderForFile(aInputFilename);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(aOutputFilename)));
            String fastaLine = null;
            while ((fastaLine = db.nextFASTAEntry()) != null) {
                pw.print(fastaLine);
            }
            db = null;
            pw.flush();
            pw.close();
        }
        catch (UnknownDBFormatException udfe) {
            System.err.println(udfe.getMessage());
        }
        catch (IOException ioe) {
            System.err.println("An IOException occurred while trying to convert the '" + aInputFilename + "' DB file to FASTA format.\n");
            ioe.printStackTrace();
        }
    }

    public void toFilteredFASTAFile(Filter aFilter, String aInputFilename, String aOutputFilename) {
        try {
            DBLoader db = this.iAutoDBLoader.getLoaderForFile(aInputFilename);
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(aOutputFilename)));
            String fastaLine = null;
            while ((fastaLine = db.nextFilteredFASTAEntry(aFilter)) != null) {
                pw.print(fastaLine);
            }
            db = null;
            pw.flush();
            pw.close();
        }
        catch (UnknownDBFormatException udfe) {
            System.err.println(udfe.getMessage());
        }
        catch (IOException ioe) {
            System.err.println("An IOException occurred while trying to convert the '" + aInputFilename + "' DB file to FASTA format.\n");
            ioe.printStackTrace();
        }
    }

    public static void main(String[] args) {
        boolean INPUT = false;
        boolean OUTPUT = true;
        String FILTER = "filter";
        String FILTERPARAM = "filterParam";
        String[] FORMATS = new String[]{"SwissProt", "FASTA"};
        DBConverter dbConv = new DBConverter();
        CommandLineParser clp = new CommandLineParser(args, new String[]{"filter", "filterParam"});
        String[] params = clp.getParameters();
        String filterID = clp.getOptionParameter("filter");
        String filterParam = clp.getOptionParameter("filterParam");
        if (params == null || params.length != 2) {
            System.err.println("\nUsage:\n\n\tDBConverter [--filter <filterName> [--filterParam <filter_parameter>]] <inputfile> <outputfile>\n\n");
            System.err.println();
            System.exit(1);
        } else if (filterID == null) {
            try {
                System.out.println("\nConverting...");
                dbConv.toFASTAFile(params[0], params[1]);
                System.out.println("Done.\n");
            }
            catch (Exception e) {
                System.err.println("\n" + e.getMessage());
                e.printStackTrace();
            }
        } else {
            Filter f = null;
            try {
                Properties props = new Properties();
                InputStream in = DBConverter.class.getClassLoader().getResourceAsStream("filters.properties");
                if (in == null) {
                    throw new IOException("File 'filters.properties' not found in current classpath!");
                }
                props.load(in);
                String filterParams = props.getProperty(filterID);
                if (filterParams == null) {
                    DBConverter.flagError("The filter you specified (" + filterID + ") is not found in the 'filters.properties' file!");
                }
                StringTokenizer st = new StringTokenizer(filterParams, ",");
                String filterClass = st.nextToken().trim();
                String filterDB = st.nextToken().trim();
                try {
                    Constructor<?> constr = null;
                    int type = 0;
                    Class<?> lClass = Class.forName(filterClass);
                    if (lClass == null) {
                        DBConverter.flagError("The class '" + filterClass + "' for your filter '" + filterID + "' could not be found! Check your clasppath setting!");
                    }
                    if (filterParam == null) {
                        try {
                            constr = lClass.getConstructor(new Class[0]);
                        }
                        catch (Exception exc) {
                            // empty catch block
                        }
                        type = 1;
                    } else if (filterParam.startsWith("!")) {
                        try {
                            constr = lClass.getConstructor(String.class, Boolean.TYPE);
                        }
                        catch (Exception exc) {
                            // empty catch block
                        }
                        type = 2;
                    } else {
                        try {
                            constr = lClass.getConstructor(String.class);
                        }
                        catch (Exception exc) {
                            // empty catch block
                        }
                        type = 3;
                    }
                    if (constr == null) {
                        DBConverter.flagError("The '" + filterID + "' filter does not support the " + (filterParam != null ? "presence" : "absence") + " of a" + (filterParam != null && filterParam.startsWith("!") ? "n inverted " : " ") + "parameter!");
                    } else {
                        f = type == 1 ? (Filter)constr.newInstance(new Object[0]) : (type == 2 ? (Filter)constr.newInstance(filterParam.substring(1), new Boolean(true)) : (Filter)constr.newInstance(filterParam));
                    }
                    System.out.println("\nConverting...");
                    dbConv.toFilteredFASTAFile(f, params[0], params[1]);
                    System.out.println("Done.\n");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DBConverter.flagError("Unable to load class '" + filterClass + "' for your filter '" + filterID + "': " + e.getMessage());
                }
            }
            catch (IOException ioe) {
                DBConverter.flagError("You specified a filter (" + filterID + "), but the filter configuration file was not found: " + ioe.getMessage());
            }
        }
    }

    private static void flagError(String aMessage) {
        System.err.println("\n\n" + aMessage + "\n\n");
        System.exit(1);
    }
}

