/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit;

import com.compomics.dbtoolkit.io.UnknownDBFormatException;
import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.util.general.CommandLineParser;
import com.compomics.util.io.MascotEnzymeReader;
import com.compomics.util.protein.Enzyme;
import com.compomics.util.protein.Protein;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;

public class CalculateDistributions {
    private String iInputFile = null;
    private int iLengthInterval = 0;
    private double iMassInterval = 0.0;
    private Enzyme iEnzyme = null;

    public CalculateDistributions(String aInputFile, int aLengthInterval, double aMassInterval) {
        this(aInputFile, aLengthInterval, aMassInterval, null);
    }

    public CalculateDistributions(String aInputFile, int aLengthInterval, double aMassInterval, Enzyme aEnzyme) {
        this.iInputFile = aInputFile;
        this.iLengthInterval = aLengthInterval;
        this.iMassInterval = aMassInterval;
        this.iEnzyme = aEnzyme;
    }

    public void calculateDistribution() throws IOException, UnknownDBFormatException {
        File input = new File(this.iInputFile);
        String parent = input.getParent();
        String core = input.getName();
        core = core.substring(0, core.lastIndexOf(46));
        File outputMass = new File(parent + "/massDistrib_" + core + ".csv");
        File outputLength = new File(parent + "/lengthDistrib_" + core + ".csv");
        input = null;
        DBLoader loader = new AutoDBLoader(new String[]{"com.compomics.dbtoolkit.io.implementations.FASTADBLoader", "com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader"}).getLoaderForFile(this.iInputFile);
        PrintWriter lengthWriter = new PrintWriter(new FileWriter(outputLength));
        PrintWriter massWriter = new PrintWriter(new FileWriter(outputMass));
        lengthWriter.print(";# Residues;Count;(interval:" + this.iLengthInterval + " residues)\n");
        massWriter.print(";Mass (Da);Count;(interval:" + this.iMassInterval + " Da)\n");
        HashMap massMap = new HashMap();
        HashMap lengthMap = new HashMap();
        Protein protein = null;
        while ((protein = loader.nextProtein()) != null) {
            Protein[] interMed = null;
            interMed = this.iEnzyme != null ? this.iEnzyme.cleave(protein) : new Protein[]{protein};
            for (int i = 0; i < interMed.length; ++i) {
                Protein lProtein = interMed[i];
                this.getData(lProtein, lengthMap, massMap);
            }
        }
        loader.close();
        loader = null;
        this.outputLengthData(lengthWriter, lengthMap);
        this.outputMassData(massWriter, massMap);
        lengthWriter.flush();
        lengthWriter.close();
        massWriter.flush();
        massWriter.close();
    }

    private void outputLengthData(PrintWriter aOut, HashMap aData) {
        Set keys = aData.keySet();
        Long[] allKeys = new Long[keys.size()];
        keys.toArray(allKeys);
        Arrays.sort(allKeys, new Comparator(){

            public int compare(Object o1, Object o2) {
                long l1 = (Long)o1;
                long l2 = (Long)o2;
                return (int)(l1 - l2);
            }
        });
        for (int i = 0; i < allKeys.length; ++i) {
            Long lKey = allKeys[i];
            aOut.print(";" + lKey * (long)this.iLengthInterval + ";" + aData.get(lKey) + "\n");
        }
    }

    private void outputMassData(PrintWriter aOut, HashMap aData) {
        Set keys = aData.keySet();
        Long[] allKeys = new Long[keys.size()];
        keys.toArray(allKeys);
        Arrays.sort(allKeys, new Comparator(){

            public int compare(Object o1, Object o2) {
                long l1 = (Long)o1;
                long l2 = (Long)o2;
                return (int)(l1 - l2);
            }
        });
        for (int i = 0; i < allKeys.length; ++i) {
            Long lKey = allKeys[i];
            aOut.print(";" + (double)lKey.longValue() * this.iMassInterval + ";" + aData.get(lKey) + "\n");
        }
    }

    private void getData(Protein aProtein, HashMap aLengthMap, HashMap aMassMap) {
        long length = aProtein.getLength();
        double mass = aProtein.getMass();
        Long lengthPos = new Long(length / (long)this.iLengthInterval);
        Long massPos = new Long((long)(mass / this.iMassInterval));
        Long lengthCount = (Long)aLengthMap.get(lengthPos);
        Long massCount = (Long)aMassMap.get(massPos);
        lengthCount = lengthCount != null ? new Long(lengthCount + 1L) : new Long(1L);
        massCount = massCount != null ? new Long(massCount + 1L) : new Long(1L);
        aLengthMap.put(lengthPos, lengthCount);
        aMassMap.put(massPos, massCount);
    }

    public static void main(String[] args) {
        String mass;
        if (args == null || args.length == 0) {
            System.err.println("\n\nUsage:\n\tCalculateDistributions [--length <length_interval>] [--mass <mass_interval>] [--enzyme <enzyme_name> [--mc <miscleavagecount>]] <inputFile>\n");
            System.exit(1);
        }
        CommandLineParser clp = new CommandLineParser(args, new String[]{"length", "mass", "enzyme", "mc"});
        String[] params = clp.getParameters();
        String length = clp.getOptionParameter("length");
        if (length == null) {
            length = "1";
        }
        if ((mass = clp.getOptionParameter("mass")) == null) {
            mass = "0.6";
        }
        String enz = clp.getOptionParameter("enzyme");
        String mc = clp.getOptionParameter("mc");
        if (mc == null) {
            mc = "1";
        }
        try {
            Enzyme enzyme = null;
            if (enz != null) {
                MascotEnzymeReader mer = new MascotEnzymeReader(CalculateDistributions.class.getClassLoader().getResourceAsStream("enzymes.txt"));
                enzyme = mer.getEnzyme(enz);
                enzyme.setMiscleavages(Integer.parseInt(mc));
                System.out.println(enzyme.toString());
            }
            System.out.println("Length interval: " + length);
            System.out.println("Mass interval: " + mass);
            System.out.println("Input file: '" + params[0] + "'.");
            CalculateDistributions cd = new CalculateDistributions(params[0], Integer.parseInt(length), Double.parseDouble(mass), enzyme);
            cd.calculateDistribution();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

