#!/usr/bin/perl

# converts the MUMmer-nucmer coords file in a file readable for Artemis Comparison Tool
# Output format is like crunch of BLAST
#
# [nov 2010] Galaxy wrapped up version
#
# Alex.Bossers@wur.nl


use warnings;
use strict;

#$filename=shift;
   #$ARGV[0] =~ m/^([A-Z0-9_.-]+)$/ig;
my $filename = $ARGV[0];
   #$ARGV[1] =~ m/^([A-Z0-9_.-]+)$/ig;
my $fileout = $ARGV[1];
#my $filename	=	"Curated_vs_noncurated_8067_01.nucmer.coords";
#my $fileout	=	"Curated_vs_noncurated_8067_01.nucmer.tab";

open (COORDS,$filename) || die "error opening input coords file";
open (OUT,">$fileout") || die "error opening tab output file";

while (<COORDS>)
         {
    unless ($_ =~ /^(\s*)\d/){next}
    $_ =~ s/\|//g;

    my @f = split;
          # create crude match score = ((length_of_match * %identity)-(length_of_match * (100 - %identity))) /20
    my $crude_plus_score=($f[4]*$f[6]);
    my $crude_minus_score=($f[4]*(100-$f[6]));
    my $crude_score=  int(($crude_plus_score  - $crude_minus_score) / 20);
          # reorganise columns and print crunch format to stdout
          # score        %id   S1    E1    seq1  S2    E2    seq2  (description)
    print OUT " $crude_score $f[6] $f[0] $f[1] $f[7] $f[2] $f[3] $f[8] nucmer comparison coordinates\n"
         }

close (COORDS);
close (OUT);
print "Done!\n\n";
